/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.utils;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.TFGTags;

public class PlanetEnvironmentalHelpers {
    private static final Map<ResourceKey<Biome>, MarsSandBlockType> marsBiomeTags = new HashMap<ResourceKey<Biome>, MarsSandBlockType>();

    public static Block getSandBlockForBiome(LevelReader level, BlockPos pos) {
        Holder currentBiome = level.m_204166_(pos);
        ResourceKey biomeKey = currentBiome.m_203543_().orElse(null);
        if (biomeKey == null) {
            TFGCore.LOGGER.warn("{} is missing a sand wind biome tag! falling back to medium sand wind", (Object)biomeKey.m_135782_());
            return MarsSandBlockType.MEDIUM.getPileBlock();
        }
        if (!marsBiomeTags.containsKey(biomeKey)) {
            if (currentBiome.m_203656_(TFGTags.Biomes.HasDarkSandWind)) {
                marsBiomeTags.put((ResourceKey<Biome>)((ResourceKey)currentBiome.m_203543_().orElseThrow()), MarsSandBlockType.DEEP);
            } else if (currentBiome.m_203656_(TFGTags.Biomes.HasLightSandWind)) {
                marsBiomeTags.put((ResourceKey<Biome>)((ResourceKey)currentBiome.m_203543_().orElseThrow()), MarsSandBlockType.LIGHT);
            } else {
                marsBiomeTags.put((ResourceKey<Biome>)((ResourceKey)currentBiome.m_203543_().orElseThrow()), MarsSandBlockType.MEDIUM);
            }
        }
        Block pile = marsBiomeTags.get(biomeKey).getPileBlock();
        return pile;
    }

    public static enum MarsSandBlockType {
        DEEP((Block)TFGBlocks.HEMATITIC_SAND_PILE_BLOCK.get()),
        MEDIUM((Block)TFGBlocks.MARS_SAND_PILE_BLOCK.get()),
        LIGHT((Block)TFGBlocks.VENUS_SAND_PILE_BLOCK.get());

        private static final MarsSandBlockType[] VALUES;
        private final Block pileBlock;

        private MarsSandBlockType(Block pileBlock) {
            this.pileBlock = pileBlock;
        }

        @Generated
        public Block getPileBlock() {
            return this.pileBlock;
        }

        static {
            VALUES = MarsSandBlockType.values();
        }
    }
}

