/*
 * Decompiled with CFR 0.152.
 */
package com.github.themrmilchmann.fency.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber
public final class FencyConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Behavior> defaultBehavior;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> blocklist;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> allowlist;
    @Nullable
    private static Set<? extends ResourceLocation> _blocklist;
    @Nullable
    private static Set<? extends ResourceLocation> _allowlist;

    public static Set<? extends ResourceLocation> getBlocklist() {
        return Objects.requireNonNull(_blocklist, "Requested blocklist before config was loaded");
    }

    public static Set<? extends ResourceLocation> getAllowlist() {
        return Objects.requireNonNull(_allowlist, "Requested allowlist before config was loaded");
    }

    private static void processConfig() {
        List blocklist = (List)FencyConfig.blocklist.get();
        List allowlist = (List)FencyConfig.allowlist.get();
        _blocklist = blocklist.stream().map(ResourceLocation::parse).collect(Collectors.toUnmodifiableSet());
        _allowlist = allowlist.stream().map(ResourceLocation::parse).collect(Collectors.toUnmodifiableSet());
        Set duplicates = _blocklist.stream().filter(it -> _allowlist.contains(it)).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            StringBuilder sb = new StringBuilder("[The Fence Unleashed] Duplicate entries found in block- and allowlist:");
            for (ResourceLocation duplicate : duplicates) {
                sb.append("\n\t - ").append(duplicate);
            }
            sb.append("\nPlease resolve these configuration issues before restarting.");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent.Loading event) {
        FencyConfig.processConfig();
    }

    @SubscribeEvent
    public static void onConfigReloaded(ModConfigEvent.Reloading event) {
        FencyConfig.processConfig();
    }

    static {
        ModConfigSpec.Builder bConfigSpec = new ModConfigSpec.Builder();
        defaultBehavior = bConfigSpec.comment("The default behavior for entities trying to pass through fence gates.\n\nPossible values:\n    ALLOW - Entities may pass through fence gates by default. Exceptions may be added to the blocklist.\n    BLOCK - Entities are blocked from passing through fence gates by default. Exceptions may be added to the allowlist.\n    CHECK - An algorithm is used to determine if an entity should be able to pass through fence gates on a best-effort basis.\n            Exceptions can be added to the allow- or blocklist to respectively allow entities to or block them from passing.\n").defineEnum("defaultBehavior", (Enum)Behavior.CHECK);
        blocklist = bConfigSpec.comment("Entities that are always blocked from passing through fence gates.").defineListAllowEmpty("blocklist", Collections::emptyList, () -> "", it -> it instanceof String && ResourceLocation.tryParse((String)((String)it)) != null);
        allowlist = bConfigSpec.comment("Entities that are always allowed to pass through fence gates.").defineListAllowEmpty("allowlist", () -> List.of("minecolonies:citizen", "minecolonies:visitor"), () -> "", it -> it instanceof String && ResourceLocation.tryParse((String)((String)it)) != null);
        SPEC = bConfigSpec.build();
    }

    public static enum Behavior {
        ALLOW,
        BLOCK,
        CHECK;

    }
}

