/*
 * Decompiled with CFR 0.152.
 */
package com.github.themrmilchmann.fency;

import com.github.themrmilchmann.fency.advancements.critereon.FencyCriteriaTriggers;
import com.github.themrmilchmann.fency.config.FencyConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fency")
public final class Fency {
    public static final String MOD_ID = "fency";
    private static final Logger LOGGER = LogManager.getLogger((String)"fency");
    private static final Set<ResourceLocation> imcAllowlist = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> imcBlocklist = new HashSet<ResourceLocation>();

    public Fency(ModContainer container, IEventBus eventBus) {
        FencyCriteriaTriggers.TRIGGER_TYPES.register(eventBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FencyConfig.SPEC, "the-fence-unleashed.toml");
        FencyCriteriaTriggers.init();
        eventBus.addListener(this::onIMCProcessEvent);
    }

    public static boolean isAllowed(ResourceLocation rl) {
        Set<? extends ResourceLocation> cfgAllowlist = FencyConfig.getAllowlist();
        Set<? extends ResourceLocation> cfgBlocklist = FencyConfig.getBlocklist();
        return cfgAllowlist.contains(rl) || !cfgBlocklist.contains(rl) && imcAllowlist.contains(rl);
    }

    public static boolean isBlocked(ResourceLocation rl) {
        Set<? extends ResourceLocation> cfgAllowlist = FencyConfig.getAllowlist();
        Set<? extends ResourceLocation> cfgBlocklist = FencyConfig.getBlocklist();
        return cfgBlocklist.contains(rl) || !cfgAllowlist.contains(rl) && imcBlocklist.contains(rl);
    }

    private void onIMCProcessEvent(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            String method;
            switch (method = message.method()) {
                case "addToAllowlist": {
                    ResourceLocation rl = (ResourceLocation)message.messageSupplier().get();
                    if (imcBlocklist.contains(rl)) {
                        throw new IllegalArgumentException("[The Fence Unleashed] Entry cannot be added to allowlist as it's already explicitly blocked: " + String.valueOf(rl));
                    }
                    imcAllowlist.add(rl);
                    break;
                }
                case "addToBlocklist": {
                    ResourceLocation rl = (ResourceLocation)message.messageSupplier().get();
                    if (imcAllowlist.contains(rl)) {
                        throw new IllegalArgumentException("[The Fence Unleashed] Entry cannot be added to blocklist as it's already explicitly allowed: " + String.valueOf(rl));
                    }
                    imcBlocklist.add(rl);
                    break;
                }
                default: {
                    LOGGER.warn("Received IMC message for unknown method '" + message.method() + "' from mod: " + message.senderModId());
                }
            }
        });
    }
}

