/*
 * Decompiled with CFR 0.152.
 */
package com.github.themrmilchmann.fency.mixins;

import com.github.themrmilchmann.fency.Fency;
import com.github.themrmilchmann.fency.advancements.critereon.FencyCriteriaTriggers;
import com.github.themrmilchmann.fency.config.FencyConfig;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.NotImplementedException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceGateBlock.class})
public final class FenceGateBlockMixin {
    private static final UUID PROFILE_UUID = UUID.randomUUID();
    private static final GameProfile PROFILE = new GameProfile(PROFILE_UUID, "[Fency]");

    @Accessor(value="SHAPE_COLLISION")
    private static Map<Direction.Axis, VoxelShape> SHAPE_COLLISION() {
        throw new NotImplementedException("FenceGateBlock#SHAPE_COLLISION mixin failed to apply");
    }

    @Inject(at={@At(value="HEAD")}, method={"getCollisionShape"}, cancellable=true)
    public void getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext, CallbackInfoReturnable<VoxelShape> ci) {
        Mob mob;
        if (!((Boolean)state.getValue((Property)FenceGateBlock.OPEN)).booleanValue() || !(collisionContext instanceof EntityCollisionContext)) {
            return;
        }
        EntityCollisionContext entityCollisionContext = (EntityCollisionContext)collisionContext;
        Entity entity = entityCollisionContext.getEntity();
        if (entity == null) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            assert (FencyCriteriaTriggers.ENTER_FENCE_GATE != null);
            FencyCriteriaTriggers.ENTER_FENCE_GATE.get().trigger(player);
        }
        ResourceLocation entityTypeID = EntityType.getKey((EntityType)entity.getType());
        boolean isBlocked = Fency.isBlocked(entityTypeID);
        boolean isAllowed = Fency.isAllowed(entityTypeID);
        Direction.Axis axis = ((Direction)state.getValue((Property)FenceGateBlock.FACING)).getAxis();
        if (isBlocked || !isAllowed && FencyConfig.defaultBehavior.get() == FencyConfig.Behavior.BLOCK) {
            ci.setReturnValue((Object)FenceGateBlockMixin.SHAPE_COLLISION().get(axis));
            return;
        }
        if (isAllowed || FencyConfig.defaultBehavior.get() == FencyConfig.Behavior.ALLOW) {
            ci.setReturnValue((Object)Shapes.empty());
            return;
        }
        HashSet<Entity> visitedEntities = new HashSet<Entity>();
        while (true) {
            LivingEntity tmp;
            if (visitedEntities.contains(entity)) {
                ci.setReturnValue((Object)FenceGateBlockMixin.SHAPE_COLLISION().get(axis));
                return;
            }
            visitedEntities.add(entity);
            if (entity instanceof Mob && (tmp = (mob = (Mob)entity).getLeashHolder()) != null && !(tmp instanceof LeashFenceKnotEntity)) {
                entity = tmp;
                continue;
            }
            tmp = entity.getControllingPassenger();
            if (tmp == null) break;
            entity = tmp;
        }
        if (entity instanceof Mob && ((mob = (Mob)entity).canBeLeashed() || mob.getLeashHolder() instanceof LeashFenceKnotEntity)) {
            ci.setReturnValue((Object)FenceGateBlockMixin.SHAPE_COLLISION().get(axis));
        }
    }
}

