/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.building;

import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.compat.SpecialHandlers;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Bridge {
    public static BlockHitResult getDefaultPlaceAssistTarget(ItemStack heldItem, Level level, Direction dir, BlockPos pos) {
        Item item;
        if (BridgingMod.getConfig().isSlabAssistEnabled() && (item = heldItem.getItem()) instanceof BlockItem) {
            BlockItem heldBlockItem = (BlockItem)item;
            Block placementBlock = heldBlockItem.getBlock();
            boolean isSlabAssistTarget = SpecialHandlers.slabAssistFilters.stream().anyMatch(f -> (Boolean)f.apply(placementBlock));
            if (isSlabAssistTarget) {
                BlockHitResult override;
                switch (dir.getAxis()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: 
                    case Z: {
                        BlockHitResult blockHitResult = Bridge.handleHorizontalSlabAssist(pos);
                        break;
                    }
                    case Y: {
                        BlockHitResult blockHitResult = override = Bridge.handleVerticalSlabAssist(heldItem, level, dir, pos);
                    }
                }
                if (override != null) {
                    return override;
                }
            }
        }
        Vec3 placerOrigin = Vec3.atCenterOf((Vec3i)pos);
        return new BlockHitResult(placerOrigin, dir, pos, true);
    }

    private static BlockHitResult handleHorizontalSlabAssist(BlockPos pos) {
        boolean shouldTargetLowerHalf = BridgingStateTracker.lastKnownYFrac > 0.1775 && BridgingStateTracker.lastKnownYFrac < 0.51;
        Vec3 placerOrigin = shouldTargetLowerHalf ? Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.1, 0.0) : Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.9, 0.0);
        Direction placeDir = shouldTargetLowerHalf ? Direction.UP : Direction.DOWN;
        return new BlockHitResult(placerOrigin, placeDir, pos, false);
    }

    private static BlockHitResult handleVerticalSlabAssist(ItemStack heldItem, Level level, Direction dir, BlockPos pos) {
        if (level == null) {
            return null;
        }
        Item item = heldItem.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.getBlock() instanceof SlabBlock)) {
            return null;
        }
        BlockPos buildingOffPos = pos.offset(dir.getUnitVec3i().multiply(-1));
        BlockState localState = level.getBlockState(buildingOffPos);
        if (!(localState.getBlock() instanceof SlabBlock)) {
            return null;
        }
        SlabType slabType = (SlabType)localState.getValue((Property)SlabBlock.TYPE);
        if (slabType == SlabType.DOUBLE) {
            return null;
        }
        if (slabType == SlabType.TOP && dir != Direction.DOWN) {
            return null;
        }
        if (slabType == SlabType.BOTTOM && dir != Direction.UP) {
            return null;
        }
        Vec3 placerOrigin = Vec3.atCenterOf((Vec3i)pos);
        return new BlockHitResult(placerOrigin, dir, buildingOffPos, false);
    }
}

