/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import java.util.Optional;
import me.cg360.mod.bridging.BridgingKeyMappings;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.building.Bridge;
import me.cg360.mod.bridging.compat.SpecialBridgingHandler;
import me.cg360.mod.bridging.compat.SpecialHandlers;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.InfoStrings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    private int rightClickDelay;
    @Shadow
    @Nullable
    public ClientLevel level;

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void onTick(CallbackInfo ci) {
        if (this.player != null && this.player.onGround()) {
            BridgingStateTracker.lastKnownYFrac = Mth.frac((double)this.player.getY());
        }
        if (BridgingKeyMappings.TOGGLE_BRIDGING.consumeClick()) {
            BridgingMod.getConfig().toggleBridgingEnabled();
            Component stateMsg = BridgingMod.getConfig().isBridgingEnabled() ? InfoStrings.ON : InfoStrings.OFF;
            MutableComponent text = InfoStrings.TOGGLE_BRIDGING.copy().append(stateMsg);
            Minecraft.getInstance().gui.setOverlayMessage((Component)text, false);
        }
        BridgingStateTracker.tick(this.player);
    }

    @Inject(at={@At(value="HEAD")}, method={"startUseItem()V"}, cancellable=true)
    public void onItemUse(CallbackInfo info) {
        boolean passesCrouchTest;
        if (!BridgingMod.getConfig().isBridgingEnabled()) {
            return;
        }
        if (this.player == null) {
            return;
        }
        if (this.gameMode == null) {
            return;
        }
        if (this.player.isHandsBusy() || this.gameMode.isDestroying()) {
            return;
        }
        if (this.hitResult != null && this.hitResult.getType() != HitResult.Type.MISS) {
            return;
        }
        boolean bl = passesCrouchTest = !BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || this.player.isCrouching();
        if (!passesCrouchTest) {
            return;
        }
        Tuple<BlockPos, Direction> pair = BridgingStateTracker.getLastTickTarget();
        if (pair == null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            boolean stackSizeChanged;
            boolean canBePlacedInWorld;
            boolean canBePlaced;
            ItemStack itemStack = this.player.getItemInHand(hand);
            boolean isPlaceableStack = GameSupport.isStackPlaceable(itemStack);
            if (!isPlaceableStack) {
                InteractionResult usage = this.gameMode.useItem((Player)this.player, hand);
                if (!usage.consumesAction()) continue;
                return;
            }
            BlockPos pos = (BlockPos)pair.getA();
            Direction dir = ((Direction)pair.getB()).getOpposite();
            InteractionResult blockPlaceResult = null;
            int originalStackSize = itemStack.getCount();
            Optional<SpecialBridgingHandler> optHandler = SpecialHandlers.getSpecialHandler(itemStack);
            if (optHandler.isPresent()) {
                SpecialBridgingHandler handler = optHandler.get();
                canBePlaced = handler.canBePlaced(itemStack);
                canBePlacedInWorld = handler.canBePlacedInWorld(itemStack, (Player)this.player, (Level)this.level, pos, dir);
                if (!canBePlaced || !canBePlacedInWorld) continue;
                blockPlaceResult = optHandler.get().place();
            } else {
                canBePlaced = GameSupport.passesDefaultPlacementCheck(itemStack);
                canBePlacedInWorld = this.player.mayUseItemAt(pos, dir, itemStack);
            }
            if (blockPlaceResult == null) {
                if (!canBePlaced || !canBePlacedInWorld) continue;
                BlockHitResult blockHitResult = this.bridgingmod$getFinalPlaceAssistTarget(itemStack, dir, pos, optHandler.orElse(null));
                blockPlaceResult = this.gameMode.useItemOn(this.player, hand, blockHitResult);
            }
            if (!(blockPlaceResult instanceof InteractionResult.Success)) continue;
            InteractionResult.Success successResult = (InteractionResult.Success)blockPlaceResult;
            this.rightClickDelay = Math.max(0, BridgingMod.getConfig().getDelayPostBridging());
            info.cancel();
            if (successResult.swingSource() != InteractionResult.SwingSource.CLIENT) {
                return;
            }
            this.player.swing(hand);
            boolean bl2 = stackSizeChanged = itemStack.getCount() != originalStackSize || this.player.hasInfiniteMaterials();
            if (stackSizeChanged && !itemStack.isEmpty()) {
                Minecraft.getInstance().gameRenderer.itemInHandRenderer.itemUsed(hand);
            }
            return;
        }
    }

    @Unique
    @NotNull
    private BlockHitResult bridgingmod$getFinalPlaceAssistTarget(ItemStack heldItem, Direction dir, BlockPos pos, SpecialBridgingHandler specialHandler) {
        BlockHitResult customPlaceAssistTarget;
        if (specialHandler != null && (customPlaceAssistTarget = specialHandler.generatePlacementTarget(heldItem, (Player)this.player, (Level)this.level, dir, pos)) != null) {
            return customPlaceAssistTarget;
        }
        return Bridge.getDefaultPlaceAssistTarget(heldItem, (Level)this.level, dir, pos);
    }
}

