/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.selector.SourcePerspective;
import me.cg360.mod.bridging.raytrace.Perspective;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Render;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class OutlineRendererMixin {
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract void checkPoseStack(PoseStack var1);

    @Inject(method={"renderBlockOutline(Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lcom/mojang/blaze3d/vertex/PoseStack;ZLnet/minecraft/client/renderer/state/LevelRenderState;)V"}, at={@At(value="HEAD")})
    public void renderTracedViewPath(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, boolean bl, LevelRenderState levelRenderState, CallbackInfo ci) {
        Perspective view;
        boolean isNonBridgeOutlineEnabled;
        boolean isInDebugMenu = this.minecraft.getDebugOverlay().showDebugScreen();
        boolean isBridgingEnabled = BridgingMod.getConfig().isBridgingEnabled() && (!BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || GameSupport.isControllerCrouching());
        boolean shouldRenderOutline = isInDebugMenu && BridgingMod.getConfig().shouldShowOutlineInF3() || !isInDebugMenu && BridgingMod.getConfig().shouldShowOutline();
        boolean isOutlineEnabled = shouldRenderOutline && isBridgingEnabled;
        boolean shouldRenderNonBridgeOutline = isInDebugMenu && BridgingMod.getConfig().shouldShowNonBridgeOutlineInF3() || !isInDebugMenu && BridgingMod.getConfig().shouldShowOutlineEvenWhenNotBridging();
        boolean bl2 = isNonBridgeOutlineEnabled = shouldRenderNonBridgeOutline && (isBridgingEnabled || !BridgingMod.getConfig().shouldNonBridgeRespectsCrouchRules());
        if (!isOutlineEnabled && !isNonBridgeOutlineEnabled) {
            return;
        }
        VertexConsumer vertices = bufferSource.getBuffer(RenderType.lines());
        SourcePerspective perspectiveLock = BridgingMod.getCompatibleSourcePerspective();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            perspectiveLock = SourcePerspective.COPY_TOGGLE_PERSPECTIVE;
        }
        switch (perspectiveLock) {
            default: {
                throw new MatchException(null, null);
            }
            case COPY_TOGGLE_PERSPECTIVE: 
            case LET_BRIDGING_MOD_DECIDE: {
                Perspective perspective = Perspective.fromCamera(Minecraft.getInstance().gameRenderer.getMainCamera());
                break;
            }
            case ALWAYS_EYELINE: {
                Perspective perspective = view = Perspective.fromEntity((Entity)player);
            }
        }
        if (isInDebugMenu && BridgingMod.getConfig().shouldShowDebugTrace()) {
            Render.blocksInViewPath(poseStack, vertices, view);
        }
        if (isOutlineEnabled) {
            Render.currentBridgingOutline(poseStack, view, vertices);
        }
        if (isNonBridgeOutlineEnabled) {
            Render.currentNonBridgingOutline(poseStack, view, vertices);
        }
        this.checkPoseStack(poseStack);
    }
}

