/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.raytrace.PathTraversalHandler;
import me.cg360.mod.bridging.util.GameSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;

public class BridgingStateTracker {
    private static Tuple<BlockPos, Direction> lastTickTarget = null;
    public static double lastKnownYFrac = 0.0;

    public static Tuple<BlockPos, Direction> getBridgeAssistTargetFor(Player player) {
        if (player == null) {
            return null;
        }
        HitResult hit = Minecraft.getInstance().hitResult;
        if (hit != null && hit.getType() != HitResult.Type.MISS) {
            return null;
        }
        if (!GameSupport.isHoldingPlaceable(player)) {
            return null;
        }
        return PathTraversalHandler.getClosestAssistTarget((Entity)player);
    }

    public static void tick(LocalPlayer player) {
        if (!BridgingMod.getConfig().isBridgingEnabled()) {
            lastTickTarget = null;
            return;
        }
        lastTickTarget = BridgingStateTracker.getBridgeAssistTargetFor((Player)player);
    }

    public static Tuple<BlockPos, Direction> getLastTickTarget() {
        return lastTickTarget;
    }
}

