/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.selector.PlacementAxisMode;
import me.cg360.mod.bridging.config.selector.SourcePerspective;
import me.cg360.mod.bridging.raytrace.Perspective;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PathTraversalHandler {
    private static final double DIRECTION_SIMILARITY_THRESHOLD = 0.1;

    public static Tuple<BlockPos, Direction> getClosestAssistTarget(Entity player) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        SourcePerspective perspectiveLock = BridgingMod.getCompatibleSourcePerspective();
        Perspective perspective = switch (perspectiveLock) {
            default -> throw new MatchException(null, null);
            case SourcePerspective.COPY_TOGGLE_PERSPECTIVE, SourcePerspective.LET_BRIDGING_MOD_DECIDE -> Perspective.fromCamera(Minecraft.getInstance().gameRenderer.getMainCamera());
            case SourcePerspective.ALWAYS_EYELINE -> Perspective.fromEntity(player);
        };
        List<BlockPos> path = PathTraversalHandler.getViewBlockPath(player, perspective);
        Vector3f viewDirection = perspective.getLookVector();
        List<Direction> validSides = PathTraversalHandler.getValidAssistSides(viewDirection);
        Direction validDirection = null;
        BlockPos validPos = null;
        for (BlockPos pos : path) {
            Optional<Direction> firstValidDirection;
            if (!PathTraversalHandler.isBridgingPlacementAllowedAt(pos)) continue;
            Vec3 collideMin = Vec3.atLowerCornerOf((Vec3i)pos);
            Vec3 collideMax = Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)1.0, (double)1.0, (double)1.0);
            if (player.getBoundingBox().intersects(collideMin, collideMax) || (firstValidDirection = validSides.stream().filter(dir -> PathTraversalHandler.canSideBeBuiltOffOf(pos, dir)).findFirst()).isEmpty()) continue;
            validDirection = firstValidDirection.get();
            validPos = pos;
            break;
        }
        if (validDirection == null || validPos == null) {
            return null;
        }
        return new Tuple(validPos, validDirection);
    }

    public static List<BlockPos> getViewBlockPath(Entity player, Perspective view) {
        if (player == null) {
            return new ArrayList<BlockPos>();
        }
        double playerReach = GameSupport.getReach();
        Vec3 playerViewVec = player.getViewVector(1.0f).scale(playerReach);
        Vec3 worldSpaceViewEnd = playerViewVec.add(player.getPosition(1.0f));
        Vec3 worldSpaceCameraOrigin = view.getPosition();
        double distance = worldSpaceViewEnd.distanceTo(worldSpaceCameraOrigin);
        float minDistance = BridgingMod.getConfig().getMinimumBridgeDistance() / 100.0f;
        Vec3 viewDirection = new Vec3(view.getLookVector());
        Vec3 farVec = viewDirection.scale(distance);
        Vec3 nearVec = farVec.scale((double)minDistance);
        BlockPos startPos = BlockPos.containing((Position)worldSpaceCameraOrigin.add(nearVec));
        BlockPos endPos = BlockPos.containing((Position)worldSpaceCameraOrigin.add(farVec));
        return Path.calculateBresenhamVoxels(startPos, endPos);
    }

    private static List<Direction> getValidAssistSides(Vector3f viewDirection) {
        LinkedList<Direction> validSides = new LinkedList<Direction>();
        for (Direction direction : Direction.values()) {
            Vector3f directionNormal = Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i()).toVector3f();
            double similarity = viewDirection.dot((Vector3fc)directionNormal);
            if (similarity < 0.1) continue;
            validSides.add(direction.getOpposite());
        }
        return validSides;
    }

    private static boolean canSideBeBuiltOffOf(BlockPos placementTarget, Direction checkSide) {
        PlacementAxisMode mode;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return false;
        }
        PlacementAxisMode baseMode = BridgingMod.getConfig().getSupportedBridgeAxes();
        if (GameSupport.isControllerCrouching() ? !(mode = BridgingMod.getConfig().getSupportedBridgeAxesWhenCrouched().getPlacementAxisMode(baseMode)).isDirectionEnabled(checkSide) : !baseMode.isDirectionEnabled(checkSide)) {
            return false;
        }
        BlockPos blockPlacingOffOf = placementTarget.offset(checkSide.getUnitVec3i());
        if (level.isEmptyBlock(blockPlacingOffOf)) {
            return false;
        }
        if (level.getBlockState(blockPlacingOffOf).getBlock() instanceof LiquidBlock) {
            return false;
        }
        return !level.getBlockState(blockPlacingOffOf).canBeReplaced();
    }

    private static boolean isBridgingPlacementAllowedAt(BlockPos placementTarget) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return false;
        }
        BlockState target = level.getBlockState(placementTarget);
        return BridgingMod.getConfig().isNonSolidReplaceEnabled() ? target.canBeReplaced() : target.isAir();
    }
}

