/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.selector.BridgingAdjacency;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class Path {
    public static final double NEAR_ZERO = 0.01;
    public static final class_243 CUBE_EXTENT = new class_243(0.5, 0.5, 0.5);

    public static List<class_2338> calculateBresenhamVoxels(class_2338 startPos, class_2338 endPos) {
        ArrayList<class_2338> points = new ArrayList<class_2338>();
        points.add(startPos);
        class_2338 delta = endPos.method_10059((class_2382)startPos);
        int dx = Math.abs(delta.method_10263());
        int dy = Math.abs(delta.method_10264());
        int dz = Math.abs(delta.method_10260());
        int xStep = delta.method_10263() > 0 ? 1 : -1;
        int yStep = delta.method_10264() > 0 ? 1 : -1;
        int zStep = delta.method_10260() > 0 ? 1 : -1;
        class_243 workingVec = new class_243((double)startPos.method_10263(), (double)startPos.method_10264(), (double)startPos.method_10260());
        class_243 targetVec = new class_243((double)endPos.method_10263(), (double)endPos.method_10264(), (double)endPos.method_10260());
        BridgingAdjacency adjacencySupported = BridgingMod.getConfig().getBridgingAdjacency();
        float extentMult = BridgingMod.getConfig().getBridgingSnapStrength();
        if (dx >= dy && dx >= dz) {
            int point1 = 2 * dy - dx;
            int point2 = 2 * dz - dx;
            while (Math.abs(workingVec.method_10216() - targetVec.method_10216()) > 0.01) {
                workingVec = workingVec.method_1031((double)xStep, 0.0, 0.0);
                if (point1 >= 0) {
                    workingVec = workingVec.method_1031(0.0, (double)yStep, 0.0);
                    point1 -= 2 * dx;
                }
                if (point2 >= 0) {
                    workingVec = workingVec.method_1031(0.0, 0.0, (double)zStep);
                    point2 -= 2 * dx;
                }
                point1 += 2 * dy;
                point2 += 2 * dz;
                class_2338 newPoint = class_2338.method_49638((class_2374)workingVec);
                if (adjacencySupported != BridgingAdjacency.DISABLED) {
                    List<class_2338> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos, extentMult, adjacencySupported);
                    points.addAll(lostPoints);
                }
                points.add(newPoint);
            }
            return points;
        }
        if (dy >= dx && dy >= dz) {
            int point1 = 2 * dx - dy;
            int point2 = 2 * dz - dy;
            while (Math.abs(workingVec.method_10214() - targetVec.method_10214()) > 0.01) {
                workingVec = workingVec.method_1031(0.0, (double)yStep, 0.0);
                if (point1 >= 0) {
                    workingVec = workingVec.method_1031((double)xStep, 0.0, 0.0);
                    point1 -= 2 * dy;
                }
                if (point2 >= 0) {
                    workingVec = workingVec.method_1031(0.0, 0.0, (double)zStep);
                    point2 -= 2 * dy;
                }
                point1 += 2 * dx;
                point2 += 2 * dz;
                class_2338 newPoint = class_2338.method_49638((class_2374)workingVec);
                if (adjacencySupported != BridgingAdjacency.DISABLED) {
                    List<class_2338> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos, extentMult, adjacencySupported);
                    points.addAll(lostPoints);
                }
                points.add(newPoint);
            }
            return points;
        }
        int point1 = 2 * dy - dz;
        int point2 = 2 * dx - dz;
        while (Math.abs(workingVec.method_10215() - targetVec.method_10215()) > 0.01) {
            workingVec = workingVec.method_1031(0.0, 0.0, (double)zStep);
            if (point1 >= 0) {
                workingVec = workingVec.method_1031(0.0, (double)yStep, 0.0);
                point1 -= 2 * dz;
            }
            if (point2 >= 0) {
                workingVec = workingVec.method_1031((double)xStep, 0.0, 0.0);
                point2 -= 2 * dz;
            }
            point1 += 2 * dy;
            point2 += 2 * dx;
            class_2338 newPoint = class_2338.method_49638((class_2374)workingVec);
            if (adjacencySupported != BridgingAdjacency.DISABLED) {
                List<class_2338> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos, extentMult, adjacencySupported);
                points.addAll(lostPoints);
            }
            points.add(newPoint);
        }
        return points;
    }

    private static List<class_2338> calculateMissedPoints(List<class_2338> points, class_2338 newPoint, class_2338 lineStart, class_2338 lineEnd, float extentMult, BridgingAdjacency maxAdjacency) {
        class_2338 checkPos;
        class_2338[] checkDirections;
        if (points.isEmpty()) {
            return List.of();
        }
        class_2338 lastPoint = points.get(points.size() - 1);
        class_2338 pointDelta = newPoint.method_10059((class_2382)lastPoint);
        int diff = newPoint.method_19455((class_2382)lastPoint);
        if (diff < 0 || diff > 3) {
            throw new IllegalArgumentException("The last point and the new point share no common boundaries");
        }
        if (diff == 1 || diff == 0) {
            return List.of();
        }
        LinkedList<class_2338> reviewPositions = new LinkedList<class_2338>();
        if (diff == 2) {
            for (class_2338 direction : checkDirections = new class_2338[]{new class_2338(pointDelta.method_10263(), 0, 0), new class_2338(0, pointDelta.method_10264(), 0), new class_2338(0, 0, pointDelta.method_10260())}) {
                if (direction.equals((Object)class_2338.field_10980)) continue;
                checkPos = lastPoint.method_10081((class_2382)direction);
                reviewPositions.add(checkPos);
            }
        }
        if (diff == 3) {
            for (class_2338 direction : checkDirections = new class_2338[]{new class_2338(pointDelta.method_10263(), 0, 0), new class_2338(0, pointDelta.method_10264(), 0), new class_2338(0, 0, pointDelta.method_10260()), new class_2338(pointDelta.method_10263(), pointDelta.method_10264(), 0), new class_2338(pointDelta.method_10263(), 0, pointDelta.method_10260()), new class_2338(0, pointDelta.method_10264(), pointDelta.method_10260())}) {
                if (direction.equals((Object)class_2338.field_10980)) continue;
                checkPos = lastPoint.method_10081((class_2382)direction);
                reviewPositions.add(checkPos);
            }
        }
        class_243 newExtent = CUBE_EXTENT.method_1021((double)extentMult);
        return reviewPositions.stream().filter(pos -> {
            class_243 boxSpaceTransform = class_243.method_24954((class_2382)pos);
            class_243 lineStartD = class_243.method_24954((class_2382)lineStart).method_1020(boxSpaceTransform);
            class_243 lineEndD = class_243.method_24954((class_2382)lineEnd).method_1020(boxSpaceTransform);
            class_243 lineMid = lineStartD.method_1019(lineEndD).method_1021(0.5);
            class_243 line = lineStartD.method_1020(lineMid);
            class_243 lineExt = new class_243(Math.abs(line.field_1352), Math.abs(line.field_1351), Math.abs(line.field_1350));
            if (Math.abs(lineMid.field_1352) > newExtent.field_1352 + lineExt.field_1352) {
                return false;
            }
            if (Math.abs(lineMid.field_1351) > newExtent.field_1351 + lineExt.field_1351) {
                return false;
            }
            if (Math.abs(lineMid.field_1350) > newExtent.field_1350 + lineExt.field_1350) {
                return false;
            }
            if (Math.abs(lineMid.field_1351 * line.field_1350 - lineMid.field_1350 * line.field_1351) > newExtent.field_1351 * lineExt.field_1350 + newExtent.field_1350 * lineExt.field_1351) {
                return false;
            }
            if (Math.abs(lineMid.field_1352 * line.field_1350 - lineMid.field_1350 * line.field_1352) > newExtent.field_1352 * lineExt.field_1350 + newExtent.field_1350 * lineExt.field_1352) {
                return false;
            }
            return !(Math.abs(lineMid.field_1352 * line.field_1351 - lineMid.field_1351 * line.field_1352) > newExtent.field_1352 * lineExt.field_1351 + newExtent.field_1351 * lineExt.field_1352);
        }).toList();
    }
}

