/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.deathchest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DeathChest
extends JavaPlugin
implements Listener,
CommandExecutor {
    private long chestLifetime;
    private long lockDurationSeconds;
    private FileConfiguration chestConfig;
    private File chestFile;
    private Map<UUID, Location> lastDeathLocations = new HashMap<UUID, Location>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadChestLifetime();
        this.loadLockDuration();
        this.chestFile = new File(this.getDataFolder(), "chest.yml");
        if (!this.chestFile.exists()) {
            try {
                this.chestFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.chestConfig = YamlConfiguration.loadConfiguration((File)this.chestFile);
        this.restoreChests();
        this.loadDeathLocations();
        this.getCommand("dc999").setExecutor((CommandExecutor)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("DeathChest plugin enabled!");
    }

    public void onDisable() {
        this.saveDeathLocations();
        this.getLogger().info("DeathChest plugin disabled!");
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        final Player player = event.getEntity();
        final Location deathLocation = player.getLocation();
        this.lastDeathLocations.put(player.getUniqueId(), deathLocation.clone());
        this.saveDeathLocations();
        final ArrayList drops = new ArrayList(event.getDrops());
        event.getDrops().clear();
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            Location chestLoc;
            if (!deathLocation.getChunk().isLoaded()) {
                deathLocation.getChunk().load(true);
            }
            if ((chestLoc = deathLocation.clone()).getBlock().getType() != Material.AIR) {
                chestLoc.getWorld().dropItemNaturally(chestLoc, new ItemStack(Material.CHEST));
                player.sendMessage(String.valueOf(ChatColor.RED) + "Could not place death chest. Items dropped on ground.");
                for (ItemStack item : drops) {
                    if (item == null) continue;
                    deathLocation.getWorld().dropItemNaturally(deathLocation, item);
                }
                return;
            }
            chestLoc.getBlock().setType(Material.CHEST);
            new BukkitRunnable(){

                public void run() {
                    block8: {
                        if (chestLoc.getBlock().getType() == Material.CHEST) {
                            try {
                                Chest chest = (Chest)chestLoc.getBlock().getState();
                                chest.setCustomName("DeathChest");
                                chest.update();
                                ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>(drops);
                                remainingItems.removeIf(item -> item == null);
                                Inventory inv = chest.getInventory();
                                HashMap addResult = inv.addItem(remainingItems.toArray(new ItemStack[0]));
                                final ArrayList leftovers = new ArrayList(addResult.values());
                                Location secondLoc = null;
                                boolean isDouble = false;
                                if (!leftovers.isEmpty()) {
                                    Location[] directionOffsets = new Location[]{chestLoc.clone().add(1.0, 0.0, 0.0), chestLoc.clone().add(-1.0, 0.0, 0.0), chestLoc.clone().add(0.0, 0.0, 1.0), chestLoc.clone().add(0.0, 0.0, -1.0)};
                                    boolean placed = false;
                                    for (Location sec : directionOffsets) {
                                        if (sec.getBlock().getType() != Material.AIR) continue;
                                        sec.getBlock().setType(Material.CHEST);
                                        secondLoc = sec;
                                        placed = true;
                                        isDouble = true;
                                        Location finalSecondLoc = sec;
                                        break;
                                    }
                                    if (placed) {
                                        final Location finalSecondLoc = secondLoc;
                                        new BukkitRunnable(){

                                            public void run() {
                                                Chest mainChest = (Chest)chestLoc.getBlock().getState();
                                                mainChest.setCustomName("DeathChest");
                                                mainChest.update();
                                                Chest secChest = (Chest)finalSecondLoc.getBlock().getState();
                                                secChest.setCustomName("DeathChest");
                                                secChest.update();
                                                Inventory doubleInv = mainChest.getInventory();
                                                doubleInv.addItem(leftovers.toArray(new ItemStack[0]));
                                                DeathChest.this.saveChest(chestLoc, doubleInv.getContents(), finalSecondLoc, player.getUniqueId(), System.currentTimeMillis());
                                                DeathChest.this.saveChest(chestLoc, doubleInv.getContents(), finalSecondLoc, player.getUniqueId(), System.currentTimeMillis());
                                                DeathChest.this.sendDeathMessages(player, chestLoc);
                                                DeathChest.this.scheduleChestRemoval(chestLoc, chestLoc.getWorld().getName() + "_" + chestLoc.getBlockX() + "_" + chestLoc.getBlockY() + "_" + chestLoc.getBlockZ());
                                            }
                                        }.runTaskLater((Plugin)DeathChest.this, 1L);
                                        return;
                                    }
                                    for (ItemStack item2 : leftovers) {
                                        if (item2 == null) continue;
                                        deathLocation.getWorld().dropItemNaturally(deathLocation, item2);
                                    }
                                }
                                if (isDouble) break block8;
                                chest.setCustomName("DeathChest");
                                chest.update();
                                DeathChest.this.saveChest(chestLoc, inv.getContents(), null, player.getUniqueId(), System.currentTimeMillis());
                                DeathChest.this.sendDeathMessages(player, chestLoc);
                                DeathChest.this.scheduleChestRemoval(chestLoc, chestLoc.getWorld().getName() + "_" + chestLoc.getBlockX() + "_" + chestLoc.getBlockY() + "_" + chestLoc.getBlockZ());
                            }
                            catch (Exception e) {
                                DeathChest.this.getLogger().warning("Failed to create death chest: " + e.getMessage());
                                for (ItemStack item3 : drops) {
                                    if (item3 == null) continue;
                                    deathLocation.getWorld().dropItemNaturally(deathLocation, item3);
                                }
                            }
                        }
                    }
                }
            }.runTaskLater((Plugin)this, 2L);
        });
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        UUID owner;
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory inv = event.getInventory();
        if (inv.getType() != InventoryType.CHEST) {
            return;
        }
        InventoryHolder holder = inv.getHolder();
        String mainPath = null;
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            if (!"DeathChest".equals(chest.getCustomName())) {
                return;
            }
            Location loc = chest.getLocation();
            String path = loc.getWorld().getName() + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
            if (this.chestConfig.contains(path + ".world")) {
                mainPath = path;
            }
        } else if (holder instanceof DoubleChest) {
            DoubleChest dc = (DoubleChest)holder;
            Chest left = (Chest)dc.getLeftSide();
            Chest right = (Chest)dc.getRightSide();
            Location leftLoc = left.getLocation();
            String leftPath = leftLoc.getWorld().getName() + "_" + leftLoc.getBlockX() + "_" + leftLoc.getBlockY() + "_" + leftLoc.getBlockZ();
            Location rightLoc = right.getLocation();
            String rightPath = rightLoc.getWorld().getName() + "_" + rightLoc.getBlockX() + "_" + rightLoc.getBlockY() + "_" + rightLoc.getBlockZ();
            if ("DeathChest".equals(left.getCustomName()) && this.chestConfig.contains(leftPath + ".world")) {
                mainPath = leftPath;
            } else if ("DeathChest".equals(right.getCustomName()) && this.chestConfig.contains(rightPath + ".world")) {
                mainPath = rightPath;
            }
        }
        if (mainPath == null) {
            return;
        }
        String ownerStr = this.chestConfig.getString(mainPath + ".owner");
        if (ownerStr == null) {
            return;
        }
        try {
            owner = UUID.fromString(ownerStr);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        long timestamp = this.chestConfig.getLong(mainPath + ".timestamp", 0L);
        if (timestamp == 0L) {
            return;
        }
        long lockDurationMs = this.lockDurationSeconds * 1000L;
        long unlockTime = timestamp + lockDurationMs;
        long now = System.currentTimeMillis();
        if (!player.getUniqueId().equals(owner) && now < unlockTime) {
            long remainingSec = (unlockTime - now) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "This death chest is locked! Remaining time: " + remainingSec + " seconds.");
            event.setCancelled(true);
        }
    }

    private void sendDeathMessages(Player player, Location chestLoc) {
        player.sendMessage(String.valueOf(ChatColor.RED) + "You died at: X: " + chestLoc.getBlockX() + " Y: " + chestLoc.getBlockY() + " Z: " + chestLoc.getBlockZ());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use /dc999 back to return to your death location!");
    }

    private void saveChest(Location mainLoc, ItemStack[] contents, Location secondLoc, UUID owner, long timestamp) {
        String path = mainLoc.getWorld().getName() + "_" + mainLoc.getBlockX() + "_" + mainLoc.getBlockY() + "_" + mainLoc.getBlockZ();
        this.chestConfig.set(path + ".world", (Object)mainLoc.getWorld().getName());
        this.chestConfig.set(path + ".x", (Object)mainLoc.getBlockX());
        this.chestConfig.set(path + ".y", (Object)mainLoc.getBlockY());
        this.chestConfig.set(path + ".z", (Object)mainLoc.getBlockZ());
        if (secondLoc != null) {
            this.chestConfig.set(path + ".second.world", (Object)secondLoc.getWorld().getName());
            this.chestConfig.set(path + ".second.x", (Object)secondLoc.getBlockX());
            this.chestConfig.set(path + ".second.y", (Object)secondLoc.getBlockY());
            this.chestConfig.set(path + ".second.z", (Object)secondLoc.getBlockZ());
        }
        this.chestConfig.set(path + ".contents", Arrays.asList(contents));
        this.chestConfig.set(path + ".owner", (Object)owner.toString());
        this.chestConfig.set(path + ".timestamp", (Object)timestamp);
        this.saveConfigAsync();
    }

    private void scheduleChestRemoval(final Location mainLoc, final String path) {
        new BukkitRunnable(){

            public void run() {
                DeathChest.this.removeChest(mainLoc, path);
            }
        }.runTaskLater((Plugin)this, this.chestLifetime * 20L);
    }

    private void removeChest(Location mainLoc, String path) {
        Chest secChest;
        String swName;
        World sw;
        if (mainLoc.getBlock().getType() != Material.CHEST) {
            return;
        }
        Chest mainChest = (Chest)mainLoc.getBlock().getState();
        if (mainChest.getCustomName() == null || !mainChest.getCustomName().equals("DeathChest")) {
            return;
        }
        Location secondLoc = null;
        if (this.chestConfig.contains(path + ".second.world") && (sw = Bukkit.getWorld((String)(swName = this.chestConfig.getString(path + ".second.world")))) != null) {
            int sx = this.chestConfig.getInt(path + ".second.x");
            int sy = this.chestConfig.getInt(path + ".second.y");
            int sz = this.chestConfig.getInt(path + ".second.z");
            secondLoc = new Location(sw, (double)sx, (double)sy, (double)sz);
        }
        this.chestConfig.set(path, null);
        this.saveConfigAsync();
        mainLoc.getBlock().setType(Material.AIR);
        if (secondLoc != null && secondLoc.getBlock().getType() == Material.CHEST && (secChest = (Chest)secondLoc.getBlock().getState()).getCustomName() != null && secChest.getCustomName().equals("DeathChest")) {
            secondLoc.getBlock().setType(Material.AIR);
        }
    }

    private void restoreChests() {
        for (final String key : this.chestConfig.getKeys(false)) {
            String swName;
            World sw;
            int z;
            int y;
            World world;
            String worldName;
            if (key.contains("death_") || (worldName = this.chestConfig.getString(key + ".world")) == null || (world = Bukkit.getWorld((String)worldName)) == null) continue;
            int x = this.chestConfig.getInt(key + ".x");
            final Location mainLoc = new Location(world, (double)x, (double)(y = this.chestConfig.getInt(key + ".y")), (double)(z = this.chestConfig.getInt(key + ".z")));
            if (mainLoc.getBlock().getType() != Material.AIR) {
                mainLoc.getBlock().setType(Material.AIR);
            }
            mainLoc.getBlock().setType(Material.CHEST);
            final Location[] secondLocHolder = new Location[]{null};
            if (this.chestConfig.contains(key + ".second.world") && (sw = Bukkit.getWorld((String)(swName = this.chestConfig.getString(key + ".second.world")))) != null) {
                int sx = this.chestConfig.getInt(key + ".second.x");
                int sy = this.chestConfig.getInt(key + ".second.y");
                int sz = this.chestConfig.getInt(key + ".second.z");
                secondLocHolder[0] = new Location(sw, (double)sx, (double)sy, (double)sz);
                if (secondLocHolder[0].getBlock().getType() != Material.AIR) {
                    secondLocHolder[0].getBlock().setType(Material.AIR);
                }
                secondLocHolder[0].getBlock().setType(Material.CHEST);
            }
            new BukkitRunnable(){

                public void run() {
                    Chest mainChest = (Chest)mainLoc.getBlock().getState();
                    mainChest.setCustomName("DeathChest");
                    mainChest.update();
                    if (secondLocHolder[0] != null) {
                        Chest secChest = (Chest)secondLocHolder[0].getBlock().getState();
                        secChest.setCustomName("DeathChest");
                        secChest.update();
                    }
                    Inventory inv = mainChest.getInventory();
                    List rawContents = DeathChest.this.chestConfig.getList(key + ".contents");
                    if (rawContents != null && rawContents.size() == inv.getSize()) {
                        ItemStack[] contents = new ItemStack[rawContents.size()];
                        for (int i = 0; i < rawContents.size(); ++i) {
                            Object obj = rawContents.get(i);
                            contents[i] = obj instanceof ItemStack ? (ItemStack)obj : null;
                        }
                        inv.setContents(contents);
                    } else {
                        DeathChest.this.getLogger().warning("Contents size mismatch for restored chest at " + key + ". Skipping contents.");
                    }
                    long timestamp = DeathChest.this.chestConfig.getLong(key + ".timestamp", 0L);
                    if (timestamp > 0L) {
                        long elapsedSec = (System.currentTimeMillis() - timestamp) / 1000L;
                        long remainingSec = DeathChest.this.chestLifetime - elapsedSec;
                        if (remainingSec > 0L) {
                            long ticks = remainingSec * 20L;
                            DeathChest.this.scheduleChestRemoval(mainLoc, key);
                        } else {
                            DeathChest.this.removeChest(mainLoc, key);
                        }
                    }
                }
            }.runTaskLater((Plugin)this, 2L);
        }
    }

    private void saveDeathLocations() {
        for (Map.Entry<UUID, Location> entry : this.lastDeathLocations.entrySet()) {
            String path = "death_" + entry.getKey().toString();
            Location loc = entry.getValue();
            this.chestConfig.set(path + ".world", (Object)loc.getWorld().getName());
            this.chestConfig.set(path + ".x", (Object)loc.getX());
            this.chestConfig.set(path + ".y", (Object)loc.getY());
            this.chestConfig.set(path + ".z", (Object)loc.getZ());
            this.chestConfig.set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
            this.chestConfig.set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        }
        this.saveConfigAsync();
    }

    private void loadDeathLocations() {
        for (String key : this.chestConfig.getKeys(false)) {
            if (!key.startsWith("death_")) continue;
            String uuidStr = key.substring(6);
            try {
                UUID uuid = UUID.fromString(uuidStr);
                String world = this.chestConfig.getString(key + ".world");
                double x = this.chestConfig.getDouble(key + ".x");
                double y = this.chestConfig.getDouble(key + ".y");
                double z = this.chestConfig.getDouble(key + ".z");
                float yaw = (float)this.chestConfig.getDouble(key + ".yaw");
                float pitch = (float)this.chestConfig.getDouble(key + ".pitch");
                if (world == null || Bukkit.getWorld((String)world) == null) continue;
                Location loc = new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
                this.lastDeathLocations.put(uuid, loc);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid UUID in death location data: " + uuidStr);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DeathChest Commands:");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dc999 chest_lifetime <seconds> " + String.valueOf(ChatColor.GRAY) + "- Set chest lifetime");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dc999 reload " + String.valueOf(ChatColor.GRAY) + "- Reload configuration");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dc999 deathcoordinates " + String.valueOf(ChatColor.GRAY) + "- Show your last death location");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dc999 back " + String.valueOf(ChatColor.GRAY) + "- Teleport to your last death location");
            return true;
        }
        if (args[0].equalsIgnoreCase("chest_lifetime")) {
            if (player.hasPermission("dc999.reload")) {
                if (args.length == 2) {
                    try {
                        long lifetime = Long.parseLong(args[1]);
                        if (lifetime <= 0L) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Lifetime must be greater than 0!");
                            return true;
                        }
                        this.getConfig().set("chest-lifetime", (Object)lifetime);
                        this.saveConfig();
                        this.loadChestLifetime();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chest lifetime updated to " + lifetime + " seconds.");
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number format!");
                    }
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /dc999 chest_lifetime <seconds>");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("lock_duration")) {
            if (player.hasPermission("dc999.reload")) {
                if (args.length == 2) {
                    try {
                        long duration = Long.parseLong(args[1]);
                        if (duration < 0L) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Duration must be 0 or greater (0 disables lock)!");
                            return true;
                        }
                        this.getConfig().set("lock-duration", (Object)duration);
                        this.saveConfig();
                        this.loadLockDuration();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chest lock duration updated to " + duration + " seconds.");
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number format!");
                    }
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /dc999 lock_duration <seconds>");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (player.hasPermission("dc999.reload")) {
                this.reloadConfig();
                this.loadChestLifetime();
                this.loadLockDuration();
                this.chestConfig = YamlConfiguration.loadConfiguration((File)this.chestFile);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded!");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("deathcoordinates")) {
            Location deathLoc = this.lastDeathLocations.get(player.getUniqueId());
            if (deathLoc != null) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your last death location:");
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "World: " + deathLoc.getWorld().getName());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "X: " + Math.round(deathLoc.getX()));
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Y: " + Math.round(deathLoc.getY()));
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Z: " + Math.round(deathLoc.getZ()));
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No death location found for you!");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("back")) {
            Location deathLoc = this.lastDeathLocations.get(player.getUniqueId());
            if (deathLoc != null) {
                if (player.teleport(deathLoc)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to your last death location!");
                    this.lastDeathLocations.remove(player.getUniqueId());
                    String path = "death_" + player.getUniqueId().toString();
                    this.chestConfig.set(path, null);
                    this.saveConfigAsync();
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Teleport failed!");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No death location found to teleport to!");
            }
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /dc999 for help.");
        return true;
    }

    private void loadChestLifetime() {
        this.chestLifetime = this.getConfig().getLong("chest-lifetime", 300L);
    }

    private void loadLockDuration() {
        this.lockDurationSeconds = this.getConfig().getLong("lock-duration", 300L);
    }

    private void saveConfigAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                this.chestConfig.save(this.chestFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

