/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.deathchest;

import com.yourname.deathchest.commands.DeathChestCommand;
import com.yourname.deathchest.listeners.ChestProtectListener;
import com.yourname.deathchest.listeners.PlayerDeathListener;
import com.yourname.deathchest.managers.ChestManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathChest
extends JavaPlugin {
    private ChestManager chestManager;
    private FileConfiguration chestsConfig;
    private File chestsFile;
    private NamespacedKey deathChestKey;

    public void onEnable() {
        this.saveDefaultConfig();
        this.deathChestKey = new NamespacedKey((Plugin)this, "death_chest");
        this.chestManager = new ChestManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChestProtectListener(this), (Plugin)this);
        this.getCommand("deathchest").setExecutor((CommandExecutor)new DeathChestCommand(this));
        this.createChestsConfig();
    }

    public FileConfiguration getChestsConfig() {
        return this.chestsConfig;
    }

    public void saveChestsConfig() {
        try {
            this.chestsConfig.save(this.chestsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save chests.yml!");
            e.printStackTrace();
        }
    }

    private void createChestsConfig() {
        this.chestsFile = new File(this.getDataFolder(), "chests.yml");
        if (!this.chestsFile.exists()) {
            this.chestsFile.getParentFile().mkdirs();
            this.saveResource("chests.yml", false);
        }
        this.chestsConfig = YamlConfiguration.loadConfiguration((File)this.chestsFile);
    }

    public NamespacedKey getDeathChestKey() {
        return this.deathChestKey;
    }

    public ChestManager getChestManager() {
        return this.chestManager;
    }
}

