/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.deathchest.commands;

import com.yourname.deathchest.DeathChest;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class DeathChestCommand
implements CommandExecutor {
    private final DeathChest plugin;

    public DeathChestCommand(DeathChest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "list": {
                this.listDeathChests(player);
                break;
            }
            case "back": {
                this.teleportToLastDeathChest(player);
                break;
            }
            default: {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void listDeathChests(Player player) {
        ConfigurationSection chests = this.plugin.getChestsConfig().getConfigurationSection("chests");
        if (chests == null || chests.getKeys(false).isEmpty()) {
            player.sendMessage("\u00a7cYou have no active death chests.");
            return;
        }
        player.sendMessage("\u00a7aYour active death chests:");
        for (String chestId : chests.getKeys(false)) {
            ConfigurationSection chestSection = chests.getConfigurationSection(chestId);
            if (chestSection == null) continue;
            UUID owner = UUID.fromString(chestSection.getString("owner"));
            if (!player.getUniqueId().equals(owner)) continue;
            String world = chestSection.getString("world");
            int x = chestSection.getInt("x");
            int y = chestSection.getInt("y");
            int z = chestSection.getInt("z");
            player.sendMessage("\u00a7e- World: " + world + ", X: " + x + ", Y: " + y + ", Z: " + z);
        }
    }

    private void teleportToLastDeathChest(Player player) {
        if (!player.hasPermission("deathchest.back")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return;
        }
        ConfigurationSection chests = this.plugin.getChestsConfig().getConfigurationSection("chests");
        if (chests == null || chests.getKeys(false).isEmpty()) {
            player.sendMessage("\u00a7cNo death chest found to teleport to.");
            return;
        }
        long latestTimestamp = -1L;
        String latestChestId = null;
        for (String chestId : chests.getKeys(false)) {
            long timestamp;
            ConfigurationSection chestSection = chests.getConfigurationSection(chestId);
            if (chestSection == null) continue;
            UUID owner = UUID.fromString(chestSection.getString("owner"));
            if (!player.getUniqueId().equals(owner) || (timestamp = chestSection.getLong("createdAt")) <= latestTimestamp) continue;
            latestTimestamp = timestamp;
            latestChestId = chestId;
        }
        if (latestChestId != null) {
            ConfigurationSection latestChestSection = chests.getConfigurationSection(latestChestId);
            String worldName = latestChestSection.getString("world");
            int x = latestChestSection.getInt("x");
            int y = latestChestSection.getInt("y");
            int z = latestChestSection.getInt("z");
            Location deathChestLocation = new Location(this.plugin.getServer().getWorld(worldName), (double)x, (double)y, (double)z);
            player.teleport(deathChestLocation);
            player.sendMessage("\u00a7aTeleported to your last death chest!");
        } else {
            player.sendMessage("\u00a7cNo death chest found to teleport to.");
        }
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage("\u00a7aDeathChest Commands:");
        player.sendMessage("\u00a7e/deathchest list - Lists your active death chests.");
        player.sendMessage("\u00a7e/deathchest back - Teleports you to your most recent death chest. (Permission: deathchest.back)");
    }
}

