/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.deathchest.listeners;

import com.yourname.deathchest.DeathChest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class ChestProtectListener
implements Listener {
    private final DeathChest plugin;

    public ChestProtectListener(DeathChest plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!(event.getClickedBlock().getState() instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)event.getClickedBlock().getState();
        if (!chest.getPersistentDataContainer().has(this.plugin.getDeathChestKey(), PersistentDataType.BYTE)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        this.plugin.getLogger().log(Level.INFO, "Player " + player.getName() + " interacted with a death chest.");
        ConfigurationSection chests = this.plugin.getChestsConfig().getConfigurationSection("chests");
        if (chests == null) {
            return;
        }
        for (String chestId : chests.getKeys(false)) {
            ConfigurationSection chestSection = chests.getConfigurationSection(chestId);
            if (chestSection == null || !chestSection.getString("world").equals(chest.getWorld().getName()) || chestSection.getInt("x") != chest.getX() || chestSection.getInt("y") != chest.getY() || chestSection.getInt("z") != chest.getZ()) continue;
            UUID owner = UUID.fromString(chestSection.getString("owner"));
            if (!player.getUniqueId().equals(owner)) {
                player.sendMessage("\u00a7cYou cannot open this death chest.");
                return;
            }
            this.plugin.getLogger().log(Level.INFO, "Loading death chest contents for player: " + player.getName());
            Inventory inventory = this.plugin.getServer().createInventory(null, 54, player.getName() + "'s Death Chest");
            List contents = chestSection.getMapList("contents");
            if (contents != null) {
                for (Map itemMap : contents) {
                    inventory.addItem(new ItemStack[]{ItemStack.deserialize((Map)itemMap)});
                    this.plugin.getLogger().log(Level.INFO, "  - Loaded " + String.valueOf(ItemStack.deserialize((Map)itemMap).getType()) + " x" + ItemStack.deserialize((Map)itemMap).getAmount());
                }
            }
            player.openInventory(inventory);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!event.getView().getTitle().contains("Death Chest")) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.plugin.getLogger().log(Level.INFO, "Player " + player.getName() + " closed a death chest inventory.");
        ConfigurationSection chests = this.plugin.getChestsConfig().getConfigurationSection("chests");
        if (chests == null) {
            return;
        }
        for (String chestId : chests.getKeys(false)) {
            ConfigurationSection chestSection = chests.getConfigurationSection(chestId);
            if (chestSection == null) continue;
            UUID owner = UUID.fromString(chestSection.getString("owner"));
            if (!player.getUniqueId().equals(owner)) continue;
            this.plugin.getLogger().log(Level.INFO, "Saving death chest contents for player: " + player.getName());
            ArrayList<Map> serializedContents = new ArrayList<Map>();
            for (ItemStack item : event.getInventory().getContents()) {
                if (item == null) continue;
                serializedContents.add(item.serialize());
                this.plugin.getLogger().log(Level.INFO, "  - Saved " + String.valueOf(item.getType()) + " x" + item.getAmount());
            }
            chestSection.set("contents", serializedContents);
            this.plugin.saveChestsConfig();
            return;
        }
    }
}

