/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.deathchest.listeners;

import com.yourname.deathchest.DeathChest;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerDeathListener
implements Listener {
    private final DeathChest plugin;

    public PlayerDeathListener(DeathChest plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) continue;
            items.add(item);
        }
        event.getDrops().clear();
        this.plugin.getChestManager().createDeathChest(player, items);
        Location deathLocation = player.getLocation();
        player.sendMessage(String.valueOf(ChatColor.RED) + "A death chest has been created at: " + String.valueOf(ChatColor.YELLOW) + "World: " + deathLocation.getWorld().getName() + String.valueOf(ChatColor.YELLOW) + ", X: " + deathLocation.getBlockX() + String.valueOf(ChatColor.YELLOW) + ", Y: " + deathLocation.getBlockY() + String.valueOf(ChatColor.YELLOW) + ", Z: " + deathLocation.getBlockZ());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use /deathchest back to teleport to your last death chest.");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use /deathchest list to see your active death chests.");
    }
}

