/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.deathchest.managers;

import com.yourname.deathchest.DeathChest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChestManager {
    private final DeathChest plugin;

    public ChestManager(DeathChest plugin) {
        this.plugin = plugin;
    }

    public void createDeathChest(Player player, List<ItemStack> items) {
        this.plugin.getLogger().log(Level.INFO, "Creating death chest for player: " + player.getName());
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            Block block;
            Location location = player.getLocation();
            if (!location.getChunk().isLoaded()) {
                location.getChunk().load();
            }
            if ((block = this.findSuitableBlock(location)) == null) {
                this.dropItems(location, items);
                player.sendMessage("\u00a7cCould not find a suitable location for a death chest. Your items have been dropped on the ground.");
                return;
            }
            block.setType(Material.CHEST);
            Chest chest = (Chest)block.getState();
            chest.getPersistentDataContainer().set(this.plugin.getDeathChestKey(), PersistentDataType.BYTE, (Object)1);
            chest.setCustomName(player.getName() + "'s Death Chest");
            chest.update();
            Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(player.getName() + "'s Death Chest"));
            for (ItemStack item : items) {
                if (item == null) continue;
                inventory.addItem(new ItemStack[]{item});
            }
            this.plugin.getLogger().log(Level.INFO, "Saving death chest contents for player: " + player.getName());
            for (ItemStack item : inventory.getContents()) {
                if (item == null) continue;
                this.plugin.getLogger().log(Level.INFO, "  - " + String.valueOf(item.getType()) + " x" + item.getAmount());
            }
            this.saveChest(player.getUniqueId(), block.getLocation(), inventory.getContents());
            player.sendMessage("\u00a7aA death chest has been created at your death location.");
        });
    }

    public void saveChest(UUID playerId, Location location, ItemStack[] contents) {
        String chestId = UUID.randomUUID().toString();
        ConfigurationSection chestSection = this.plugin.getChestsConfig().createSection("chests." + chestId);
        chestSection.set("owner", (Object)playerId.toString());
        chestSection.set("world", (Object)location.getWorld().getName());
        chestSection.set("x", (Object)location.getBlockX());
        chestSection.set("y", (Object)location.getBlockY());
        chestSection.set("z", (Object)location.getBlockZ());
        chestSection.set("createdAt", (Object)System.currentTimeMillis());
        ArrayList<Map> serializedContents = new ArrayList<Map>();
        for (ItemStack item : contents) {
            if (item == null) continue;
            serializedContents.add(item.serialize());
        }
        chestSection.set("contents", serializedContents);
        this.plugin.saveChestsConfig();
    }

    private Block findSuitableBlock(Location location) {
        World world = location.getWorld();
        for (int y = location.getBlockY(); y > world.getMinHeight(); --y) {
            Location loc = new Location(world, (double)location.getBlockX(), (double)y, (double)location.getBlockZ());
            if (!loc.getBlock().getType().isAir()) continue;
            return loc.getBlock();
        }
        return null;
    }

    private void dropItems(Location location, List<ItemStack> items) {
        World world = location.getWorld();
        for (ItemStack item : items) {
            if (item == null) continue;
            world.dropItemNaturally(location, item);
        }
    }
}

