/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.deathknell.common.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Random;
import net.darkhax.deathknell.common.api.message.IDeathMessage;
import net.darkhax.deathknell.common.impl.message.DeathMessage;
import net.darkhax.deathknell.common.impl.message.DeathMessageRandom;
import net.darkhax.deathknell.common.mixin.AccessorCombatTracker;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1456;
import net.minecraft.class_1545;
import net.minecraft.class_1549;
import net.minecraft.class_1551;
import net.minecraft.class_1577;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3489;
import net.minecraft.class_7417;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9334;

public class DeathKnell {
    public static final String MOD_ID = "deathknell";
    public static final Random RNG = new Random();
    private static final IDeathMessage GENERIC_SLAIN = new DeathMessageRandom("thwarted", "bonked", "defeated", "butchered", "assassinate", "eliminated", "extinguished", "terminated", "done_in", "executed", "stopped", "stifle", "slaughter", "exterminated", "vanquished", "bested", "trounced", "ended", "perished", "demise");
    private static final IDeathMessage DEATH_BY_COOKIE = new DeathMessage("death_by_cookie");
    private static final IDeathMessage DEATH_BY_BOOK = new DeathMessage("death_by_book");
    private static final IDeathMessage DEATH_BY_AXE = new DeathMessage("death_by_axe");
    private static final IDeathMessage BURNED_ALIVE = new DeathMessageRandom("incinerated", "reduce_to_ash", "cooked_alive", "fire_out");
    private static final IDeathMessage SPIDER_VENOM = new DeathMessage("spider_venom");
    private static final IDeathMessage SLIME_DEATH = new DeathMessageRandom("dissolve", "slime_food");
    private static final IDeathMessage POLAR_BEAR_DEATH = new DeathMessageRandom("respect_habitat", "disturb_den");
    private static final IDeathMessage IRON_GOLEM_DEATH = new DeathMessage("saved_from_village");
    private static final IDeathMessage DROWNED_DEATH = new DeathMessage("watery_grave");
    private static final IDeathMessage GUARDIAN_DEATH = new DeathMessage("stared_down");
    private static final IDeathMessage PLAYER_DEATH = new DeathMessage("pwned");
    private static final IDeathMessage FALL_DEATH = new DeathMessageRandom("fall_bounce", "fall_gravity", "fall_parachute", "fall_stub", "free_fall");
    private static final IDeathMessage DROWN_DEATH = new DeathMessageRandom("drown_breath", "drown_fishes", "drown_fish_food", "drown_shark_bait", "drown_floundered");
    private static final IDeathMessage ELYTRA_WALL_DEATH = new DeathMessageRandom("elytra_wall_bang", "elytra_wall_crash");
    private static final IDeathMessage VOID_DEATH = new DeathMessageRandom("void_abyss", "void_infinity", "void_divide");

    private static class_1281 getLastCombatEntry(AccessorCombatTracker tracker) {
        return tracker.deathknell$getEntries().isEmpty() ? null : tracker.deathknell$getEntries().get(tracker.deathknell$getEntries().size() - 1);
    }

    public static class_2561 getCustomDeathMessage(class_2561 original, class_1283 tracker) {
        if (tracker instanceof AccessorCombatTracker) {
            AccessorCombatTracker combat = (AccessorCombatTracker)tracker;
            class_1281 lastEntry = DeathKnell.getLastCombatEntry(combat);
            class_1282 source = lastEntry != null ? lastEntry.comp_1535() : null;
            class_1309 deadMob = combat.deathknell$getMob();
            class_1309 killer = deadMob.method_6124();
            if (killer == null && source != null) {
                if (source.method_48789(class_8103.field_42250) && DeathKnell.tryPercent(0.6f)) {
                    return FALL_DEATH.getMessage(deadMob);
                }
                if (source.method_48789(class_8103.field_42251) && DeathKnell.tryPercent(0.6f)) {
                    return DROWN_DEATH.getMessage(deadMob);
                }
                if (source.method_49708(class_8111.field_42346) && DeathKnell.tryPercent(0.6f)) {
                    return ELYTRA_WALL_DEATH.getMessage(deadMob);
                }
                if (source.method_48789(class_8103.field_42256) && DeathKnell.tryPercent(0.6f)) {
                    return VOID_DEATH.getMessage(deadMob);
                }
            }
            if (killer != null) {
                class_2588 msg;
                class_7417 class_74172 = original.method_10851();
                class_2588 translatable = class_74172 instanceof class_2588 ? (msg = (class_2588)class_74172) : null;
                class_1799 murderWeapon = killer.method_6047();
                boolean wasGenericKill = DeathKnell.wasGenericMobKill(translatable) || DeathKnell.wasGenericPlayerKill(translatable);
                class_1309 class_13092 = killer;
                Objects.requireNonNull(class_13092);
                class_1309 class_13093 = class_13092;
                int n = 0;
                block10: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1545.class, class_1549.class, class_1621.class, class_1456.class, class_1439.class, class_1551.class, class_1577.class, class_1657.class}, (Object)class_13093, n)) {
                        case 0: {
                            class_1545 blaze = (class_1545)class_13093;
                            if (!DeathKnell.tryPercent(0.65f)) {
                                n = 1;
                                continue block10;
                            }
                            return BURNED_ALIVE.getMessage(deadMob, killer);
                        }
                        case 1: {
                            class_1549 caveSpider = (class_1549)class_13093;
                            if (!DeathKnell.tryPercent(0.9f)) {
                                n = 2;
                                continue block10;
                            }
                            return SPIDER_VENOM.getMessage(deadMob, killer);
                        }
                        case 2: {
                            class_1621 slime = (class_1621)class_13093;
                            if (!DeathKnell.tryPercent(0.9f)) {
                                n = 3;
                                continue block10;
                            }
                            return SLIME_DEATH.getMessage(deadMob, killer);
                        }
                        case 3: {
                            class_1456 polarBear = (class_1456)class_13093;
                            if (!DeathKnell.tryPercent(0.9f)) {
                                n = 4;
                                continue block10;
                            }
                            return POLAR_BEAR_DEATH.getMessage(deadMob, killer);
                        }
                        case 4: {
                            class_1439 ironGolem = (class_1439)class_13093;
                            if (!DeathKnell.tryPercent(0.9f)) {
                                n = 5;
                                continue block10;
                            }
                            return IRON_GOLEM_DEATH.getMessage(deadMob, killer);
                        }
                        case 5: {
                            class_1551 drowned = (class_1551)class_13093;
                            if (!DeathKnell.tryPercent(0.4f)) {
                                n = 6;
                                continue block10;
                            }
                            return DROWNED_DEATH.getMessage(deadMob, killer);
                        }
                        case 6: {
                            class_1577 guardian = (class_1577)class_13093;
                            if (!DeathKnell.tryPercent(0.4f)) {
                                n = 7;
                                continue block10;
                            }
                            return GUARDIAN_DEATH.getMessage(deadMob, killer);
                        }
                        case 7: {
                            class_1657 player = (class_1657)class_13093;
                            if (!DeathKnell.tryPercent(0.2f)) {
                                n = 8;
                                continue block10;
                            }
                            return DeathKnell.hasCustomHoverName(murderWeapon) ? PLAYER_DEATH.getSubMessage("item", deadMob, killer, murderWeapon) : PLAYER_DEATH.getMessage(deadMob, killer);
                        }
                    }
                    break;
                }
                if (wasGenericKill) {
                    if (murderWeapon.method_31574(class_1802.field_8423)) {
                        return DEATH_BY_COOKIE.getMessage(deadMob, killer);
                    }
                    if (murderWeapon.method_31573(class_3489.field_40109)) {
                        return DEATH_BY_BOOK.getMessage(deadMob, killer);
                    }
                    if (murderWeapon.method_7909() instanceof class_1743 || murderWeapon.method_31573(class_3489.field_42612)) {
                        return DEATH_BY_AXE.getMessage(deadMob, killer);
                    }
                    if (DeathKnell.tryPercent(0.85f)) {
                        return DeathKnell.hasCustomHoverName(murderWeapon) ? GENERIC_SLAIN.getSubMessage("item", deadMob, killer, murderWeapon) : GENERIC_SLAIN.getMessage(deadMob, killer);
                    }
                }
            }
        }
        return original;
    }

    private static boolean hasCustomHoverName(class_1799 stack) {
        return stack.method_57826(class_9334.field_49631);
    }

    private static boolean wasGenericMobKill(class_2588 message) {
        return message != null && message.method_11022().startsWith("death.attack.mob");
    }

    private static boolean wasGenericPlayerKill(class_2588 message) {
        return message != null && message.method_11022().startsWith("death.attack.player");
    }

    private static boolean tryPercent(float percent) {
        return RNG.nextFloat() < percent;
    }
}

