/*
 * Decompiled with CFR 0.152.
 */
package net.runes.crafting;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import com.github.theredbrain.bundleapi.item.CustomBundleItem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RunePouches {
    private static final TagKey<Item> RUNES = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"runes", (String)"runes"));
    public static final List<Entry> entries = new ArrayList<Entry>();

    public static Entry entry(String name, int capacity, @Nullable Rarity rarity) {
        Item.Properties settings = new Item.Properties().stacksTo(1).component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"item.runes.rune_pouch.hint").withStyle(ChatFormatting.GRAY)))).component(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.builder().size_multiplier(capacity).build());
        if (rarity != null) {
            settings.rarity(rarity);
        }
        CustomBundleItem bundle = new CustomBundleItem(RUNES, settings);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"runes", (String)name);
        Entry entry = new Entry(id, capacity, (Item)bundle);
        entries.add(entry);
        return entry;
    }

    public static void register() {
        RunePouches.entry("small_rune_pouch", 4, null);
        RunePouches.entry("medium_rune_pouch", 8, null);
        RunePouches.entry("large_rune_pouch", 12, Rarity.UNCOMMON);
        for (Entry entry : entries) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item());
        }
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.COMBAT).register(content -> {
            for (Entry entry : entries) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public record Entry(ResourceLocation id, int capacity, Item item) {
    }
}

