#!/bin/python3
import os
from pathlib import Path

import yaml
from yaml.loader import SafeLoader
from os import listdir
from os.path import isfile, isdir, join
import json


def expand(models_dir :Path,id : str,dir : str,entry):
    match entry["type"]:
      case "cube":
          Path(join(models_dir,id + ".json")).write_text('''{
  "parent": "minecraft:block/cube_all",
  "textures": {
    "all": "MODID:block/ID"
  }
}'''.replace("MODID",dir).replace("ID",id))
      case _:
          base = Path(join(dir,"base_models",f["type"]+".json"))
          if base.is_file():
              with open(base,"r") as file:
                  data = file.read()
                  tid = id
                  js = json.loads(data)
                  if "texture_id" in entry:
                      tid = entry["texture_id"]
                  if "files" in js:
                      for name, js2 in js["files"].items():
                        name = name.replace("MODID",dir).replace("ID",id)
                        data2 = json.dumps(js2,indent=4)
                        print("write " + join(models_dir,name + ".json"))
                        Path(join(models_dir,name + ".json")).write_text(data2.replace("MODID",dir).replace("ID",tid))

                  else:
                    Path(join(models_dir,id + ".json")).write_text(data.replace("MODID",dir).replace("ID",id))
          else:
              print("error at ",f)
              print("invalid " + f["type"])

for dir in listdir("./"):
    if isdir(dir) and isfile(join(dir,"sourcegen.yaml")):
        with open(join(dir,"sourcegen.yaml")) as f:
            base = join("./",dir)
            blockstates = Path(join(base,"blockstates"))
            blockstates.mkdir(parents=True,exist_ok=True)
            blocksm = Path(join(base,"models","block"))
            blocksm.mkdir(parents=True,exist_ok=True)
            itemsm = Path(join(base,"models","item"))
            itemsm.mkdir(parents=True,exist_ok=True)
            Path(join(base,"textures","block")).mkdir(parents=True,exist_ok=True)
            Path(join(base,"textures","item")).mkdir(parents=True,exist_ok=True)
            data = yaml.load(f, Loader=SafeLoader)
            f : dict
            for f in data["blocks"]:
                id = list(f.keys())[0]
                f = f[id]
                expand(blocksm,id,dir,f)
                if f["item_gen"]:
                    if f["item_gen"] == "flat":
                        Path(join(itemsm,id + ".json")).write_text('''
{
  "parent": "minecraft:item/generated",
  "textures": {
    "layer0": "MODID:block/ID"
  }
}                                                                    '''.replace("MODID",dir).replace("ID",id))

                    else:
                        Path(join(itemsm,id + ".json")).write_text('''
{
    "parent": "MODID:block/ID"
}                                                                    '''.replace("MODID",dir).replace("ID",id))
                if "blockstate_gen" in f and f["blockstate_gen"] is True:
                    if "blockstate_rotate" in f and f["blockstate_rotate"]:
                        Path(join(blockstates,id + ".json")).write_text('''
{
  "variants": {
    "": [
      {
        "model": "MODID:block/ID"
      },
      {
        "model": "MODID:block/ID",
        "y": 90
      },
      {
        "model": "MODID:block/ID",
        "y": 180
      },
      {
        "model": "MODID:block/ID",
        "y": 270
      }
    ]
  }
}                                                                       '''.replace("MODID",dir).replace("ID",id))
                    else:
                        states_path = Path(join(dir,"base_blockstates",f["type"]+".json"))
                        if states_path.is_file():
                            with open(states_path,"r") as file:
                                data = file.read()
                                Path(join(blockstates,id + ".json")).write_text(data.replace("MODID",dir).replace("ID",id))
                        else:
                          Path(join(blockstates,id + ".json")).write_text('''
    {
        "variants": {
            "": {
                "model": "MODID:block/ID"
            }
        }
    }                                                                        '''.replace("MODID",dir).replace("ID",id))
