![Desertification title text](https://cdn.modrinth.com/data/cached_images/d0a5022ac820653a1fcbe971550d5e365d0181f0.webp)

****

Adds an "infectious" desert to your world. I had this idea for quite a while (before the infection mod trend) and finally did it. I took desertification as an inspiration (if the name wasn't clear enough).

This desert can also partially **cleanse** some infections. I made this feature compatible with [Fungal Infection: Spore](https://modrinth.com/mod/fungal-infectionspore) and [Sculk Horde](https://modrinth.com/mod/sculk-horde) among others.
*This is also the first mod that I publish*. Also note that it is just a personal project of mine, nothing too big.
While being pretty *stable*, this mod is still in **Beta**; do not use it on worlds you value without *backups*.

**The spread will not occur automatically (can be configured)**; you can either start it by breaking the hourglass structure found in the desert (or the cursed crystal structure found plain and forest biomes) or by giving yourself a Desert Sand block from your creative inventory and placing a few of them.

I made the mod so, contrary to most infection mods, you can *live* and thrive in the desert if you want (with some precautions, of course)

![A desert at sunrise](https://cdn.modrinth.com/data/lPDDc5bC/images/423a48a05cf6db36238e74e0fa2f5e98bc0fa38f.png "A desert at sunrise")


## About the (Neo)Forge version

<details>
<summary>Click to expand</summary>

The (Neo)Forge version in 1.20.1 uses [Sinytra Connector](https://modrinth.com/mod/connector) to run the fabric version on Forge. It is currently (Sep 2024) the only version of my mod that can interact with other infection mods, but it will change in the future as mods upgrade to 1.20.4/1.21

</details>

# Table of contents

Since the page is pretty long here is a list of the following sections in order :

- Videos
- Features and blocks
  - Mechanics
  - Blocks
  - Items
  - Entities
  - Nameless Altar
  - Enchantments
- Customization through datapacks
- Compatibilities
- Tips
- Details
- Permissions
- Credits and more

# ▶️ Videos

Here are some videos made by content creators on my mod, they may of course not be fully up to date.

## Minecraft but it's North Africa Desertification - By SoupMaster
### Version : 0.28, before the sandstorm, altar and nameless constructs

TODO add video card
https://www.youtube.com/watch?v=IpR6_pus_U0

Notes :
- A problem with the sandblaster recipe was encountered in this video, it has been fixed
- The recipes for the jam and guertoufa infusion looked buggy, it has been fixed on (Neo)Forge (on Fabric you can craft them too but the water bottle will be replaced by a uncraftable potion, but you can use a water bottle)
- The barrel cactus fruits grows on barrel cactus given enough time
- Sand roses can be obtained by breaking an overcharged sand rose without silk touch (or by scavenging suspicious sand left behind by a sandstorm, but they didn't exist back then)
- Jujubiers grown from saplings should normally be able to grow fruits (given some time) too
- Player variant of sandy diamond blocks (used in recipes) can also be crafted with 1 diamond, 1 amethyst block and 2 weathered sandstone

## Minecraft Mod Review: Desertification - By TheOneBeyond
### Version : 0.32, before the nameless construct

TODO add video card
https://www.youtube.com/watch?v=XMuwgPpRlF4

Notes : 
- You need 2 layers of clay at the bottom of the lake to make an oasis
- The rituals plans are either dropped from husks in the desert or sometimes are inside suspicious sand left behind by wind gusts
- The salt pond is a bit annoying because you have to make sure the salt block it will propagate to is surrounded by blocks
- The scorpion attacks Alex’s mobs and Born In Chaos’s flies
- You can make echo shard by sandblasting a shrieker
- Since I added a new mob in 0.33, some recipes have changed


# ℹ️ Features and blocks
This list may not be completely exhaustive. Some behavior can be configured from the mod's config screen (requires **MidnightLib**; the config screen has 3 tabs). The biome change is disabled by default

<details>
<summary>Click to expand</summary>

## Mechanics

**Oasis**: created by having water on top of 2 layers clay blocks (the bottom clay layer can be terracotta); prevents the blocks next to it from drying, needs to be at least 4 blocks in surface (and no deeper than 3 blocks)

**Cleansing**: as said above, this mod can partially cleanse other mod's infections. Mainly the block infection

**Biome change (disabled by default)** : if enabled, the desertification will change the current biome to a desert, it will be reverted when there is no longer desert sand around

**Generated desert sand in desert biomes (disabled by default)** : if this config is enabled, lumps of desert sand will be generated in deserts, making the infection start automatically.

**Long-distance desert random tick (can be disabled)** : the desert will force-load up to 2 chunks per world and random tick them to allow itself to advance towards the nearest player to a desert, even if they are far away. 

**Nameless altar** : *see dedicated section below*

**Salt desert**: created where there was water in swamps and rivers biomes (because swamps alone where too rare). Contains salt ponds that produce salt crystals

**Sandstorms and wind gust** : *See the entities section bellow*

**Flash floods** (can be disabled): during a thunderstorm some holes in the desert might suddenly be flooded, the flood block itself is pretty hard to get out of (for players and mobs alike) and will disappear when the weather goes back to clear. The flood will only break replacable or water-sensitive blocks.  *See also the flood totem bellow*

**Flowers barriers (configurable)**: a flower barrier will block the desert as long as there is no natural overcharged sand rose in a 75-block radius. They can be made by placing at the surface a contiguous line of desert flowers (the plant) under trees leaves (the tree's trunk need to be on the protected side)

## Blocks

**Desert flowers**: spawn when it rains and bloom afterward, used in recipes

**Jujubier**: spiky tree that makes jujube, which can be made into cakes

**Desert sand**: mod's main block,  propagate the desert, spawn plants; and wind gust. Convert zombies to husks and burn your feet in the day if you don't have boots

**Dry dirt**: a block of dried dirt that is created by the desert sand and serve as a gradient. Can only spread to dirt like block and up to 24 block away from desert sand (if a block isn't dryable by the dry dirt you will have to wait until the desert sand arrives). Also, the dry dirt can be removed by using bonemeal on it while next to dirt/grass blocks.

**Sand remains**:  a block that appears on some solid blocks near desert sand

**Dead log**: created when the desert kills a tree, spreads to nearby logs, and slowly decays

**Weathered sandstone**: kinda inspired by NieR Automata's desert zone, generate when desert sand is on granite, prevent sand accumulation on it


*Weathered sandstone slabs, stairs and walls* : decorative blocks crafted from weathered sandstone

![Weathered sandstone formation](https://cdn.modrinth.com/data/lPDDc5bC/images/478a44cbfae723f4cc535c21d45c4ee5b8834b20.webp)

**Dead branch** : decorative block created when leaves are near a dead log

**Salt blocks and deserts**: created in swamps and rivers biomes where there was water (can be disabled), kill slimes & water mobs and break plants, snow and ice. Can also damage wounded entities

**Salt pond** : rarely appear in salt deserts; they grow salt crystals if exposed to the sky, and the block above has air on its sides. Can be taken via silk touch and be propagated by throwing an enchanted sand rose, lapis & salt crystals in it (requires a top exposed salt block next to it, the sand rose will not be consumed)

**Salt crystals**: grow on salt ponds, can be used to damage undead/infected mobs, craft more salt blocks, or be converted to Spelunkery's / Mekanism's salt

**Sandy diamond block**: place desert sand around when broken and gives you some diamonds, found in hourglasses and cursed crystal structures.
A decorative version used for recipes can also be crafted

**Sandblaster** : inflicts heavy damage to entities and armor; can polish/strip blocks in front of it; powered by redstone; does less damage to undead mobs

**Vitalizer** : remove the desert when there is an infected block nearby, requires a tree in a 3 block radius (leaves) to function

**Sand rose** : block & material that is dropped by overcharged sand roses or can be found is suspicious sand left behind by a sandstorm

**Overcharged sand rose**: rarely created when a wind gust stops next to weathered sandstone on a sand slab (and there isn't one nearby (45 blocks), can be disabled in the config). It will create a wall of glazed sand around itself and zap nearby players and mobs.

The zap cap also bounces off to nearby mobs, causing them to be angered at the first mob. Husks and creepers will not be zapped. Drops sand roses when mined without silk touch, if mined with it, will drop itself.

The dropped overcharged sand rose will not zap non-hostile entities nor create a wall of glazed sand or enhance the desert's speed (unless placed on a redstone block).

**Enchanted sand rose**: crafted with sand roses, can be used as a material. Prevent sand accumulation in a 45 block radius. Can also boost sandblasters, vitalizers and overcharged desert rose when on them (for the overcharged rose it needs to be 2 blocks above). Prevents overcharged sand roses from spawning and sand deposit in a 45-block radius. Increase the wand of grass range when held offhand

![Sand roses](https://cdn.modrinth.com/data/lPDDc5bC/images/91f324f61480418493648ad4f0ffddd7e576960c.webp)

**Nameless altar core**: crafted with a netherite scrap or ingot (if you don't have scraps), used a core to the Nameless Altar (see Nameless Altar section bellow for more info) 

**Flood totem**: can create a flash flood around itself when raining/thundering (if the area is an enclosed 1-block hole). A redstone signal will block this and made the totem actually remove flood blocks around itself and prevent floods

**Ethereal bridge core** : create a bridge when powered by restone. The bridge's length will be determined by the signal's strength. Can be boosted by placing an enchanted sand rose next to it (will add 16 blocks to the bridge's range).

![Ethereal bridge core and blocks](https://cdn.modrinth.com/data/lPDDc5bC/images/a28bad3dcb38373e6bc82cd989e8b17593a55db3.webp)


****

**Fishhook barrel cactus** : can slow you down while making you take damage (it works on mobs too). Make fruits

**Desert flowers**: grow during the rain and bloom afterward. Useful for getting desert flowers and for flowers barriers. Can be taken with shears, need a water source next to it to not dry out.

**Other plants**: mainly used for dyes or ambiance (Guertoufa can be used for an infusion). The spread of all desert plants can be stopped by placing sandstone or smooth sandstone 2 blocks bellow it.



## Items

**Spear of sands** : a weapon that can summon a damaging wind gust when an enemy is killed, can be repaired with diamonds

**Wand of grass** : uses saplings to remove the desert, can also give undead/infected wither (if the entity already have wither I, it will increase to level II), can also be used for spreading grass by using bonemeal

**Sandhaper**: another weapon crafted using an enchanted sand rose. When used while not sneaking, it will create a temporary sand wall in front of the user and push mobs away from it. When used while sneaking, it will create a temporary sand pillar and teleport the user in top of it.

**Living glass scythe**: a weapon that will use living glass shards instead of durability. If, after an attack, the target is at 3 HP or lower, it will deal 3 additional damage. It will also inflict the glass shards effects on nearby mobs when right-clicked (consume living glass shards).

**Bottomless water buket**: a tool that can be used as an infinite water bucket. It can also remove, water like a bucket, if pointed at it. Finally you can fill a large area (16 block-radius, always lower or at the position you used it) by using it while sneaking.

**Barrel cactus fruit jam** : crafted with 2 water bottles (even if it displays as potions in the recipe), 2 barrel cactus fruits, 1 sugar and 1 apple. Cleanse the hunger effect

**Guertoufa infusion** : crafted with a water bottle (even if it displays as potions in the recipe) and 2 guertoufas. Cleanse the blindness and darkness effects

**Dry wand** : used for spreading the desert using slat crystal (in survival). Can be used to infect a large area while in creative

**Rift knife**: a weapon that will partially bypass armor and damage nearby entities of the same type.

## Entities

**Wind gust** : gust of winds that can push entities around and place sand (normal sand), can sometimes break some not-full blocks when it stops on them (configurable, does not break chests). May leave suspicious sand behind

**Scorpion** : small neutral critter that can spawn in the desert, give wither to attacked entities. Will attack if touched but is afraid of players. Hunt silverfish and other flies from Alex's Mobs and Born In Chaos and can be reproduced by using spider eyes

![A scorpion](https://cdn.modrinth.com/data/lPDDc5bC/images/246d86241e01644b1353041414d591f09a09a664.webp)

**Nameless construct** : a blaze-like weathered sandstone construct that can spawn in the desert near natural weathered sandstone at night, will attack players if they get too close, infected and pillagers. Can only do melee damage and has some armor, which will go down as it's speed goes up when on low hp. Will drop construct parts when killed. Will give a 1-second weakness when attacking infected/monster entities. Heal up to 2 hearts when killing an entity (if it kill a monster it will also have resistance for 10 seconds)

![A nameless construct](https://cdn.modrinth.com/data/lPDDc5bC/images/f08659256fd32c7a6df6de04c928db0f7e0e5fce.webp)

**Glass skeleton**: a variant of the skeleton can spawn anywhere in the desert but more often near overcharged sand roses/glazed sand. It can have either a bow or a melee weapon. It will also burn in the sun but will not take any damage. When damaged for the first time, it's attack will increase, and when low on health, it will become immune to projectiles. Drops living glass shards. Sensitive to temperature shocks.

**Sentient rift**: a strong hostile creature that spawn in large desert on a full or new moon, and will attack players, illagers or infecteds. Will prefer attacking an entity that is related in some way (owner, target, ...) to the previously attacked one (for example if it kills a pillager that was previously targeting a villager, it will attack the villager next). Halve the damage taken unless it is done by an enchanted item. Will also be weaker in sunlight (unless fighting an infected). Drops rifts and misc items. Finally, each kill heal it a little

**Sandstorm** : can occasionally spawn in large deserts (only when not raining). Will spawn a large amount of wind gusts, damage infected entities and sometimes leave behind suspicious sand with a sand rose in it (6% chance). Can be prevented in a 128-block radius by placing an enchanted sand rose.If they spawn in a 140-block radius of a natural overcharged sand rose, they will propagate the desert more. As entities, they can be managed through commands like `summon desert:sandstorm` or `function desert:clear_sandstorms`


## Nameless Altar

![A barebones Nameless Altar](https://cdn.modrinth.com/data/lPDDc5bC/images/38c40fb84b57d6301894973c2b3500a0b25f36be.webp)

The Nameless Altar can be used to perform various rituals that affect the world.

You first need to build an altar and place the core into the weathered sandstone pyramid;  you can then activate it by right-clicking the core with a sandshaper.

When the altar is activated, it will begin charging (and produce enchant particles to signify it); after a couple of minutes (or if you shift right-click on it in Creative with a Sandshaper), it will activate itself (the texture will change and ash particles will appear in the doorway).

When the altar is active,  you can build different rituals in the 3 by 4 space in the altar's doorway; and then right-click with a sandshaper on the block above the altar's core to execute them.

Here is the list of the different rituals;  there are also in-game items (Ritual plans; which can be used in creative to instabuild the ritual) that give you the requirements and blocks of the rituals:

* **Lightning ritual** : will strike every undead and infected in a 80-block radius
* **Cure ritual** : will cleanse any bad effects and give regeneration and absorption to every non-infected entity in a 80-block radius
* **Light ritual**: will place torches on the surface and in caves in a grid pattern in an 80-block radius; will not place a torch if there is already sufficient block lighting.
* **Glow ritual**: will make all entities in an 80-block radius glow for 2 minutes
* **Poison ritual**: will give poison (1:30), instant damage, slowness (3:00) and blindness (3:00) to every hostile entity in a 80-block radius
* **Abundance ritual**: will randomly bonemeal blocks (crops, grass, ...) on the surface in a large area and also halve the breeding time of animals
* **Freeze ritual**: will prevent mobs for moving for 1:30, small mobs will also be encased in temporary ice
* **Vitalise ritual**: will purify a large zone from the desert
* **Sponge duplication ritual**: simply duplicate sponges by using some dead horn coral
* **Sky doom ritual**: will target a strong entity in a 64-block radius (the criteria are max HP and if infected). The entity will be then be hit by lightning bolts for 30 seconds. If no entity with more than 40 max HP is found, most of the rituals materials will be given back (and some of the will be given back if the entity has less than 140 max HP)
* **Magnet ritual**: a simple ritual that will attract all items and xp orbs in a 128-block base radius
* **Desert sand craft ritual**: a ritual that will create a desert sand block item

You can also **boost** the altar's range and effect duration by placing enchanted sand roses on pillars (if the sand rose is well-placed, it will emit enchanting particles a couple of times every minute).

You can also make some rituals (not Lightning for example) target **specific** players (by default positive rituals will target every player while negative ones will not target any players), to do so you will need to hold a renamed piece of paper in your offhand or in the right slot relative to the selected item (required if you are using Better Combat) when you are triggering the ritual. The players names are case-insensitive and are separated by commas, you can start with an `!` to target every player in range expect those (note that negative rituals will never target you regardless).

If you are in create you can insta-build a ritual by right-clicking with its plan on the altar core.

Finally, you can also **offset** the altar's action range by placing amethyst blocks or lit redstone lamps in a cardinal direction relative to the altar's core; these blocks need to be at the same height as the altar's base, be at least 5 blocks away from the core (not counting the Y axis). Each of these blocks will offset the action range by 32 blocks. The end rod particle that appears when you interact with the altar will be offseted to reflect these changes.

### Enchantments

**Swift sands** (boots) : allow you to travel faster when on sand, can be dropped by zombies/skeletons in a large desert. Can also be crafted by throwing 1 lapis block, 1 book and 1 sand rose at an enchanted sand rose near an enchanting table

**Electrostatic** (chestplate) : inflicts weakness for 25/45 seconds to attackers, can be dropped by zombies/skeletons in a large desert. Can also be crafted by throwing 1 lapis block, 1 book and 1 overcharged sand rose at an enchanted sand rose near an enchanting table

**Wound salter** (weapons) : deals more damage the more wounded your target is; can be dropped by zombies/skeletons in a large desert. Can also be crafted by throwing 1 lapis block, 1 book and 1 salt crystal at an enchanted sand rose near an enchanting table

---

**Mob drops** : some mobs occasionally drop more loot if they spawn in the desert (like raw ore, desert items, ...) (configurable)

</details>


## 🔧 Customization through datapacks

<details>
<summary>Click to expand</summary>


In addition to the config, the mod's behavior can be customized through datapack tags (see the [Minecraft wiki](https://minecraft.wiki) if you want to know more about [datapacks](https://minecraft.wiki/w/Data_pack) or [tags](https://minecraft.wiki/w/Tag)), here is a list of some of the most important tags :

Blocks :
- `#desert:dryable` : any blocks in this tag will be converted into desert sand (unless they are in other conversion tags bellow)
- `#desert:desert_resist` : these block will not be converted/broken by the desert whatsoever
- `#desert:desert_remove` : these blocks will be broken by the desert
- `#desert:sandblaster/remove` : these blocks will be broken by the sandblaster
- `#desert:no_sand_acc` : wind gust will not place sand next to these blocks
- `#desert:weathered_sandstone_on` : if desert sand is on top of one of these blocks it will convert into weathered sandstone
- `#desert:dryable_unstable` : these blocks will be converted to desert sand, then the sand will remove itself
- `#desert:dryable_stones_extended` : these blocks will be converted to desert sand, then to sandstone if an overcharged sand rose is nearby 
- `#desert:to/dead_log` : these blocks will be converted to dead log, and dead logs will convert these blocks
- `#desert:speed/lower` and `#desert:speed/greatly_lowers` : blocks in these tags will take longer to convert (and make surrounding blocks harder to convert)
- `#desert:purify/purify_to_air` and `#desert:purify/purify_to_dirt` : controls blocks that are purified by the wand of grass
- `#desert:replace` : these blocks will be replaced when filling up holes in the sand
- `#desert:plants_replace` : these blocks will be replaced by desert plants
- `#desert:flood_replace` : these blocks will be replaced by flash floods
- `#desert:desert_no_drops` : these blocks will be broken without leaving drops (grass, ...)
- `#desert:gust_pass_through`: blocks that wind gust will pass through (unless they are full blocks)

Entities :
- `#desert:infected` : entities that the mod will consider infected
- `#desert:kill` : entities that will be killed when on desert sand
- `#desert:kill_extended` : entities that will be killed when on desert sand if an overcharged sand rose is nearby
- `#desert:salt_kill` : entities that will be killed when on a salt block (mostly water related entities)
- `#desert:no_direct_zap` : entities that the overcharged sand rose will not directly target (husk, ...)
- `#desert:sandstorm_damage` : entities that will take damage inside a sandstorm (infected by default)
- `#desert:scorpion_prey` : entities that the scorpion will attack (silverfishes, flies, ...)
- `#desert:sentient_rift_prey` : entities that the sentient rift will attack given time (players, villagers, ...)
- `#desert:nameless_construct_attacks` : entities that the nameless construct will attack (players, infected, pillagers, ...)
- `#desert:wind_gust_no_move` : entities that wind gusts will not move (scorpions, nameless constructs)
- `#desert:wand_of_grass_wither` : entities that will get wither when right-clicked with a wand of grass (infected and undeads)
- `#desert:prevents_gust_breaking_blocks` : entities that will prevent wind gust from breaking blocks when they are nearby (villagers and pillagers)

Items: 
- `#desert:wand_of_grass_purify_fuel` : items that will be consumed by the wand of grass to purify an area (saplings)

</details>

# ↔️ Compatibilities

Mod compatibilities

<details>
<summary>Click to expand</summary>

- **Infection mods :** Fungal Infection: Spore, The Sculk Horde, From Another World, The Flesh That Hates, Prion Infection, Phayriosis (partial), Moss Overgrowth (partial), Dawn of the flood (partial ?), Ecdysozoa Infection (partial), Necro Rooted (partial) ...

---

- **Better combat** : the spear of sands acts like a spear and the sandshaper like a wand (the rift knife and living glass scythe are compatible too)
- **Immersive weathering** : blocks around desert sand sometimes get converted to their sandy variants, sandy dirt is added near dry dirt, sand pile can sometimes spawn in place of sand remains
- **Cold Sweat** : the desert is hot during the day and cold during the night
- **Dynamic Trees** : trees are correctly killed by the desert, the desert will place dynamic trees plus cactuses instead of normal ones
- **Pollution of the Realms** : the desert is faster when the area is polluted and spawn less plants
- **Desert Behemoths: Sandworms!** : requires the biome change config to be enabled, the worm can spawn in the spreading desert
- **Farmer's delight**: some of the mod's plants can drop straw when broken with a knife

**Note about shaders**: while this mod causes no issues with shaders, some blocks (like desert sand) will not be rendered exactly like vanilla sand (even if they have the same texture), or plants will be shaded. If you really want to fix that you can either edit the shader's `block.properties` file (which I did for some of the screenshots with Rethinking Voxels) to add the block's id; or maybe, if you are a **shader dev**, use the [block tag support introduced in Iris 1.7](https://shaders.properties/current/reference/miscellaneous/block_properties/#data-pack-tags) in your shader (although this doesn't seem to be supported by Oculus)

</details>


# Tips

- To protect yourself from the harsh temperatures and sands, you will probably need boots (any type will do).

- To prevent the desert from advancing, you can either : build a base in a protected biome (jungle, tundra, ...) where the presence of trees will stop the desert, or make a barrier of terracotta/cobblestone that replaces sand, dirt-like and water. You can also build your base IN the desert (a little above ground). Finally, please note that the dry dirt has a limited spread range from the sand, it alone cannot infect a wide zone and will eventually stop without  the desert sand. Also, the dry dirt can be removed by using bonemeal on it while next to dirt.

- You can also use flowers barriers to block the desert if there is no overcharged sand roses nearby

- Trees will slow down the desert (you can also change the mod's config so that they will block the desert regardless of the biome)

- Desert flowers spawn when it rains on desert sand and bloom afterward

- Barrel cactus can be used as a defense


![Barrel cactus](https://cdn.modrinth.com/data/lPDDc5bC/images/0743586a5108d58768ef6e934b4f0b29fd15faa5.webp)



# Details

I have published this mod [on Curseforge](https://www.curseforge.com/minecraft/mc-mods/desertification) too, but this will remain the main page. I will probably port the mod to 1.21 given the time.

The spread is partially limited to an 8-chunk circular radius for any non-spectator player, it is a block random tick limitation of Minecraft (in more recent versions of the mod custom entities will random tick the parts of the desert that are far away from players, but they will not force-load chunks). The wind gusts that appear in the desert tries to random tick blocks that are under them, which helps a little.

*You cannot revert a zone exactly 1:1*. To revert a zone, you will need to use a wand of grass on the desert sand and have some saplings with you (take note that the item has a cooldown). You can also use vitalizer blocks or vitalization ritual


## Permissions
- You can create videos/content using my mod
- You can integrate my mod into your Modpack (but beware that the mod is still in Beta)
- You should give a link back to this page (either the Modrinth or Curseforge one)


## Credits and more
- Most screenshots use the excellent Lucidium resource pack (which also makes leaves go brown when no longer attached) and (sometimes) the VanillaPlus or Rethinking Voxels shaders.
- All the mod's custom textures are made by me using Krita (except the sand remains, the sandy diamond block, pink water, ritual plans and the bottles).
- Some models and mobs where made using Blockbench
- Thanks also to the Sinytra Connector Team for their amazing mod that allows fabric mods to run on (Neo)forge
- [Fabric Language Kotlin](https://modrinth.com/mod/fabric-language-kotlin)
- Text logo made with Minecraft Title Generator Blockbench plugin