/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.server.MinecraftServer;
import net.rizecookey.combatedit.api.CombatEditApi;
import net.rizecookey.combatedit.api.CombatEditInitListener;
import net.rizecookey.combatedit.api.extension.ProfileExtensionProvider;
import net.rizecookey.combatedit.command.CombatEditCommand;
import net.rizecookey.combatedit.configuration.Settings;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import net.rizecookey.combatedit.configuration.provider.ConfigurationManager;
import net.rizecookey.combatedit.extension.DynamicComponentMap;
import net.rizecookey.combatedit.extension.DynamicDefaultAttributeContainer;
import net.rizecookey.combatedit.utils.serializers.AttributeModifierSlotSerializer;
import net.rizecookey.combatedit.utils.serializers.EntityAttributeModifier$OperationSerializer;
import net.rizecookey.combatedit.utils.serializers.IdentifierSerializer;
import net.rizecookey.combatedit.utils.serializers.MutableConfigurationTypeAdapterFactory;
import net.rizecookey.combatedit.utils.serializers.TextSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CombatEdit
implements CombatEditApi {
    private static CombatEdit INSTANCE;
    public static final Path DEFAULT_SETTINGS_PATH;
    public static final Logger LOGGER;
    public static final Gson GSON;
    private boolean modificationsEnabled;
    private Settings settings;
    private final ConfigurationManager configurationManager;
    @Nullable
    private MinecraftServer currentServer;

    public CombatEdit() {
        INSTANCE = this;
        this.modificationsEnabled = false;
        this.configurationManager = new ConfigurationManager(this);
        try {
            this.loadSettings();
        }
        catch (IOException e) {
            this.onSettingsLoadError(e);
        }
        catch (InvalidConfigurationException e) {
            this.onSettingsLoadError(e);
        }
        this.registerListeners();
        FabricLoader.getInstance().invokeEntrypoints("combatedit", CombatEditInitListener.class, listener -> listener.onCombatEditInit(this));
        LOGGER.info("Successfully initialized CombatEdit.");
    }

    public Settings getCurrentSettings() {
        return this.settings;
    }

    protected void setCurrentSettings(Settings settings) {
        this.settings = settings;
    }

    public void loadSettings() throws IOException, InvalidConfigurationException {
        if (!Files.exists(DEFAULT_SETTINGS_PATH, new LinkOption[0])) {
            LOGGER.info("No settings file found, loading and saving default.");
            this.loadDefaultSettingsAndSave();
        } else {
            this.setCurrentSettings(Settings.load(DEFAULT_SETTINGS_PATH));
        }
        this.getCurrentSettings().validate();
        LOGGER.info("Settings loaded.");
    }

    public void saveSettings(Settings settings) throws IOException {
        settings.save(DEFAULT_SETTINGS_PATH);
        this.setCurrentSettings(settings);
        LOGGER.info("Settings saved.");
    }

    private void useDefaultSettings() {
        this.setCurrentSettings(Settings.loadDefault());
    }

    private void loadDefaultSettingsAndSave() throws IOException {
        this.useDefaultSettings();
        this.saveSettings(this.getCurrentSettings());
    }

    public void resetSettings() throws IOException {
        this.loadDefaultSettingsAndSave();
        LOGGER.info("Reset settings.");
    }

    protected void onSettingsLoadError(InvalidConfigurationException exception) {
        LOGGER.error("Settings validation failed", (Throwable)exception);
        LOGGER.warn("Using default settings.");
        this.settings = Settings.loadDefault();
    }

    protected void onSettingsLoadError(IOException exception) {
        LOGGER.error("Failed to load the settings file", (Throwable)exception);
        LOGGER.warn("Using default settings.");
        this.settings = Settings.loadDefault();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    @Nullable
    public MinecraftServer getCurrentServer() {
        return this.currentServer;
    }

    public void registerListeners() {
        CommandRegistrationCallback.EVENT.register((Object)new CombatEditCommand(this));
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this.configurationManager);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.currentServer = server;
            this.setModificationsEnabled(true);
            LOGGER.info("Turned on modifications.");
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.setModificationsEnabled(false);
            this.currentServer = null;
            LOGGER.info("Turned off modifications.");
        });
    }

    public boolean areModificationsEnabled() {
        return this.modificationsEnabled;
    }

    public void setModificationsEnabled(boolean enabled) {
        this.modificationsEnabled = enabled;
        DynamicComponentMap.setUseExchangeable(enabled);
        DynamicDefaultAttributeContainer.setUseExchangeable(enabled);
    }

    public void warnAboutItemIncompatibility(List<class_1792> items) {
        LOGGER.error("The following items do not have a dynamic component map and could therefore not be modified by CombatEdit:{}\nPlease report this incompatibility at https://www.github.com/rizecookey/CombatEdit/issues.", (Object)items.stream().map(item -> System.lineSeparator() + "\t- " + item.toString()).collect(Collectors.joining()));
    }

    public void warnAboutEntityIncompatibility(List<class_1299<? extends class_1309>> entities) {
        LOGGER.error("The following entity types do not have a dynamic default component and could therefore not be modified by CombatEdit:{}\nPlease report this incompatibility at https://www.github.com/rizecookey/CombatEdit/issues.", (Object)entities.stream().map(entity -> System.lineSeparator() + "\t- " + String.valueOf(class_7923.field_41177.method_10221(entity))).collect(Collectors.joining()));
    }

    public static CombatEdit getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerProfileExtension(class_2960 profileId, ProfileExtensionProvider extensionProvider) {
        this.configurationManager.registerProfileExtension(profileId, extensionProvider);
    }

    static {
        DEFAULT_SETTINGS_PATH = FabricLoader.getInstance().getConfigDir().resolve("combatedit/settings.json");
        LOGGER = LogManager.getLogger(CombatEdit.class);
        GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)new MutableConfigurationTypeAdapterFactory()).registerTypeAdapter(class_2960.class, (Object)new IdentifierSerializer()).registerTypeAdapter(class_9274.class, (Object)new AttributeModifierSlotSerializer()).registerTypeAdapter(class_1322.class_1323.class, (Object)new EntityAttributeModifier$OperationSerializer()).registerTypeAdapter(class_2561.class, (Object)new TextSerializer()).create();
    }
}

