/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration;

import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import net.rizecookey.combatedit.configuration.exception.ResourceLoadFailureException;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.ConfigurationView;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;

public class BaseProfile {
    public static final String BASE_PROFILE_PATH = "combatedit/base_profiles";
    public static final String BASE_PROFILE_ENDING = ".json";
    private class_2561 name;
    private class_2561 description;
    @SerializedName(value="configuration")
    private MutableConfiguration parsedConfiguration;
    private transient Configuration configuration;

    public BaseProfile(class_2561 name, class_2561 description, Configuration configuration) {
        this.name = name;
        this.description = description;
        this.configuration = configuration;
    }

    protected BaseProfile() {
    }

    public class_2561 getName() {
        return this.name;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            MutableConfiguration config = this.parsedConfiguration != null ? this.parsedConfiguration : new MutableConfiguration();
            this.configuration = new ConfigurationView(config, MutableConfiguration.loadDefault());
        }
        return this.configuration;
    }

    public void validate() throws InvalidConfigurationException {
        if (this.name == null) {
            throw new InvalidConfigurationException("name is required");
        }
        if (this.description == null) {
            throw new InvalidConfigurationException("description is required");
        }
        this.getConfiguration().validate();
    }

    public static Map<class_2960, BaseProfile> find(class_3300 manager) {
        HashMap<class_2960, BaseProfile> baseProfiles = new HashMap<class_2960, BaseProfile>();
        for (Map.Entry entry : manager.method_14488(BASE_PROFILE_PATH, id -> id.method_12832().endsWith(BASE_PROFILE_ENDING)).entrySet()) {
            class_2960 shortId = BaseProfile.getShortId((class_2960)entry.getKey());
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    BaseProfile baseProfile = (BaseProfile)CombatEdit.GSON.fromJson((Reader)reader, BaseProfile.class);
                    baseProfile.validate();
                    baseProfiles.put(shortId, baseProfile);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new ResourceLoadFailureException(e);
            }
            catch (InvalidConfigurationException e) {
                CombatEdit.LOGGER.error("Could not load base profile {}", (Object)shortId.toString(), (Object)e);
            }
        }
        return baseProfiles;
    }

    private static class_2960 getShortId(class_2960 longId) {
        String path = longId.method_12832();
        if (!path.startsWith(BASE_PROFILE_PATH) || !path.endsWith(BASE_PROFILE_ENDING)) {
            throw new IllegalArgumentException("Not a valid base profile identifier");
        }
        return class_2960.method_60655((String)longId.method_12836(), (String)path.substring(BASE_PROFILE_PATH.length() + 1, path.length() - BASE_PROFILE_ENDING.length()));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.getConfiguration());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseProfile)) {
            return false;
        }
        BaseProfile profile = (BaseProfile)obj;
        return Objects.equals(this.name, profile.name) && Objects.equals(this.description, profile.description) && Objects.equals(this.getConfiguration(), profile.getConfiguration());
    }

    public static enum IntegratedProfiles {
        VANILLA(new Info(class_2960.method_60655((String)"combatedit", (String)"vanilla"), (class_2561)class_2561.method_43471((String)"profile.combatedit.vanilla.name"), (class_2561)class_2561.method_43471((String)"profile.combatedit.vanilla.description"))),
        OLD_1_8_COMBAT(new Info(class_2960.method_60655((String)"combatedit", (String)"1_8_combat"), (class_2561)class_2561.method_43471((String)"profile.combatedit.1_8_combat.name"), (class_2561)class_2561.method_43471((String)"profile.combatedit.1_8_combat.description")));

        private final Info info;

        private IntegratedProfiles(Info info) {
            this.info = info;
        }

        public Info getInfo() {
            return this.info;
        }
    }

    public record Info(class_2960 id, class_2561 name, class_2561 description) {
    }
}

