/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration;

import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;

public class ProfileExtension {
    public static final String PROFILE_EXTENSIONS_PATH = "combatedit/profile_extensions";
    public static final String PROFILE_EXTENSIONS_ENDING = ".json";
    private int priority;
    @SerializedName(value="configuration_overrides")
    private MutableConfiguration parsedConfigurationOverrides;
    private transient Configuration configurationOverrides;

    public ProfileExtension(Configuration configurationOverrides, int priority) {
        this.configurationOverrides = configurationOverrides;
        this.priority = priority;
    }

    protected ProfileExtension() {
    }

    public int getPriority() {
        return this.priority;
    }

    public Configuration getConfigurationOverrides() {
        if (this.configurationOverrides == null) {
            this.configurationOverrides = this.parsedConfigurationOverrides != null ? this.parsedConfigurationOverrides : new MutableConfiguration();
        }
        return this.configurationOverrides;
    }

    public void validate() throws InvalidConfigurationException {
        this.getConfigurationOverrides().validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileExtension)) {
            return false;
        }
        ProfileExtension that = (ProfileExtension)o;
        return this.getPriority() == that.getPriority() && Objects.equals(this.getConfigurationOverrides(), that.getConfigurationOverrides());
    }

    public int hashCode() {
        return Objects.hash(this.getPriority(), this.getConfigurationOverrides());
    }

    public static List<ProfileExtension> findForProfile(class_3300 resourceManager, class_2960 baseProfile) {
        Map profileExtensions = resourceManager.method_14488("combatedit/profile_extensions/" + baseProfile.method_12836() + "/" + baseProfile.method_12832(), identifier -> identifier.method_12832().endsWith(PROFILE_EXTENSIONS_ENDING));
        ArrayList<ProfileExtension> extensions = new ArrayList<ProfileExtension>();
        for (Map.Entry entry : profileExtensions.entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    ProfileExtension profile = (ProfileExtension)CombatEdit.GSON.fromJson((Reader)reader, ProfileExtension.class);
                    profile.validate();
                    extensions.add(profile);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read profile extension", e);
            }
            catch (InvalidConfigurationException e) {
                CombatEdit.LOGGER.error("Profile extension {} is invalid", (Object)((class_2960)entry.getKey()).toString(), (Object)e);
            }
        }
        return extensions;
    }
}

