/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2960;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;

public class Settings {
    public static final int CURRENT_VERSION = 1;
    private int settingsVersion;
    private class_2960 selectedBaseProfile;
    private ClientOnly client;
    private MutableConfiguration configurationOverrides;

    public Settings(int settingsVersion, class_2960 selectedBaseProfile, ClientOnly client, MutableConfiguration configurationOverrides) {
        this.settingsVersion = settingsVersion;
        this.selectedBaseProfile = selectedBaseProfile;
        this.client = client;
        this.configurationOverrides = configurationOverrides;
    }

    protected Settings() {
    }

    public int getSettingsVersion() {
        if (this.settingsVersion == 0) {
            this.settingsVersion = 1;
        }
        return this.settingsVersion;
    }

    public class_2960 getSelectedBaseProfile() {
        return this.selectedBaseProfile;
    }

    public MutableConfiguration getConfigurationOverrides() {
        if (this.configurationOverrides == null) {
            this.configurationOverrides = new MutableConfiguration();
        }
        return this.configurationOverrides;
    }

    public ClientOnly getClientOnly() {
        if (this.client == null) {
            this.client = new ClientOnly();
        }
        return this.client;
    }

    public void setSettingsVersion(int settingsVersion) {
        this.settingsVersion = settingsVersion;
    }

    public void setSelectedBaseProfile(class_2960 selectedBaseProfile) {
        this.selectedBaseProfile = selectedBaseProfile;
    }

    public void validate() throws InvalidConfigurationException {
        if (this.settingsVersion > 1) {
            throw new InvalidConfigurationException("Configuration claims to be of a higher version than the current one");
        }
        if (this.getSelectedBaseProfile() == null) {
            throw new InvalidConfigurationException("No selected profile specified");
        }
        this.getConfigurationOverrides().validate();
    }

    public void save(Path path) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (JsonWriter writer = CombatEdit.GSON.newJsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            CombatEdit.GSON.toJson((Object)this, Settings.class, writer);
        }
    }

    public Settings copy() {
        return new Settings(this.settingsVersion, this.selectedBaseProfile, this.client != null ? this.client.copy() : null, this.configurationOverrides != null ? this.configurationOverrides.copy() : null);
    }

    public static Settings load(Path path) throws IOException, InvalidConfigurationException {
        Settings settings;
        block10: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonObject object = (JsonObject)CombatEdit.GSON.fromJson((Reader)reader, JsonObject.class);
                JsonElement settingsVersion = object.get("settings_version");
                if (settingsVersion != null && settingsVersion.isJsonPrimitive() && settingsVersion.getAsInt() < 1) {
                    object = Settings.migrateToNewerVersion(object, settingsVersion.getAsInt());
                }
                settings = (Settings)CombatEdit.GSON.fromJson((JsonElement)object, Settings.class);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonIOException e) {
                    throw new IOException(e);
                }
                catch (JsonSyntaxException e) {
                    throw new InvalidConfigurationException(e);
                }
            }
            reader.close();
        }
        return settings;
    }

    private static JsonObject migrateToNewerVersion(JsonObject oldSettings, int version) {
        return oldSettings.deepCopy();
    }

    private static JsonObject loadDefaultJson() throws IOException {
        try (InputStream in = MutableConfiguration.class.getResourceAsStream("/settings.json");){
            if (in == null) {
                throw new IOException("Resource was not bundled correctly");
            }
            JsonObject jsonObject = (JsonObject)CombatEdit.GSON.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
            return jsonObject;
        }
    }

    public static Settings loadDefault() {
        try {
            return (Settings)CombatEdit.GSON.fromJson((JsonElement)Settings.loadDefaultJson(), Settings.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load default settings file", e);
        }
    }

    public static class ClientOnly {
        private boolean disableNewTooltips;

        public ClientOnly(boolean disableNewTooltips) {
            this.disableNewTooltips = disableNewTooltips;
        }

        public ClientOnly() {
        }

        public boolean shouldDisableNewTooltips() {
            return this.disableNewTooltips;
        }

        public void setDisableNewTooltips(boolean disableNewTooltips) {
            this.disableNewTooltips = disableNewTooltips;
        }

        public ClientOnly copy() {
            return new ClientOnly(this.disableNewTooltips);
        }
    }
}

