/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.provider;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.api.extension.ProfileExtensionProvider;
import net.rizecookey.combatedit.configuration.BaseProfile;
import net.rizecookey.combatedit.configuration.ProfileExtension;
import net.rizecookey.combatedit.configuration.Settings;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.ConfigurationView;
import net.rizecookey.combatedit.configuration.representation.EntityAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemComponents;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;
import net.rizecookey.combatedit.modification.PropertyModifier;
import net.rizecookey.combatedit.utils.ItemStackAttributeHelper;
import net.rizecookey.combatedit.utils.Pair;

public class ConfigurationManager
implements SimpleResourceReloadListener<LoadResult> {
    private static ConfigurationManager INSTANCE;
    private final CombatEdit combatEdit;
    private Configuration configuration;
    private final ItemStackAttributeHelper attributeHelper;
    private final PropertyModifier propertyModifier;
    private final Map<class_2960, List<ProfileExtensionProvider>> registeredProfileExtensions;
    private Map<class_2960, BaseProfile> baseProfiles;
    private List<EntityAttributes> oldEntityAttributes;
    private List<ItemAttributes> oldItemAttributes;
    private List<ItemComponents> oldItemComponents;
    private long lastAttributeReload = Long.MIN_VALUE;

    public ConfigurationManager(CombatEdit combatEdit) {
        this.combatEdit = combatEdit;
        this.propertyModifier = new PropertyModifier(this);
        this.attributeHelper = new ItemStackAttributeHelper(this);
        this.registeredProfileExtensions = new HashMap<class_2960, List<ProfileExtensionProvider>>();
        INSTANCE = this;
    }

    public class_2960 getFabricId() {
        return class_2960.method_43902((String)"combatedit", (String)"server_configuration_provider");
    }

    public CompletableFuture<LoadResult> load(class_3300 manager, Executor executor) {
        CompletableFuture<Settings> settingsLoader = CompletableFuture.supplyAsync(() -> ConfigurationManager.loadSettings(this.combatEdit), executor);
        CompletableFuture<Map> baseProfileLoader = CompletableFuture.supplyAsync(() -> ConfigurationManager.loadBaseProfiles(manager), executor);
        CompletionStage profileLoader = settingsLoader.thenCombineAsync(baseProfileLoader, (settings, baseProfiles) -> {
            class_2960 selectedProfile = settings.getSelectedBaseProfile();
            if (!baseProfiles.containsKey(selectedProfile)) {
                CombatEdit.LOGGER.error("No base profile with id {} found! Using default profile.", (Object)settings.getSelectedBaseProfile());
                selectedProfile = Settings.loadDefault().getSelectedBaseProfile();
                if (!baseProfiles.containsKey(selectedProfile)) {
                    throw new IllegalStateException("Default base profile does not exist");
                }
            }
            CombatEdit.LOGGER.info("Selected base profile: {}", (Object)selectedProfile.toString());
            return new Pair<Map, List<ProfileExtension>>((Map)baseProfiles, ConfigurationManager.loadProfileExtensions(manager, selectedProfile));
        }, executor);
        return ((CompletableFuture)((CompletableFuture)profileLoader).thenCombineAsync(settingsLoader, (profile, settings) -> new LoadResult((Settings)settings, (Map)profile.first(), (List)profile.second()), executor)).exceptionallyAsync(e -> {
            CombatEdit.LOGGER.error("Failed to load CombatEdit configuration resources", e);
            return null;
        }, executor);
    }

    public CompletableFuture<Void> apply(LoadResult data, class_3300 manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            boolean modificationsChanged;
            if (data == null) {
                this.updateConfiguration(null);
                return;
            }
            this.baseProfiles = data.baseProfiles();
            ArrayList<ProfileExtension> withCustom = new ArrayList<ProfileExtension>(data.profileExtensions());
            ((List)this.registeredProfileExtensions.getOrDefault(data.settings().getSelectedBaseProfile(), new ArrayList())).forEach(provider -> withCustom.add(provider.provideExtension(data.baseProfiles().get(data.settings().getSelectedBaseProfile()), this.getModifier())));
            this.updateConfiguration(new LoadResult(data.settings(), data.baseProfiles(), withCustom));
            boolean bl = modificationsChanged = !Objects.equals(this.oldItemAttributes, this.configuration.getItemAttributes()) || !Objects.equals(this.oldEntityAttributes, this.configuration.getEntityAttributes()) || !Objects.equals(this.oldItemComponents, this.configuration.getItemComponents());
            if (modificationsChanged) {
                this.adjustModifications();
            }
        }, executor);
    }

    public CombatEdit getCombatEdit() {
        return this.combatEdit;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ItemStackAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public PropertyModifier getModifier() {
        return this.propertyModifier;
    }

    public MinecraftServer getCurrentServer() {
        return this.combatEdit.getCurrentServer();
    }

    public Map<class_2960, BaseProfile> getBaseProfiles() {
        return this.baseProfiles;
    }

    public long getLastAttributeReload() {
        return this.lastAttributeReload;
    }

    private static Settings loadSettings(CombatEdit combatEdit) {
        return combatEdit.getCurrentSettings();
    }

    private static Map<class_2960, BaseProfile> loadBaseProfiles(class_3300 manager) {
        Map<class_2960, BaseProfile> result = BaseProfile.find(manager);
        CombatEdit.LOGGER.info("Found {} base profiles: {}", (Object)result.size(), (Object)result.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
        return result;
    }

    private static List<ProfileExtension> loadProfileExtensions(class_3300 manager, class_2960 baseProfileSelected) {
        List<ProfileExtension> result = ProfileExtension.findForProfile(manager, baseProfileSelected);
        CombatEdit.LOGGER.info("Found {} base profile extensions for {}", (Object)result.size(), (Object)baseProfileSelected.toString());
        return result;
    }

    private void updateConfiguration(LoadResult data) {
        if (data == null) {
            this.configuration = MutableConfiguration.loadDefault();
            CombatEdit.LOGGER.warn("Default configuration loaded.");
            return;
        }
        ArrayList<Configuration> prioritizedConfigurationList = new ArrayList<Configuration>();
        prioritizedConfigurationList.add(data.settings().getConfigurationOverrides());
        prioritizedConfigurationList.addAll(data.profileExtensions().stream().sorted(Comparator.comparingInt(ProfileExtension::getPriority).reversed()).map(ProfileExtension::getConfigurationOverrides).toList());
        prioritizedConfigurationList.add(data.baseProfiles().get(data.settings().getSelectedBaseProfile()).getConfiguration());
        this.configuration = new ConfigurationView(prioritizedConfigurationList.toArray(new Configuration[0])).compileCurrentState();
        CombatEdit.LOGGER.info("Configuration updated.");
    }

    private void adjustModifications() {
        this.propertyModifier.makeModifications();
        this.oldItemAttributes = List.copyOf(this.configuration.getItemAttributes());
        this.oldEntityAttributes = List.copyOf(this.configuration.getEntityAttributes());
        this.oldItemComponents = List.copyOf(this.configuration.getItemComponents());
        this.lastAttributeReload = System.currentTimeMillis();
        CombatEdit.LOGGER.info("Adjusted attribute modifications.");
    }

    public void registerProfileExtension(class_2960 profileId, ProfileExtensionProvider extensionProvider) {
        this.registeredProfileExtensions.computeIfAbsent(profileId, key -> new ArrayList()).add(extensionProvider);
    }

    public static ConfigurationManager getInstance() {
        return INSTANCE;
    }

    public record LoadResult(Settings settings, Map<class_2960, BaseProfile> baseProfiles, List<ProfileExtension> profileExtensions) {
    }
}

