/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.representation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;

public class EntityAttributes {
    private class_2960 entityId;
    private List<AttributeBaseValue> baseValues;
    private boolean overrideDefault;

    public EntityAttributes(class_2960 entityId, List<AttributeBaseValue> baseValues, boolean overrideDefault) {
        this.entityId = entityId;
        this.baseValues = new ArrayList<AttributeBaseValue>(baseValues);
        this.overrideDefault = overrideDefault;
    }

    protected EntityAttributes() {
    }

    public class_2960 getEntityId() {
        return this.entityId;
    }

    public void setEntityId(class_2960 entityId) {
        this.entityId = entityId;
    }

    public List<AttributeBaseValue> getBaseValues() {
        if (this.baseValues == null) {
            this.baseValues = new ArrayList<AttributeBaseValue>();
        }
        return this.baseValues;
    }

    public boolean isOverrideDefault() {
        return this.overrideDefault;
    }

    public void setOverrideDefault(boolean overrideDefault) {
        this.overrideDefault = overrideDefault;
    }

    public void validate() throws InvalidConfigurationException {
        if (this.entityId == null || !class_7923.field_41177.method_10250(this.entityId)) {
            throw new InvalidConfigurationException("No entity with id %s found".formatted(this.entityId));
        }
        for (AttributeBaseValue baseValue : this.getBaseValues()) {
            baseValue.validate();
        }
    }

    public EntityAttributes copy() {
        return new EntityAttributes(this.entityId, List.copyOf(this.baseValues), this.overrideDefault);
    }

    public static EntityAttributes getDefault() {
        return new EntityAttributes(class_7923.field_41177.method_10221((Object)class_1299.field_6046), List.of(), false);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityAttributes)) {
            return false;
        }
        EntityAttributes attr = (EntityAttributes)obj;
        return this.getEntityId().equals((Object)attr.getEntityId()) && this.isOverrideDefault() == attr.isOverrideDefault() && this.getBaseValues().equals(attr.getBaseValues());
    }

    public int hashCode() {
        return Objects.hash(this.getEntityId(), this.getBaseValues(), this.isOverrideDefault());
    }

    public record AttributeBaseValue(class_2960 attribute, double baseValue) {
        public static AttributeBaseValue getDefault() {
            class_6880 attackDamageAttribute = class_5134.field_23721;
            return new AttributeBaseValue(class_7923.field_41190.method_10221((Object)((class_1320)attackDamageAttribute.comp_349())), 1.0);
        }

        public void validate() throws InvalidConfigurationException {
            if (this.attribute() == null || !class_7923.field_41190.method_10250(this.attribute())) {
                throw new InvalidConfigurationException("No attribute with id %s found".formatted(this.attribute()));
            }
        }
    }
}

