/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.representation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import org.jetbrains.annotations.Nullable;

public class ItemAttributes {
    private class_2960 itemId;
    private List<ModifierEntry> modifiers;
    private boolean overrideDefault;

    public ItemAttributes(class_2960 itemId, List<ModifierEntry> modifiers, boolean overrideDefault) {
        this.itemId = itemId;
        this.modifiers = new ArrayList<ModifierEntry>(modifiers);
        this.overrideDefault = overrideDefault;
    }

    protected ItemAttributes() {
    }

    public class_2960 getItemId() {
        return this.itemId;
    }

    public void setItemId(class_2960 itemId) {
        this.itemId = itemId;
    }

    public List<ModifierEntry> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<ModifierEntry>();
        }
        return this.modifiers;
    }

    public boolean isOverrideDefault() {
        return this.overrideDefault;
    }

    public void setOverrideDefault(boolean overrideDefault) {
        this.overrideDefault = overrideDefault;
    }

    public void validate() throws InvalidConfigurationException {
        if (this.itemId == null || !class_7923.field_41178.method_10250(this.itemId)) {
            throw new InvalidConfigurationException("No item with id %s found".formatted(this.itemId));
        }
        for (ModifierEntry modifier : this.getModifiers()) {
            modifier.validate();
        }
    }

    public ItemAttributes copy() {
        return new ItemAttributes(this.itemId, List.copyOf(this.modifiers), this.overrideDefault);
    }

    public static ItemAttributes getDefault() {
        return new ItemAttributes(class_7923.field_41178.method_10221((Object)class_1802.field_8091), List.of(), false);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.modifiers, this.overrideDefault);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemAttributes)) {
            return false;
        }
        ItemAttributes attr = (ItemAttributes)obj;
        return this.itemId.equals((Object)attr.itemId) && this.modifiers.equals(attr.modifiers) && this.overrideDefault == attr.overrideDefault;
    }

    public record ModifierEntry(class_2960 attribute, @Nullable class_2960 modifierId, double value, class_1322.class_1323 operation, class_9274 slot) {
        public static ModifierEntry getDefault() {
            return new ModifierEntry(class_7923.field_41190.method_10221((Object)((class_1320)class_5134.field_23721.comp_349())), class_1792.field_8006, 1.0, class_1322.class_1323.field_6328, class_9274.field_49217);
        }

        public void validate() throws InvalidConfigurationException {
            if (this.attribute == null || !class_7923.field_41190.method_10250(this.attribute)) {
                throw new InvalidConfigurationException("No attribute with id %s found".formatted(this.attribute));
            }
            if (this.operation == null) {
                throw new InvalidConfigurationException("No operation has been specified for this modifier");
            }
            if (this.slot == null) {
                throw new InvalidConfigurationException("No slot has been specified for this modifier");
            }
        }
    }
}

