/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.representation;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1802;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import org.jetbrains.annotations.Nullable;

public class ItemComponents {
    private class_2960 itemId;
    private List<ComponentChangeEntry> changes;

    public ItemComponents(class_2960 itemId, List<ComponentChangeEntry> changes) {
        this.itemId = itemId;
        this.changes = new ArrayList<ComponentChangeEntry>(changes);
    }

    protected ItemComponents() {
    }

    public class_2960 getItemId() {
        return this.itemId;
    }

    public void setItemId(class_2960 itemId) {
        this.itemId = itemId;
    }

    public List<ComponentChangeEntry> getChanges() {
        if (this.changes == null) {
            this.changes = new ArrayList<ComponentChangeEntry>();
        }
        return this.changes;
    }

    public void validate() throws InvalidConfigurationException {
        if (this.itemId == null || !class_7923.field_41178.method_10250(this.itemId)) {
            throw new InvalidConfigurationException("No item with id %s found".formatted(this.itemId));
        }
        for (ComponentChangeEntry component : this.getChanges()) {
            component.validate();
        }
    }

    public ItemComponents copy() {
        return new ItemComponents(this.itemId, List.copyOf(this.changes));
    }

    public static ItemComponents getDefault() {
        return new ItemComponents(class_7923.field_41178.method_10221((Object)class_1802.field_8091), List.of());
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.changes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemComponents)) {
            return false;
        }
        ItemComponents comps = (ItemComponents)obj;
        return this.itemId.equals((Object)comps.itemId) && this.changes.equals(comps.changes);
    }

    public record ComponentChangeEntry(class_2960 componentType, ChangeType changeType, String value) {
        public ComponentChangeEntry(class_2960 componentType, @Nullable ChangeType changeType, @Nullable String value) {
            this.componentType = componentType;
            this.changeType = changeType != null ? changeType : ChangeType.SET;
            this.value = value != null ? value : "";
        }

        public void validate() throws InvalidConfigurationException {
            class_2520 element;
            if (this.componentType == null || !class_7923.field_49658.method_10250(this.componentType)) {
                throw new InvalidConfigurationException("Unknown component id");
            }
            if (ChangeType.REMOVE.equals((Object)this.changeType)) {
                return;
            }
            class_9331 type = (class_9331)class_7923.field_49658.method_63535(this.componentType);
            assert (type != null);
            if (class_3902.field_51563.equals((Object)type.method_57875())) {
                return;
            }
            class_2522 reader = class_2522.method_68662((DynamicOps)class_2509.field_11560);
            try {
                element = (class_2520)reader.method_67313(this.value);
            }
            catch (CommandSyntaxException e) {
                throw new InvalidConfigurationException("Could not read value for component %s".formatted(this.componentType), e);
            }
            type.method_57876().parse((DynamicOps)class_2509.field_11560, (Object)element).getOrThrow(error -> new InvalidConfigurationException("Error parsing component: " + error));
        }

        public static ComponentChangeEntry getDefault() {
            return new ComponentChangeEntry(class_7923.field_49658.method_10221((Object)class_9334.field_49629), ChangeType.SET, "0");
        }
    }

    public static enum ChangeType {
        SET((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.change_type.set")),
        REMOVE((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.change_type.remove"));

        private final class_2561 text;

        private ChangeType(class_2561 text) {
            this.text = text;
        }

        public class_2561 getText() {
            return this.text;
        }
    }
}

