/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.representation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.EntityAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemComponents;
import org.jetbrains.annotations.Nullable;

public class MutableConfiguration
implements Configuration {
    public static final int CURRENT_VERSION = 3;
    private int configurationVersion;
    private List<ItemAttributes> itemAttributes;
    private List<ItemComponents> itemComponents;
    private List<EntityAttributes> entityAttributes;
    private Map<class_2960, Boolean> enabledSounds;
    private MiscOptions miscOptions;

    public MutableConfiguration(List<ItemAttributes> itemAttributes, List<EntityAttributes> entityAttributes, Map<class_2960, Boolean> enabledSounds, MiscOptions miscOptions) {
        this(itemAttributes, List.of(), entityAttributes, enabledSounds, miscOptions);
    }

    public MutableConfiguration(List<ItemAttributes> itemAttributes, List<ItemComponents> itemComponents, List<EntityAttributes> entityAttributes, Map<class_2960, Boolean> enabledSounds, MiscOptions miscOptions) {
        this.configurationVersion = 3;
        this.itemAttributes = itemAttributes != null ? new ArrayList<ItemAttributes>(itemAttributes) : new ArrayList();
        this.itemComponents = itemComponents != null ? new ArrayList<ItemComponents>(itemComponents) : new ArrayList();
        this.entityAttributes = entityAttributes != null ? new ArrayList<EntityAttributes>(entityAttributes) : new ArrayList();
        this.enabledSounds = enabledSounds != null ? new HashMap<class_2960, Boolean>(enabledSounds) : new HashMap();
        this.miscOptions = miscOptions;
    }

    public MutableConfiguration() {
    }

    public int getConfigurationVersion() {
        if (this.configurationVersion == 0) {
            this.configurationVersion = 1;
        }
        return this.configurationVersion;
    }

    @Override
    public List<ItemAttributes> getItemAttributes() {
        if (this.itemAttributes == null) {
            this.itemAttributes = new ArrayList<ItemAttributes>();
        }
        return this.itemAttributes;
    }

    @Override
    public List<ItemComponents> getItemComponents() {
        if (this.itemComponents == null) {
            this.itemComponents = new ArrayList<ItemComponents>();
        }
        return this.itemComponents;
    }

    @Override
    public List<EntityAttributes> getEntityAttributes() {
        if (this.entityAttributes == null) {
            this.entityAttributes = new ArrayList<EntityAttributes>();
        }
        return this.entityAttributes;
    }

    @Override
    public Optional<Boolean> isSoundEnabled(class_2960 soundIdentifier) {
        if (this.enabledSounds == null) {
            this.enabledSounds = new HashMap<class_2960, Boolean>();
        }
        return Optional.ofNullable(this.enabledSounds.get(soundIdentifier));
    }

    @Override
    public Map<class_2960, Boolean> getSoundMap() {
        if (this.enabledSounds == null) {
            this.enabledSounds = new HashMap<class_2960, Boolean>();
        }
        return this.enabledSounds;
    }

    @Override
    public MiscOptions getMiscOptions() {
        if (this.miscOptions == null) {
            this.miscOptions = new MiscOptions();
        }
        return this.miscOptions;
    }

    public void setSoundEnabled(class_2960 soundIdentifier, @Nullable Boolean enabled) {
        if (enabled == null) {
            this.enabledSounds.remove(soundIdentifier);
            return;
        }
        this.enabledSounds.put(soundIdentifier, enabled);
    }

    public MutableConfiguration copy() {
        return new MutableConfiguration(this.itemAttributes != null ? this.itemAttributes.stream().map(ItemAttributes::copy).toList() : null, this.itemComponents != null ? this.itemComponents.stream().map(ItemComponents::copy).toList() : null, this.entityAttributes != null ? this.entityAttributes.stream().map(EntityAttributes::copy).toList() : null, this.enabledSounds != null ? Map.copyOf(this.enabledSounds) : null, this.miscOptions != null ? this.miscOptions.copy() : null);
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        if (this.configurationVersion > 3) {
            throw new InvalidConfigurationException("Configuration claims to be of a higher version than the current one");
        }
        for (ItemAttributes itemAttributes : this.getItemAttributes()) {
            itemAttributes.validate();
        }
        for (ItemComponents itemComponents : this.getItemComponents()) {
            itemComponents.validate();
        }
        for (EntityAttributes entityAttributes : this.getEntityAttributes()) {
            entityAttributes.validate();
        }
    }

    private static JsonObject loadDefaultJson() throws IOException {
        try (InputStream in = MutableConfiguration.class.getResourceAsStream("/default_config.json");){
            if (in == null) {
                throw new IOException("Resource was not bundled correctly");
            }
            JsonObject jsonObject = (JsonObject)CombatEdit.GSON.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
            return jsonObject;
        }
    }

    public static MutableConfiguration loadDefault() {
        try {
            return (MutableConfiguration)CombatEdit.GSON.fromJson((JsonElement)MutableConfiguration.loadDefaultJson(), MutableConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load default settings file", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MutableConfiguration)) {
            return false;
        }
        MutableConfiguration that = (MutableConfiguration)o;
        return Objects.equals(this.getItemAttributes(), that.getItemAttributes()) && Objects.equals(this.getItemComponents(), that.getItemComponents()) && Objects.equals(this.getEntityAttributes(), that.getEntityAttributes()) && Objects.equals(this.enabledSounds, that.enabledSounds) && Objects.equals(this.getMiscOptions(), that.getMiscOptions());
    }

    public int hashCode() {
        return Objects.hash(this.getItemAttributes(), this.getItemComponents(), this.getEntityAttributes(), this.enabledSounds, this.getMiscOptions());
    }

    public static class MiscOptions
    implements Configuration.MiscOptions {
        @SerializedName(value="enable_1_8_knockback")
        private Boolean enable1_8Knockback;
        private Boolean disableSweepingWithoutEnchantment;

        public MiscOptions(Boolean enable1_8Knockback, Boolean disableSweepingWithoutEnchantment) {
            this.enable1_8Knockback = enable1_8Knockback;
            this.disableSweepingWithoutEnchantment = disableSweepingWithoutEnchantment;
        }

        protected MiscOptions() {
        }

        @Override
        public Optional<Boolean> is1_8KnockbackEnabled() {
            return Optional.ofNullable(this.enable1_8Knockback);
        }

        @Override
        public Optional<Boolean> isSweepingWithoutEnchantmentDisabled() {
            return Optional.ofNullable(this.disableSweepingWithoutEnchantment);
        }

        public void set1_8KnockbackEnabled(@Nullable Boolean enable1_8Knockback) {
            this.enable1_8Knockback = enable1_8Knockback;
        }

        public void setSweepingWithoutEnchantmentDisabled(@Nullable Boolean disableSweepingWithoutEnchantment) {
            this.disableSweepingWithoutEnchantment = disableSweepingWithoutEnchantment;
        }

        public MiscOptions copy() {
            return new MiscOptions(this.enable1_8Knockback, this.disableSweepingWithoutEnchantment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MiscOptions)) {
                return false;
            }
            MiscOptions that = (MiscOptions)o;
            return Objects.equals(this.enable1_8Knockback, that.enable1_8Knockback) && Objects.equals(this.disableSweepingWithoutEnchantment, that.disableSweepingWithoutEnchantment);
        }

        public int hashCode() {
            return Objects.hash(this.enable1_8Knockback, this.disableSweepingWithoutEnchantment);
        }
    }
}

