/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.modification;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5135;
import net.minecraft.class_5575;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import net.rizecookey.combatedit.api.extension.DefaultsSupplier;
import net.rizecookey.combatedit.configuration.provider.ConfigurationManager;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.extension.DynamicComponentMap;
import net.rizecookey.combatedit.extension.DynamicDefaultAttributeContainer;
import net.rizecookey.combatedit.modification.entity.EntityModificationMap;
import net.rizecookey.combatedit.modification.entity.EntityModificationProvider;
import net.rizecookey.combatedit.modification.item.ItemModificationMap;
import net.rizecookey.combatedit.modification.item.ItemModificationProvider;

public class PropertyModifier
implements DefaultsSupplier {
    private final ConfigurationManager configurationProvider;
    private final Items items;
    private final Entities entities;

    public PropertyModifier(ConfigurationManager configurationProvider) {
        this.configurationProvider = configurationProvider;
        this.items = new Items();
        this.entities = new Entities();
    }

    public void makeModifications() {
        this.reloadModificationProviders();
        this.items.modify();
        this.entities.modify();
        this.updateAttributesToClients();
    }

    public void reloadModificationProviders() {
        this.entities.reloadModificationProvider();
        this.items.reloadModificationProvider();
    }

    private void updateEntitiesAttributeContainers(class_1299<? extends class_1309> type, class_5132 previousDefaults) {
        MinecraftServer server = this.configurationProvider.getCurrentServer();
        if (server == null) {
            return;
        }
        server.method_3738().forEach(world -> world.method_18198(class_5575.method_31795(class_1309.class), entity -> entity.method_5864().equals(type)).forEach(entity -> entity.method_6127().combatEdit$patchWithNewDefaults(type, previousDefaults)));
    }

    private void updateAttributesToClients() {
        MinecraftServer currentServer = this.configurationProvider.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        for (class_3222 player : currentServer.method_3760().method_14571()) {
            player.field_7512.method_37420();
        }
    }

    @Override
    public Items items() {
        return this.items;
    }

    @Override
    public Entities entities() {
        return this.entities;
    }

    public class Items
    implements DefaultsSupplier.Items {
        private ItemModificationProvider modificationProvider = new ItemModificationMap(Map.of(), Map.of());

        public ItemModificationProvider modificationProvider() {
            return this.modificationProvider;
        }

        @Override
        public class_9323 getVanillaComponents(class_1792 item) {
            class_9323 components = item.method_57347();
            if (!(components instanceof DynamicComponentMap)) {
                return components;
            }
            DynamicComponentMap dynamicComponentMap = (DynamicComponentMap)components;
            return dynamicComponentMap.getOriginal();
        }

        @Override
        public class_9285 getVanillaAttributeModifiers(class_1792 item) {
            class_9323 components = this.getVanillaComponents(item);
            return Objects.requireNonNullElse((class_9285)components.method_58694(class_9334.field_49636), class_9285.field_49326);
        }

        private void reloadModificationProvider() {
            Configuration configuration = PropertyModifier.this.configurationProvider.getConfiguration();
            this.modificationProvider = ItemModificationMap.fromConfiguration(configuration.getItemAttributes(), configuration.getItemComponents(), PropertyModifier.this.items);
        }

        private void modify() {
            ArrayList<class_1792> incompatibles = null;
            for (class_1792 item : class_7923.field_41178) {
                class_2960 id = class_7923.field_41178.method_10221((Object)item);
                class_9323 components = item.method_57347();
                if (!(components instanceof DynamicComponentMap)) {
                    if (!this.modificationProvider.shouldModifyAttributes(id, item) && !this.modificationProvider.shouldModifyDefaultComponents(id, item)) continue;
                    if (incompatibles == null) {
                        incompatibles = new ArrayList<class_1792>();
                    }
                    incompatibles.add(item);
                    continue;
                }
                DynamicComponentMap dynamicComponents = (DynamicComponentMap)components;
                class_9323.class_9324 builder = class_9323.method_57827().combatEdit$preventDynamicWrap();
                this.modificationProvider.getComponents(id, item, dynamicComponents.getOriginal()).forEach(component -> builder.method_57840(component.comp_2443(), component.comp_2444()));
                if (this.modificationProvider.shouldModifyAttributes(id, item)) {
                    class_9285 modifiers = this.modificationProvider.getAttributeModifiers(id, item, (class_9285)dynamicComponents.getOriginal().method_58694(class_9334.field_49636));
                    builder.method_57840(class_9334.field_49636, (Object)modifiers);
                }
                dynamicComponents.setExchangeable(builder.method_57838());
            }
            if (incompatibles != null) {
                PropertyModifier.this.configurationProvider.getCombatEdit().warnAboutItemIncompatibility(incompatibles);
            }
        }
    }

    public class Entities
    implements DefaultsSupplier.Entities {
        private EntityModificationProvider modificationProvider = new EntityModificationMap(Map.of());

        public EntityModificationProvider modificationProvider() {
            return this.modificationProvider;
        }

        @Override
        public class_5132 getVanillaDefaultAttributes(class_1299<? extends class_1309> entityType) {
            class_5132 defaultAttributes = class_5135.method_26873(entityType);
            if (!(defaultAttributes instanceof DynamicDefaultAttributeContainer)) {
                return defaultAttributes;
            }
            DynamicDefaultAttributeContainer dynamicDefaults = (DynamicDefaultAttributeContainer)defaultAttributes;
            return dynamicDefaults.getOriginal();
        }

        private void reloadModificationProvider() {
            Configuration configuration = PropertyModifier.this.configurationProvider.getConfiguration();
            this.modificationProvider = EntityModificationMap.fromConfiguration(configuration.getEntityAttributes(), PropertyModifier.this.entities);
        }

        private void modify() {
            ArrayList<class_1299> incompatibles = null;
            for (class_1299 type : class_5135.field_23730.keySet()) {
                class_2960 id = class_7923.field_41177.method_10221((Object)type);
                class_5132 defaults = class_5135.method_26873((class_1299)type);
                if (!(defaults instanceof DynamicDefaultAttributeContainer)) {
                    if (!this.modificationProvider.shouldModifyEntity(id, (class_1299<? extends class_1309>)type)) continue;
                    if (incompatibles == null) {
                        incompatibles = new ArrayList<class_1299>();
                    }
                    incompatibles.add(type);
                    continue;
                }
                DynamicDefaultAttributeContainer entry = (DynamicDefaultAttributeContainer)defaults;
                DynamicDefaultAttributeContainer entryExt = entry;
                class_5132 previousDefaults = entry.getExchangeable();
                if (!this.modificationProvider.shouldModifyEntity(id, (class_1299<? extends class_1309>)type)) {
                    entry.setExchangeable(entry.getOriginal());
                } else {
                    entryExt.combatEdit$setSendAllAttributes(true);
                    entry.setExchangeable(this.modificationProvider.getModifiers(id, (class_1299<? extends class_1309>)type, entry.getOriginal()));
                }
                PropertyModifier.this.updateEntitiesAttributeContainers((class_1299<? extends class_1309>)type, previousDefaults);
            }
            if (incompatibles != null) {
                PropertyModifier.this.configurationProvider.getCombatEdit().warnAboutEntityIncompatibility(incompatibles);
            }
        }
    }
}

