/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.modification.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.api.extension.DefaultsSupplier;
import net.rizecookey.combatedit.configuration.representation.EntityAttributes;
import net.rizecookey.combatedit.modification.entity.EntityModificationProvider;

public class EntityModificationMap
implements EntityModificationProvider {
    private final Map<class_1299<? extends class_1309>, class_5132> attributeMap;

    public EntityModificationMap(Map<class_1299<? extends class_1309>, class_5132> entries) {
        this.attributeMap = Map.copyOf(entries);
    }

    @Override
    public boolean shouldModifyEntity(class_2960 id, class_1299<? extends class_1309> type) {
        return this.attributeMap.containsKey(type);
    }

    @Override
    public class_5132 getModifiers(class_2960 id, class_1299<? extends class_1309> type, class_5132 originalDefaults) {
        return this.attributeMap.get(type);
    }

    public static EntityModificationMap fromConfiguration(List<EntityAttributes> entityAttributes, DefaultsSupplier.Entities entityDefaultsSupplier) {
        HashMap<class_1299<? extends class_1309>, class_5132> map = new HashMap<class_1299<? extends class_1309>, class_5132>();
        Function<class_1299<? extends class_1309>, class_5132> defaultProvider = type -> {
            if (map.containsKey(type)) {
                return (class_5132)map.get(type);
            }
            return entityDefaultsSupplier.getVanillaDefaultAttributes((class_1299<? extends class_1309>)type);
        };
        for (EntityAttributes entityAttribute : entityAttributes) {
            Map.Entry<class_1299<? extends class_1309>, class_5132> result = EntityModificationMap.fromConfigurationEntry(entityAttribute, defaultProvider);
            if (result == null) continue;
            map.put(result.getKey(), result.getValue());
        }
        return new EntityModificationMap(map);
    }

    private static Map.Entry<class_1299<? extends class_1309>, class_5132> fromConfigurationEntry(EntityAttributes modifier, Function<class_1299<? extends class_1309>, class_5132> originalDefaults) {
        class_1299 type;
        if (!class_7923.field_41177.method_10250(modifier.getEntityId())) {
            CombatEdit.LOGGER.warn("No entity with id {} found, skipping entry", (Object)modifier.getEntityId());
            return null;
        }
        try {
            type = (class_1299)class_7923.field_41177.method_63535(modifier.getEntityId());
        }
        catch (ClassCastException e) {
            CombatEdit.LOGGER.warn("{} is not a living entity and thus does not have attributes, skipping entry", (Object)modifier.getEntityId());
            return null;
        }
        class_5132.class_5133 builder = class_5132.method_26861();
        if (!modifier.isOverrideDefault()) {
            class_5132 defaults = originalDefaults.apply((class_1299<? extends class_1309>)type);
            if (defaults == null) {
                defaults = class_5132.method_26861().method_26866();
            }
            defaults.combatEdit$getInstances().values().forEach(instance -> builder.method_26868(instance.method_6198(), instance.method_6201()));
        }
        for (EntityAttributes.AttributeBaseValue attributeValue : modifier.getBaseValues()) {
            if (!class_7923.field_41190.method_10250(attributeValue.attribute())) {
                CombatEdit.LOGGER.warn("No attribute with id {} found, skipping entry for {}", (Object)attributeValue.attribute(), (Object)modifier.getEntityId());
                continue;
            }
            class_6880.class_6883 attribute = (class_6880.class_6883)class_7923.field_41190.method_10223(attributeValue.attribute()).orElseThrow();
            builder.method_26868((class_6880)attribute, attributeValue.baseValue());
        }
        return Map.entry(type, builder.method_26866());
    }
}

