/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.utils.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;
import net.rizecookey.combatedit.utils.ConfigMigration;

public class MutableConfigurationTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (type.getRawType() == MutableConfiguration.class) {
            return this.createForMutableConfig(gson, (TypeToken<MutableConfiguration>)TypeToken.get(MutableConfiguration.class));
        }
        return gson.getDelegateAdapter((TypeAdapterFactory)this, type);
    }

    public TypeAdapter<MutableConfiguration> createForMutableConfig(final Gson gson, TypeToken<MutableConfiguration> type) {
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<MutableConfiguration>(this){

            public void write(JsonWriter out, MutableConfiguration value) throws IOException {
                delegate.write(out, (Object)value);
            }

            public MutableConfiguration read(JsonReader in) throws IOException {
                JsonObject object;
                try {
                    object = (JsonObject)gson.fromJson(in, JsonObject.class);
                }
                catch (JsonIOException e) {
                    throw new IOException(e);
                }
                JsonElement configurationVersion = object.get("configuration_version");
                if (configurationVersion != null && configurationVersion.isJsonPrimitive() && configurationVersion.getAsInt() < 3) {
                    object = ConfigMigration.migrateToNewerVersion(object, configurationVersion.getAsInt());
                }
                return (MutableConfiguration)delegate.fromJsonTree((JsonElement)object);
            }
        }.nullSafe();
    }
}

