/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.client;

import java.io.IOException;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.client.configscreen.InvalidConfigScreen;
import net.rizecookey.combatedit.client.event.ClientEvents;
import net.rizecookey.combatedit.configuration.Settings;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;

@Environment(value=EnvType.CLIENT)
public class CombatEditClient
extends CombatEdit {
    private static CombatEditClient INSTANCE;

    public CombatEditClient() {
        INSTANCE = this;
    }

    @Override
    protected void onSettingsLoadError(InvalidConfigurationException exception) {
        LOGGER.error("Settings validation failed", (Throwable)exception);
        this.setCurrentSettings(null);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> client.combatEdit$addInitScreen(onClose -> new InvalidConfigScreen(exception, (Runnable)onClose)));
    }

    @Override
    protected void onSettingsLoadError(IOException exception) {
        LOGGER.error("Failed to load the settings file", (Throwable)exception);
        LOGGER.warn("Using default settings.");
        this.setCurrentSettings(Settings.loadDefault());
        ClientEvents.CLIENT_FINISHED_LOADING.register(client -> CombatEditClient.sendErrorNotification(client, "settings_load_error"));
    }

    @Override
    public void warnAboutItemIncompatibility(List<class_1792> items) {
        super.warnAboutItemIncompatibility(items);
        CombatEditClient.sendErrorNotification(class_310.method_1551(), "incompatibility_item");
    }

    @Override
    public void warnAboutEntityIncompatibility(List<class_1299<? extends class_1309>> entities) {
        super.warnAboutEntityIncompatibility(entities);
        CombatEditClient.sendErrorNotification(class_310.method_1551(), "incompatibility_entity");
    }

    public static void sendErrorNotification(class_310 client, String errorKey) {
        class_370 toast = class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47585, (class_2561)class_2561.method_43471((String)"notification.combatedit.%s.title".formatted(errorKey)), (class_2561)class_2561.method_43471((String)"notification.combatedit.%s.description".formatted(errorKey)));
        client.method_1566().method_1999((class_368)toast);
    }

    public static CombatEditClient getInstance() {
        return INSTANCE;
    }
}

