/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.client.configscreen;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextFieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2477;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3902;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.rizecookey.clothconfig2.extension.api.ExtendedConfigEntryBuilder;
import net.rizecookey.clothconfig2.extension.gui.entries.ObjectAdapter;
import net.rizecookey.clothconfig2.extension.gui.entries.ObjectListEntry;
import net.rizecookey.clothconfig2.extension.gui.entries.ObjectListListEntry;
import net.rizecookey.clothconfig2.extension.impl.builders.ExtendedDropdownMenus;
import net.rizecookey.clothconfig2.extension.impl.builders.ObjectListBuilder;
import net.rizecookey.combatedit.client.CombatEditClient;
import net.rizecookey.combatedit.client.configscreen.TriStateOption;
import net.rizecookey.combatedit.configuration.BaseProfile;
import net.rizecookey.combatedit.configuration.Settings;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.EntityAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemComponents;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;

@Environment(value=EnvType.CLIENT)
public class ConfigurationScreenBuilder {
    private static final ExtendedConfigEntryBuilder ENTRY_BUILDER = ExtendedConfigEntryBuilder.create();

    public static class_437 buildScreen(CombatEditClient combatEditClient, class_437 parentScreen) {
        class_310 client = class_310.method_1551();
        Settings settings = combatEditClient.getCurrentSettings().copy();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parentScreen).setTitle((class_2561)class_2561.method_43471((String)"title.combatedit.config")).setSavingRunnable(() -> {
            try {
                combatEditClient.saveSettings(settings);
            }
            catch (IOException e) {
                CombatEditClient.LOGGER.error("Failed to save the settings file", (Throwable)e);
                CombatEditClient.sendErrorNotification(client, "settings_save_error");
                return;
            }
            if (client.method_1562() != null && client.method_1562().method_48296().method_10756()) {
                class_1132 server = class_310.method_1551().method_1576();
                assert (server != null);
                server.method_29439(server.method_3836().method_29210());
            }
        });
        MutableConfiguration config = settings.getConfigurationOverrides();
        ConfigurationScreenBuilder.createProfileCategory(settings, builder);
        ConfigurationScreenBuilder.createClientCategory(settings.getClientOnly(), builder);
        ConfigurationScreenBuilder.createEntityCategory(config.getEntityAttributes(), builder);
        ConfigurationScreenBuilder.createItemCategory(config.getItemAttributes(), config.getItemComponents(), builder);
        ConfigurationScreenBuilder.createSoundCategory(config, builder);
        ConfigurationScreenBuilder.createMiscCategory(config.getMiscOptions(), builder);
        return builder.build();
    }

    private static void addLocalWarning(ConfigCategory category) {
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null || client.method_1562().method_48296().method_10756()) {
            return;
        }
        category.addEntry((AbstractConfigListEntry)ENTRY_BUILDER.startTextDescription((class_2561)class_2561.method_43471((String)"option.combatedit.warn.local_only").method_27694(style -> style.method_10977(class_124.field_1061))).build());
    }

    private static void addIngameWarning(ConfigCategory category) {
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null || !client.method_1562().method_48296().method_10756()) {
            return;
        }
        category.addEntry((AbstractConfigListEntry)ENTRY_BUILDER.startTextDescription((class_2561)class_2561.method_43471((String)"option.combatedit.warn.ingame").method_27694(style -> style.method_10977(class_124.field_1061))).build());
    }

    private static void createProfileCategory(Settings settings, ConfigBuilder builder) {
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.combatedit.profile"));
        ConfigurationScreenBuilder.addLocalWarning(category);
        ConfigurationScreenBuilder.addIngameWarning(category);
        ArrayList<BaseProfile.Info> baseProfiles = new ArrayList<BaseProfile.Info>(Arrays.stream(BaseProfile.IntegratedProfiles.values()).map(BaseProfile.IntegratedProfiles::getInfo).toList());
        BaseProfile.Info customProfile = new BaseProfile.Info(null, (class_2561)class_2561.method_43471((String)"option.combatedit.profile.base_profile.custom.name"), (class_2561)class_2561.method_43471((String)"option.combatedit.profile.base_profile.custom.description"));
        baseProfiles.add(customProfile);
        BaseProfile.Info currentSelected = baseProfiles.stream().filter(data -> settings.getSelectedBaseProfile().equals((Object)data.id())).findFirst().orElse(customProfile);
        SelectionListEntry profileSelector = ENTRY_BUILDER.startSelector((class_2561)class_2561.method_43471((String)"option.combatedit.profile.base_profile"), baseProfiles.toArray(new BaseProfile.Info[0]), currentSelected).setNameProvider(BaseProfile.Info::name).setTooltipSupplier(info -> Optional.of(new class_2561[]{info.description()})).setSaveConsumer(value -> {
            if (value.id() != null) {
                settings.setSelectedBaseProfile(value.id());
            }
        }).build();
        category.addEntry((AbstractConfigListEntry)profileSelector);
        category.addEntry((AbstractConfigListEntry)((TextFieldBuilder)ENTRY_BUILDER.startTextField((class_2561)class_2561.method_43471((String)"option.combatedit.profile.custom_base_profile"), settings.getSelectedBaseProfile().toString()).setDisplayRequirement(() -> ((BaseProfile.Info)profileSelector.getValue()).id() == null)).setSaveConsumer(value -> {
            if (((BaseProfile.Info)profileSelector.getValue()).id() == null) {
                settings.setSelectedBaseProfile(class_2960.method_60654((String)value));
            }
        }).setErrorSupplier(value -> {
            try {
                class_2960.method_60654((String)value);
            }
            catch (class_151 e) {
                return Optional.of(class_2561.method_43471((String)"error.combatedit.invalid_identifier"));
            }
            return Optional.empty();
        }).build());
        category.addEntry((AbstractConfigListEntry)((TextDescriptionBuilder)ENTRY_BUILDER.startTextDescription((class_2561)class_2561.method_43471((String)"option.combatedit.profile.custom_base_profile.notice").method_27694(style -> style.method_10977(class_124.field_1061))).setDisplayRequirement(() -> ((BaseProfile.Info)profileSelector.getValue()).id() == null)).build());
    }

    private static void createClientCategory(Settings.ClientOnly clientOnly, ConfigBuilder builder) {
        builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.combatedit.client_only")).addEntry((AbstractConfigListEntry)ENTRY_BUILDER.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.combatedit.client_only.disable_new_tooltips"), clientOnly.shouldDisableNewTooltips()).setSaveConsumer(clientOnly::setDisableNewTooltips).build());
    }

    private static void createEntityCategory(List<EntityAttributes> entityAttributes, ConfigBuilder builder) {
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.combatedit.entity"));
        ConfigurationScreenBuilder.addLocalWarning(category);
        ConfigurationScreenBuilder.addIngameWarning(category);
        category.addEntry(((ObjectListBuilder)((ObjectListBuilder)ENTRY_BUILDER.startObjectList((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entity_attributes"), entityAttributes, (value, list) -> ConfigurationScreenBuilder.createEntry(value != null ? value : EntityAttributes.getDefault(), list.getValue().size())).setSaveConsumer(value -> {
            entityAttributes.clear();
            entityAttributes.addAll((Collection<EntityAttributes>)value);
        })).setExpanded(true)).build());
    }

    private static void createItemCategory(List<ItemAttributes> itemAttributes, List<ItemComponents> itemComponents, ConfigBuilder builder) {
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.combatedit.item"));
        ConfigurationScreenBuilder.addLocalWarning(category);
        ConfigurationScreenBuilder.addIngameWarning(category);
        category.addEntry(((ObjectListBuilder)((ObjectListBuilder)ENTRY_BUILDER.startObjectList((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes"), itemAttributes, (value, list) -> ConfigurationScreenBuilder.createEntry(value != null ? value : ItemAttributes.getDefault(), list.getValue().size())).setSaveConsumer(value -> {
            itemAttributes.clear();
            itemAttributes.addAll((Collection<ItemAttributes>)value);
        })).setExpanded(true)).build());
        category.addEntry(((ObjectListBuilder)((ObjectListBuilder)ENTRY_BUILDER.startObjectList((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components"), itemComponents, (value, list) -> ConfigurationScreenBuilder.createEntry(value != null ? value : ItemComponents.getDefault(), list.getValue().size())).setSaveConsumer(value -> {
            itemComponents.clear();
            itemComponents.addAll((Collection<ItemComponents>)value);
        })).setExpanded(true)).build());
    }

    private static EnumListEntry<?> optionalBooleanEntry(class_2561 fieldName, Boolean initialValue, Consumer<Boolean> saveConsumer) {
        return ENTRY_BUILDER.startEnumSelector(fieldName, TriStateOption.class, TriStateOption.fromBoolean(initialValue)).setSaveConsumer(value -> saveConsumer.accept(value.asBoolean())).setEnumNameProvider(anEnum -> ((TriStateOption)((Object)anEnum)).getText()).build();
    }

    private static void createSoundCategory(MutableConfiguration configuration, ConfigBuilder builder) {
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.combatedit.sounds"));
        ConfigurationScreenBuilder.addLocalWarning(category);
        for (class_3414 sound : Configuration.CONFIGURABLE_SOUNDS) {
            String translationKey = ConfigurationScreenBuilder.determineSoundTranslationKey(sound);
            category.addEntry(ConfigurationScreenBuilder.optionalBooleanEntry((class_2561)class_2561.method_43471((String)translationKey), configuration.isSoundEnabled(sound.comp_3319()).orElse(null), value -> configuration.setSoundEnabled(sound.comp_3319(), (Boolean)value)));
        }
    }

    private static void createMiscCategory(MutableConfiguration.MiscOptions miscOptions, ConfigBuilder builder) {
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.combatedit.misc"));
        ConfigurationScreenBuilder.addLocalWarning(category);
        category.addEntry(ConfigurationScreenBuilder.optionalBooleanEntry((class_2561)class_2561.method_43471((String)"option.combatedit.misc.enable_1_8_knockback"), miscOptions.is1_8KnockbackEnabled().orElse(null), miscOptions::set1_8KnockbackEnabled));
        category.addEntry(ConfigurationScreenBuilder.optionalBooleanEntry((class_2561)class_2561.method_43471((String)"option.combatedit.misc.disable_sweeping_without_enchantment"), miscOptions.isSweepingWithoutEnchantmentDisabled().orElse(null), miscOptions::setSweepingWithoutEnchantmentDisabled));
    }

    private static String determineSoundTranslationKey(class_3414 sound) {
        String key;
        class_2477 language = class_2477.method_10517();
        if (language.method_4678(key = "subtitles." + sound.comp_3319().method_12832())) {
            return key;
        }
        return "combatedit.sound." + sound.comp_3319().method_12832();
    }

    private static ObjectListEntry<EntityAttributes> createEntry(EntityAttributes attributes, int entryIndex) {
        EntityAttributes copy = attributes.copy();
        DropdownBoxEntry entityTypeEntry = ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entity_attributes.entity"), ExtendedDropdownMenus.TopCellElementBuilder.ofRegistryIdentifier(class_7923.field_41177, (class_1299)class_7923.field_41177.method_63535(attributes.getEntityId())), ExtendedDropdownMenus.CellCreatorBuilder.ofRegistryIdentifier(class_7923.field_41177)).setSelections((Iterable)class_7923.field_41177.method_10235()).build();
        ObjectListListEntry attributeValueMap = ((ObjectListBuilder)((ObjectListBuilder)ENTRY_BUILDER.startObjectList((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entity_attributes.attribute_entry"), List.copyOf(attributes.getBaseValues()), (value, list) -> ConfigurationScreenBuilder.createEntry(value != null ? value : EntityAttributes.AttributeBaseValue.getDefault())).setSaveConsumer(values -> {
            attributes.getBaseValues().clear();
            attributes.getBaseValues().addAll((Collection<EntityAttributes.AttributeBaseValue>)values);
        })).setExpanded(true)).build();
        return ENTRY_BUILDER.startObjectField((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entry"), List.of(entityTypeEntry, attributeValueMap), ObjectAdapter.create(() -> {
            copy.setEntityId((class_2960)entityTypeEntry.getValue());
            copy.getBaseValues().clear();
            copy.getBaseValues().addAll(attributeValueMap.getValue());
            return copy;
        }, () -> Optional.of(EntityAttributes.getDefault()))).setExpanded(entryIndex < 5).build();
    }

    private static ObjectListEntry<EntityAttributes.AttributeBaseValue> createEntry(EntityAttributes.AttributeBaseValue baseValue) {
        DropdownBoxEntry attributeEntry = ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entity_attributes.attribute_entry.attribute"), ExtendedDropdownMenus.TopCellElementBuilder.ofRegistryIdentifier(class_7923.field_41190, (class_1320)class_7923.field_41190.method_63535(baseValue.attribute())), ExtendedDropdownMenus.CellCreatorBuilder.ofRegistryIdentifier(class_7923.field_41190)).setSelections((Iterable)class_7923.field_41190.method_10235()).build();
        DoubleListEntry baseValueEntry = ENTRY_BUILDER.startDoubleField((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entity_attributes.attribute_entry.base_value"), baseValue.baseValue()).build();
        return ENTRY_BUILDER.startObjectField((class_2561)class_2561.method_43471((String)"option.combatedit.entity.entity_attributes.attribute_entry.entry"), List.of(attributeEntry, baseValueEntry), ObjectAdapter.create(() -> new EntityAttributes.AttributeBaseValue((class_2960)attributeEntry.getValue(), baseValueEntry.getValue()), () -> Optional.of(EntityAttributes.AttributeBaseValue.getDefault()))).setExpanded(true).build();
    }

    private static DropdownBoxEntry<class_2960> createItemEntry(class_2960 currentItemId) {
        return ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.item"), DropdownMenuBuilder.TopCellElementBuilder.ofItemIdentifier((class_1792)((class_1792)class_7923.field_41178.method_63535(currentItemId))), ExtendedDropdownMenus.CellCreatorBuilder.ofRegistryIdentifier(class_7923.field_41178)).setSelections((Iterable)class_7923.field_41178.method_10235()).build();
    }

    private static ObjectListEntry<ItemAttributes> createEntry(ItemAttributes attributes, int entryIndex) {
        ItemAttributes copy = new ItemAttributes(attributes.getItemId(), List.copyOf(attributes.getModifiers()), attributes.isOverrideDefault());
        DropdownBoxEntry<class_2960> itemEntry = ConfigurationScreenBuilder.createItemEntry(attributes.getItemId());
        ObjectListListEntry modifiersEntry = ((ObjectListBuilder)((ObjectListBuilder)ENTRY_BUILDER.startObjectList((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry"), List.copyOf(attributes.getModifiers()), (value, list) -> ConfigurationScreenBuilder.createEntry(value != null ? value : ItemAttributes.ModifierEntry.getDefault())).setSaveConsumer(value -> {
            attributes.getModifiers().clear();
            attributes.getModifiers().addAll((Collection<ItemAttributes.ModifierEntry>)value);
        })).setExpanded(true)).build();
        BooleanListEntry overrideDefaultToggle = ENTRY_BUILDER.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.override_defaults"), attributes.isOverrideDefault()).setSaveConsumer(attributes::setOverrideDefault).build();
        return ENTRY_BUILDER.startObjectField((class_2561)class_2561.method_43471((String)"option.combatedit.item.entry"), List.of(itemEntry, modifiersEntry, overrideDefaultToggle), ObjectAdapter.create(() -> {
            copy.setItemId((class_2960)itemEntry.getValue());
            copy.getModifiers().clear();
            copy.getModifiers().addAll(modifiersEntry.getValue());
            copy.setOverrideDefault(overrideDefaultToggle.getValue());
            return copy;
        }, () -> Optional.of(ItemAttributes.getDefault()))).setExpanded(entryIndex < 5).build();
    }

    private static ObjectListEntry<ItemAttributes.ModifierEntry> createEntry(ItemAttributes.ModifierEntry modifierEntry) {
        DropdownBoxEntry attributeEntry = ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.attribute"), ExtendedDropdownMenus.TopCellElementBuilder.ofRegistryIdentifier(class_7923.field_41190, (class_1320)class_7923.field_41190.method_63535(modifierEntry.attribute())), ExtendedDropdownMenus.CellCreatorBuilder.ofRegistryIdentifier(class_7923.field_41190)).setSelections((Iterable)class_7923.field_41190.method_10235()).build();
        StringListEntry modifierIdEntry = ENTRY_BUILDER.startStrField((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.modifier_id"), modifierEntry.modifierId() != null ? modifierEntry.modifierId().toString() : "").setErrorSupplier(ConfigurationScreenBuilder.attributeModifierIdErrorSupplier()).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.modifier_id.tooltip")}).build();
        DoubleListEntry valueEntry = ENTRY_BUILDER.startDoubleField((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.value"), modifierEntry.value()).build();
        DropdownBoxEntry operationEntry = ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.operation"), ExtendedDropdownMenus.TopCellElementBuilder.ofStringIdentifiable(class_1322.class_1323.class, modifierEntry.operation()), ExtendedDropdownMenus.CellCreatorBuilder.ofStringIdentifiableAutoWidth(class_1322.class_1323.class)).setSelections(List.of(class_1322.class_1323.values())).build();
        DropdownBoxEntry slotEntry = ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.slot"), ExtendedDropdownMenus.TopCellElementBuilder.ofStringIdentifiable(class_9274.class, modifierEntry.slot()), ExtendedDropdownMenus.CellCreatorBuilder.ofStringIdentifiableAutoWidth(class_9274.class)).setSelections(List.of(class_9274.values())).build();
        return ENTRY_BUILDER.startObjectField((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_attributes.modifier_entry.entry"), List.of(attributeEntry, modifierIdEntry, valueEntry, operationEntry, slotEntry), ObjectAdapter.create(() -> new ItemAttributes.ModifierEntry((class_2960)attributeEntry.getValue(), !modifierIdEntry.getValue().isEmpty() ? class_2960.method_60654((String)modifierIdEntry.getValue()) : null, valueEntry.getValue(), (class_1322.class_1323)operationEntry.getValue(), (class_9274)slotEntry.getValue()), () -> Optional.of(ItemAttributes.ModifierEntry.getDefault()))).setExpanded(true).build();
    }

    private static ObjectListEntry<ItemComponents> createEntry(ItemComponents components, int entryIndex) {
        ItemComponents copy = new ItemComponents(components.getItemId(), List.copyOf(components.getChanges()));
        DropdownBoxEntry<class_2960> itemEntry = ConfigurationScreenBuilder.createItemEntry(components.getItemId());
        ObjectListListEntry componentsEntry = ((ObjectListBuilder)((ObjectListBuilder)ENTRY_BUILDER.startObjectList((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry"), List.copyOf(components.getChanges()), (value, list) -> ConfigurationScreenBuilder.createEntry(value != null ? value : ItemComponents.ComponentChangeEntry.getDefault())).setSaveConsumer(value -> {
            components.getChanges().clear();
            components.getChanges().addAll((Collection<ItemComponents.ComponentChangeEntry>)value);
        })).setExpanded(true)).build();
        return ENTRY_BUILDER.startObjectField((class_2561)class_2561.method_43471((String)"option.combatedit.item.entry"), List.of(itemEntry, componentsEntry), ObjectAdapter.create(() -> {
            copy.setItemId((class_2960)itemEntry.getValue());
            copy.getChanges().clear();
            copy.getChanges().addAll(componentsEntry.getValue());
            return copy;
        }, () -> Optional.of(ItemComponents.getDefault()))).setExpanded(entryIndex < 5).build();
    }

    private static ObjectListEntry<ItemComponents.ComponentChangeEntry> createEntry(ItemComponents.ComponentChangeEntry componentChangeEntry) {
        DropdownBoxEntry componentTypeEntry = ENTRY_BUILDER.startDropdownMenu((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.component"), ExtendedDropdownMenus.TopCellElementBuilder.ofRegistryIdentifier(class_7923.field_49658, (class_9331)class_7923.field_49658.method_63535(componentChangeEntry.componentType())), ExtendedDropdownMenus.CellCreatorBuilder.ofRegistryIdentifier(class_7923.field_49658)).setSelections((Iterable)class_7923.field_49658.method_10235()).setErrorSupplier(ident -> {
            if (!class_9334.field_49636.equals(class_7923.field_49658.method_63535(ident))) {
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.component.attribute_modifiers_unsupported"));
        }).build();
        EnumListEntry changeTypeEntry = ENTRY_BUILDER.startEnumSelector((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.change_type"), ItemComponents.ChangeType.class, componentChangeEntry.changeType()).setEnumNameProvider(anEnum -> ((ItemComponents.ChangeType)((Object)anEnum)).getText()).build();
        StringListEntry valueEntry = ENTRY_BUILDER.startStrField((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.value"), componentChangeEntry.value()).setTooltipSupplier(ConfigurationScreenBuilder.componentValueTooltipSupplier((DropdownBoxEntry<class_2960>)componentTypeEntry, (EnumListEntry<ItemComponents.ChangeType>)changeTypeEntry)).setErrorSupplier(ConfigurationScreenBuilder.componentValueErrorSupplier((DropdownBoxEntry<class_2960>)componentTypeEntry, (EnumListEntry<ItemComponents.ChangeType>)changeTypeEntry)).build();
        return ENTRY_BUILDER.startObjectField((class_2561)class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.entry"), List.of(componentTypeEntry, changeTypeEntry, valueEntry), ObjectAdapter.create(() -> new ItemComponents.ComponentChangeEntry((class_2960)componentTypeEntry.getValue(), (ItemComponents.ChangeType)((Object)((Object)changeTypeEntry.getValue())), valueEntry.getValue()), () -> Optional.of(ItemComponents.ComponentChangeEntry.getDefault()))).setExpanded(true).build();
    }

    private static Function<String, Optional<class_2561>> attributeModifierIdErrorSupplier() {
        return value -> {
            class_2960 id;
            if (value.isEmpty()) {
                return Optional.empty();
            }
            try {
                id = class_2960.method_60654((String)value);
            }
            catch (class_151 e) {
                return Optional.of(class_2561.method_43471((String)"error.combatedit.invalid_identifier"));
            }
            if (id.method_12836().equals("combatedit.special")) {
                return Optional.of(class_2561.method_43471((String)"error.combatedit.disallowed_namespace"));
            }
            return Optional.empty();
        };
    }

    private static Supplier<Optional<class_2561[]>> componentValueTooltipSupplier(DropdownBoxEntry<class_2960> componentTypeEntry, EnumListEntry<ItemComponents.ChangeType> changeTypeEntry) {
        return () -> {
            if (((ItemComponents.ChangeType)((Object)((Object)changeTypeEntry.getValue()))).equals((Object)ItemComponents.ChangeType.REMOVE)) {
                return Optional.of(new class_2561[]{class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.value.remove_tooltip")});
            }
            class_9331 componentType = (class_9331)class_7923.field_49658.method_63535((class_2960)componentTypeEntry.getValue());
            if (componentType == null) {
                return Optional.empty();
            }
            if (class_3902.field_51563.equals((Object)componentType.method_57875())) {
                return Optional.of(new class_2561[]{class_2561.method_43471((String)"option.combatedit.item.item_components.component_change_entry.value.unit_tooltip")});
            }
            return Optional.empty();
        };
    }

    private static Function<String, Optional<class_2561>> componentValueErrorSupplier(DropdownBoxEntry<class_2960> componentTypeEntry, EnumListEntry<ItemComponents.ChangeType> changeTypeEntry) {
        return val -> {
            class_2520 element;
            if (((ItemComponents.ChangeType)((Object)((Object)changeTypeEntry.getValue()))).equals((Object)ItemComponents.ChangeType.REMOVE)) {
                return Optional.empty();
            }
            class_9331 type = (class_9331)class_7923.field_49658.method_63535((class_2960)componentTypeEntry.getValue());
            if (type == null) {
                return Optional.empty();
            }
            if (class_3902.field_51563.equals((Object)type.method_57875())) {
                return Optional.empty();
            }
            class_2522 reader = class_2522.method_68662((DynamicOps)class_2509.field_11560);
            try {
                element = (class_2520)reader.method_67313(val);
            }
            catch (CommandSyntaxException e) {
                return Optional.of(class_2561.method_43470((String)e.getMessage()));
            }
            DataResult result = type.method_57876().parse((DynamicOps)class_2509.field_11560, (Object)element);
            return (Optional)result.mapOrElse(ignored -> Optional.empty(), error -> Optional.of(class_2561.method_43469((String)"arguments.item.component.malformed", (Object[])new Object[]{componentTypeEntry.getValue(), error.message()})));
        };
    }
}

