/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.configuration.BaseProfile;
import net.rizecookey.combatedit.configuration.Settings;
import net.rizecookey.combatedit.configuration.provider.ConfigurationManager;
import net.rizecookey.combatedit.utils.TextUtils;

public class CombatEditCommand
implements CommandRegistrationCallback {
    private static final DynamicCommandExceptionType INVALID_ID = new DynamicCommandExceptionType(id -> TextUtils.fallBackToServerTranslation((class_2561)class_2561.method_43469((String)"command.combatedit.profile.set.error.invalid_base_profile", (Object[])new Object[]{id.toString()})));
    private static final DynamicCommandExceptionType ALREADY_SET = new DynamicCommandExceptionType(id -> TextUtils.fallBackToServerTranslation((class_2561)class_2561.method_43469((String)"command.combatedit.profile.set.error.already_enabled", (Object[])new Object[]{id.toString()})));
    private static final DynamicCommandExceptionType FAILED_TO_SAVE = new DynamicCommandExceptionType(none -> TextUtils.fallBackToServerTranslation((class_2561)class_2561.method_43471((String)"command.combatedit.profile.set.error.settings_save_failed")));
    private final CombatEdit combatEdit;
    private final ConfigurationManager configurationManager;

    public CombatEditCommand(CombatEdit combatEdit) {
        this.combatEdit = combatEdit;
        this.configurationManager = combatEdit.getConfigurationManager();
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"combatedit").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"profile").then(class_2170.method_9247((String)"list").executes(this::executeList))).then(class_2170.method_9247((String)"get").executes(this::executeGet))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"profile", (ArgumentType)class_2232.method_9441()).suggests(this::provideSuggestions).executes(this::executeSet)))));
    }

    private int executeList(CommandContext<class_2168> ctx) {
        Map<class_2960, BaseProfile> baseProfiles = this.configurationManager.getBaseProfiles();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.combatedit.profile.list", (Object[])new Object[]{baseProfiles.size(), class_2564.method_10884(baseProfiles.entrySet(), entry -> CombatEditCommand.baseProfileToText((class_2960)entry.getKey(), (BaseProfile)entry.getValue()))}), false);
        return 1;
    }

    private int executeGet(CommandContext<class_2168> ctx) {
        Map<class_2960, BaseProfile> baseProfiles = this.configurationManager.getBaseProfiles();
        class_2960 selectedId = this.combatEdit.getCurrentSettings().getSelectedBaseProfile();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.combatedit.profile.get", (Object[])new Object[]{CombatEditCommand.baseProfileToText(selectedId, (BaseProfile)baseProfiles.get(selectedId))}), false);
        return 1;
    }

    private CompletableFuture<Suggestions> provideSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        Set<class_2960> validIds = this.configurationManager.getBaseProfiles().keySet();
        validIds.stream().filter(id -> id.toString().startsWith(builder.getRemaining()) || id.method_12836().equals("minecraft") && id.method_12832().startsWith(builder.getRemaining())).forEach(id -> builder.suggest(id.toString()));
        return builder.buildFuture();
    }

    private int executeSet(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2960 id = (class_2960)ctx.getArgument("profile", class_2960.class);
        Settings settings = this.combatEdit.getCurrentSettings().copy();
        if (settings.getSelectedBaseProfile().equals((Object)id)) {
            throw ALREADY_SET.create((Object)id);
        }
        Map<class_2960, BaseProfile> baseProfiles = this.configurationManager.getBaseProfiles();
        if (!baseProfiles.containsKey(id)) {
            throw INVALID_ID.create((Object)id);
        }
        settings.setSelectedBaseProfile(id);
        try {
            this.combatEdit.saveSettings(settings);
        }
        catch (IOException e) {
            CommandSyntaxException cmdException = FAILED_TO_SAVE.create(null);
            CombatEdit.LOGGER.error("Failed to save settings file after changing base profile", (Throwable)e);
            throw cmdException;
        }
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        server.method_29439(server.method_3836().method_29210());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.combatedit.profile.set", (Object[])new Object[]{CombatEditCommand.baseProfileToText(id, (BaseProfile)baseProfiles.get(id))}), true);
        return 1;
    }

    private static class_2561 baseProfileToText(class_2960 id, BaseProfile baseProfile) {
        return class_2561.method_43470((String)id.toString()).method_27694(style -> style.method_10977(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43473().method_10852(baseProfile.getName()).method_27693("\n").method_10852(baseProfile.getDescription()))));
    }
}

