/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.provider;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.v1.reloader.SimpleResourceReloader;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.server.MinecraftServer;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.api.extension.ProfileExtensionProvider;
import net.rizecookey.combatedit.configuration.BaseProfile;
import net.rizecookey.combatedit.configuration.ProfileExtension;
import net.rizecookey.combatedit.configuration.Settings;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.ConfigurationView;
import net.rizecookey.combatedit.configuration.representation.EntityAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemComponents;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;
import net.rizecookey.combatedit.modification.PropertyModifier;
import net.rizecookey.combatedit.utils.ItemStackAttributeHelper;

public class ConfigurationManager
extends SimpleResourceReloader<LoadResult> {
    private static ConfigurationManager INSTANCE;
    private final CombatEdit combatEdit;
    private Configuration configuration;
    private final ItemStackAttributeHelper attributeHelper;
    private final PropertyModifier propertyModifier;
    private final Map<class_2960, List<ProfileExtensionProvider>> registeredProfileExtensions;
    private Map<class_2960, BaseProfile> baseProfiles;
    private List<EntityAttributes> oldEntityAttributes;
    private List<ItemAttributes> oldItemAttributes;
    private List<ItemComponents> oldItemComponents;
    private long lastAttributeReload = Long.MIN_VALUE;

    public ConfigurationManager(CombatEdit combatEdit) {
        this.combatEdit = combatEdit;
        this.propertyModifier = new PropertyModifier(this);
        this.attributeHelper = new ItemStackAttributeHelper(this);
        this.registeredProfileExtensions = new HashMap<class_2960, List<ProfileExtensionProvider>>();
        INSTANCE = this;
    }

    protected LoadResult prepare(class_3302.class_11558 store) {
        class_2960 selectedProfile;
        class_3300 manager = store.method_72361();
        Settings settings = ConfigurationManager.loadSettings(this.combatEdit);
        Map<class_2960, BaseProfile> baseProfiles = ConfigurationManager.loadBaseProfiles(manager);
        if (!baseProfiles.containsKey(selectedProfile = settings.getSelectedBaseProfile())) {
            CombatEdit.LOGGER.error("No base profile with id {} found! Using default profile.", (Object)settings.getSelectedBaseProfile());
            selectedProfile = Settings.loadDefault().getSelectedBaseProfile();
            if (!baseProfiles.containsKey(selectedProfile)) {
                CombatEdit.LOGGER.error("Failed to load CombatEdit configuration resources: Default base profile does not exist");
                return null;
            }
        }
        CombatEdit.LOGGER.info("Selected base profile: {}", (Object)selectedProfile.toString());
        List<ProfileExtension> profileExtensions = ConfigurationManager.loadProfileExtensions(manager, selectedProfile);
        return new LoadResult(settings, baseProfiles, profileExtensions);
    }

    protected void apply(LoadResult prepared, class_3302.class_11558 store) {
        boolean modificationsChanged;
        if (prepared == null) {
            this.updateConfiguration(null);
            return;
        }
        this.baseProfiles = prepared.baseProfiles();
        ArrayList<ProfileExtension> withCustom = new ArrayList<ProfileExtension>(prepared.profileExtensions());
        ((List)this.registeredProfileExtensions.getOrDefault(prepared.settings().getSelectedBaseProfile(), new ArrayList())).forEach(provider -> withCustom.add(provider.provideExtension(prepared.baseProfiles().get(prepared.settings().getSelectedBaseProfile()), this.getModifier())));
        this.updateConfiguration(new LoadResult(prepared.settings(), prepared.baseProfiles(), withCustom));
        boolean bl = modificationsChanged = !Objects.equals(this.oldItemAttributes, this.configuration.getItemAttributes()) || !Objects.equals(this.oldEntityAttributes, this.configuration.getEntityAttributes()) || !Objects.equals(this.oldItemComponents, this.configuration.getItemComponents());
        if (modificationsChanged) {
            this.adjustModifications();
        }
    }

    public CombatEdit getCombatEdit() {
        return this.combatEdit;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ItemStackAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public PropertyModifier getModifier() {
        return this.propertyModifier;
    }

    public MinecraftServer getCurrentServer() {
        return this.combatEdit.getCurrentServer();
    }

    public Map<class_2960, BaseProfile> getBaseProfiles() {
        return this.baseProfiles;
    }

    public long getLastAttributeReload() {
        return this.lastAttributeReload;
    }

    private static Settings loadSettings(CombatEdit combatEdit) {
        return combatEdit.getCurrentSettings();
    }

    private static Map<class_2960, BaseProfile> loadBaseProfiles(class_3300 manager) {
        Map<class_2960, BaseProfile> result = BaseProfile.find(manager);
        CombatEdit.LOGGER.info("Found {} base profiles: {}", (Object)result.size(), (Object)result.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", ")));
        return result;
    }

    private static List<ProfileExtension> loadProfileExtensions(class_3300 manager, class_2960 baseProfileSelected) {
        List<ProfileExtension> result = ProfileExtension.findForProfile(manager, baseProfileSelected);
        CombatEdit.LOGGER.info("Found {} base profile extensions for {}", (Object)result.size(), (Object)baseProfileSelected.toString());
        return result;
    }

    private void updateConfiguration(LoadResult data) {
        if (data == null) {
            this.configuration = MutableConfiguration.loadDefault();
            CombatEdit.LOGGER.warn("Default configuration loaded.");
            return;
        }
        ArrayList<Configuration> prioritizedConfigurationList = new ArrayList<Configuration>();
        prioritizedConfigurationList.add(data.settings().getConfigurationOverrides());
        prioritizedConfigurationList.addAll(data.profileExtensions().stream().sorted(Comparator.comparingInt(ProfileExtension::getPriority).reversed()).map(ProfileExtension::getConfigurationOverrides).toList());
        prioritizedConfigurationList.add(data.baseProfiles().get(data.settings().getSelectedBaseProfile()).getConfiguration());
        this.configuration = new ConfigurationView(prioritizedConfigurationList.toArray(new Configuration[0])).compileCurrentState();
        CombatEdit.LOGGER.info("Configuration updated.");
    }

    private void adjustModifications() {
        this.propertyModifier.makeModifications();
        this.oldItemAttributes = List.copyOf(this.configuration.getItemAttributes());
        this.oldEntityAttributes = List.copyOf(this.configuration.getEntityAttributes());
        this.oldItemComponents = List.copyOf(this.configuration.getItemComponents());
        this.lastAttributeReload = System.currentTimeMillis();
        CombatEdit.LOGGER.info("Adjusted attribute modifications.");
    }

    public void registerProfileExtension(class_2960 profileId, ProfileExtensionProvider extensionProvider) {
        this.registeredProfileExtensions.computeIfAbsent(profileId, key -> new ArrayList()).add(extensionProvider);
    }

    public static ConfigurationManager getInstance() {
        return INSTANCE;
    }

    public record LoadResult(Settings settings, Map<class_2960, BaseProfile> baseProfiles, List<ProfileExtension> profileExtensions) {
    }
}

