/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.configuration.representation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.rizecookey.combatedit.configuration.exception.InvalidConfigurationException;
import net.rizecookey.combatedit.configuration.representation.Configuration;
import net.rizecookey.combatedit.configuration.representation.EntityAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemComponents;
import net.rizecookey.combatedit.configuration.representation.MutableConfiguration;

public class ConfigurationView
implements Configuration {
    private final List<Configuration> configurations;
    private final MiscOptionsView miscOptionsView;

    public ConfigurationView(Configuration ... configurations) {
        this.configurations = List.of(configurations);
        this.miscOptionsView = new MiscOptionsView(() -> this.configurations.stream().map(Configuration::getMiscOptions).toList());
    }

    @Override
    public List<ItemAttributes> getItemAttributes() {
        return this.configurations.reversed().stream().flatMap(config -> config.getItemAttributes().stream()).toList();
    }

    @Override
    public List<ItemComponents> getItemComponents() {
        return this.configurations.reversed().stream().flatMap(config -> config.getItemComponents().stream()).toList();
    }

    @Override
    public List<EntityAttributes> getEntityAttributes() {
        return this.configurations.reversed().stream().flatMap(config -> config.getEntityAttributes().stream()).toList();
    }

    private static <T, U> Optional<T> firstPresent(Collection<U> sources, Function<U, Optional<T>> providers) {
        for (U source : sources) {
            Optional<T> result = providers.apply(source);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> isSoundEnabled(class_2960 soundIdentifier) {
        return ConfigurationView.firstPresent(this.configurations, config -> config.isSoundEnabled(soundIdentifier));
    }

    @Override
    public Map<class_2960, Boolean> getSoundMap() {
        HashMap<class_2960, Boolean> map = new HashMap<class_2960, Boolean>();
        this.configurations.stream().flatMap(config -> config.getSoundMap().keySet().stream()).filter(id -> this.isSoundEnabled((class_2960)id).isPresent()).forEach(id -> map.put((class_2960)id, this.isSoundEnabled((class_2960)id).orElse(null)));
        return map;
    }

    @Override
    public Configuration.MiscOptions getMiscOptions() {
        return this.miscOptionsView;
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        for (Configuration config : this.configurations) {
            config.validate();
        }
    }

    public MutableConfiguration compileCurrentState() {
        return new MutableConfiguration(this.getItemAttributes(), this.getItemComponents(), this.getEntityAttributes(), this.getSoundMap(), new MutableConfiguration.MiscOptions(this.getMiscOptions().is1_8KnockbackEnabled().orElse(null), this.getMiscOptions().isSweepingWithoutEnchantmentDisabled().orElse(null)));
    }

    public static class MiscOptionsView
    implements Configuration.MiscOptions {
        private final Supplier<List<Configuration.MiscOptions>> optionsSupplier;

        public MiscOptionsView(Supplier<List<Configuration.MiscOptions>> optionsSupplier) {
            this.optionsSupplier = optionsSupplier;
        }

        @Override
        public Optional<Boolean> is1_8KnockbackEnabled() {
            return ConfigurationView.firstPresent((Collection)this.optionsSupplier.get(), Configuration.MiscOptions::is1_8KnockbackEnabled);
        }

        @Override
        public Optional<Boolean> isSweepingWithoutEnchantmentDisabled() {
            return ConfigurationView.firstPresent((Collection)this.optionsSupplier.get(), Configuration.MiscOptions::isSweepingWithoutEnchantmentDisabled);
        }
    }
}

