/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.modification.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.rizecookey.combatedit.CombatEdit;
import net.rizecookey.combatedit.api.extension.DefaultsSupplier;
import net.rizecookey.combatedit.configuration.representation.ItemAttributes;
import net.rizecookey.combatedit.configuration.representation.ItemComponents;
import net.rizecookey.combatedit.modification.item.ItemModificationProvider;
import org.jetbrains.annotations.Nullable;

public class ItemModificationMap
implements ItemModificationProvider {
    private final Map<class_1792, class_9285> attributeMap;
    private final Map<class_1792, class_9323> componentMap;

    public ItemModificationMap(Map<class_1792, class_9285> attributeMap, Map<class_1792, class_9323> componentMap) {
        this.attributeMap = Map.copyOf(attributeMap);
        this.componentMap = Map.copyOf(componentMap);
    }

    @Override
    public class_9285 getAttributeModifiers(class_2960 id, class_1792 item, class_9285 originalDefaults) {
        return this.attributeMap.getOrDefault(item, originalDefaults);
    }

    @Override
    public boolean shouldModifyAttributes(class_2960 id, class_1792 item) {
        return this.attributeMap.containsKey(item);
    }

    @Override
    public class_9323 getComponents(class_2960 id, class_1792 item, class_9323 originalDefaults) {
        return this.componentMap.getOrDefault(item, originalDefaults);
    }

    @Override
    public boolean shouldModifyDefaultComponents(class_2960 id, class_1792 item) {
        return this.componentMap.containsKey(item);
    }

    public static ItemModificationMap fromConfiguration(List<ItemAttributes> itemAttributes, List<ItemComponents> itemComponents, DefaultsSupplier.Items itemDefaultsSupplier) {
        Map.Entry<class_1792, class_9285> result;
        HashMap<class_1792, class_9285> attributeModifiers = new HashMap<class_1792, class_9285>();
        HashMap<class_1792, class_9323> componentMap = new HashMap<class_1792, class_9323>();
        Function<class_1792, class_9285> defaultProvider = item -> {
            if (attributeModifiers.containsKey(item)) {
                return (class_9285)attributeModifiers.get(item);
            }
            return itemDefaultsSupplier.getVanillaAttributeModifiers((class_1792)item);
        };
        for (ItemAttributes attribute : itemAttributes) {
            result = ItemModificationMap.fromConfigurationEntry(attribute, defaultProvider);
            if (result == null) continue;
            attributeModifiers.put(result.getKey(), result.getValue());
        }
        for (ItemComponents components : itemComponents) {
            result = ItemModificationMap.fromConfigurationEntry(components, itemDefaultsSupplier::getVanillaComponents);
            if (result == null) continue;
            componentMap.put(result.getKey(), (class_9323)result.getValue());
        }
        return new ItemModificationMap(attributeModifiers, componentMap);
    }

    @Nullable
    private static Map.Entry<class_1792, class_9285> fromConfigurationEntry(ItemAttributes attributes, Function<class_1792, class_9285> originalDefaults) {
        class_9285.class_9286 builder = class_9285.method_57480();
        if (!class_7923.field_41178.method_10250(attributes.getItemId())) {
            CombatEdit.LOGGER.warn("No item with id {} found, skipping all attribute specifications", (Object)attributes.getItemId());
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(attributes.getItemId());
        if (!attributes.isOverrideDefault()) {
            originalDefaults.apply(item).comp_2393().forEach(entry -> builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397()));
        }
        for (ItemAttributes.ModifierEntry entry2 : attributes.getModifiers()) {
            if (!class_7923.field_41190.method_10250(entry2.attribute())) {
                CombatEdit.LOGGER.warn("No attribute with id {} found, skipping modifier", (Object)entry2.attribute());
                continue;
            }
            class_6880.class_6883 attribute = (class_6880.class_6883)class_7923.field_41190.method_10223(entry2.attribute()).orElseThrow();
            class_1322 modifier = new class_1322(entry2.modifierId() != null ? entry2.modifierId() : ItemModificationMap.generateBasedOnIndex(attributes.getModifiers().indexOf(entry2)), entry2.value(), entry2.operation());
            builder.method_57487((class_6880)attribute, modifier, entry2.slot());
        }
        return Map.entry(item, builder.method_57486());
    }

    @Nullable
    private static Map.Entry<class_1792, class_9323> fromConfigurationEntry(ItemComponents components, Function<class_1792, class_9323> originalDefaults) {
        if (!class_7923.field_41178.method_10250(components.getItemId())) {
            CombatEdit.LOGGER.warn("No item with id {} found, skipping all component specifications", (Object)components.getItemId());
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(components.getItemId());
        class_9323.class_9324 builder = class_9323.method_57827().combatEdit$preventDynamicWrap();
        originalDefaults.apply(item).forEach(component -> builder.method_57840(component.comp_2443(), component.comp_2444()));
        for (ItemComponents.ComponentChangeEntry entry : components.getChanges()) {
            if (!class_7923.field_49658.method_10250(entry.componentType())) {
                CombatEdit.LOGGER.warn("No component with id {} found, skipping component", (Object)entry.componentType());
                return null;
            }
            class_9331 componentType = (class_9331)class_7923.field_49658.method_63535(entry.componentType());
            assert (componentType != null);
            if (class_9334.field_49636.equals((Object)componentType)) {
                CombatEdit.LOGGER.warn("Changing attribute modifiers via components not supported, use the attribute modifiers feature instead. Skipping component entry for {}", (Object)components.getItemId());
                return null;
            }
            if (entry.changeType().equals((Object)ItemComponents.ChangeType.REMOVE)) {
                builder.method_57840(componentType, null);
                continue;
            }
            if (Objects.equals(componentType.method_57875(), class_3902.field_51563)) {
                builder.method_57840(componentType, (Object)class_3902.field_17274);
                continue;
            }
            try {
                class_2520 nbtValue = (class_2520)class_2522.method_68662((DynamicOps)class_2509.field_11560).method_67313(entry.value());
                builder.method_57840(componentType, componentType.method_57876().parse((DynamicOps)class_2509.field_11560, (Object)nbtValue).getOrThrow());
            }
            catch (CommandSyntaxException e) {
                throw new IllegalStateException("Error parsing component for type %s".formatted(entry.componentType()), e);
            }
        }
        return Map.entry(item, builder.method_57838());
    }

    public static class_2960 generateBasedOnIndex(int index) {
        return class_2960.method_60655((String)"combatedit.special", (String)("generated/" + (index + 1)));
    }
}

