/*
 * Decompiled with CFR 0.152.
 */
package net.rizecookey.combatedit.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.stream.Collector;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public final class ConfigMigration {
    private ConfigMigration() {
    }

    public static JsonObject migrateToNewerVersion(JsonObject old, int version) {
        JsonArray newAttributes;
        JsonArray oldArray;
        JsonObject copy = old.deepCopy();
        if (version < 1) {
            copy.addProperty("configuration_version", (Number)1);
        }
        if (version < 2 && copy.has("item_attributes") && copy.get("item_attributes").isJsonArray()) {
            oldArray = copy.get("item_attributes").getAsJsonArray();
            newAttributes = ConfigMigration.migrateModifierUUIDsToIdentifiers(oldArray);
            copy.remove("item_attributes");
            copy.add("item_attributes", (JsonElement)newAttributes);
        }
        if (version < 3) {
            if (copy.has("item_attributes") && copy.get("item_attributes").isJsonArray()) {
                oldArray = copy.get("item_attributes").getAsJsonArray();
                newAttributes = ConfigMigration.migrateItemAttributesAttributeIds(oldArray);
                copy.add("item_attributes", (JsonElement)newAttributes);
            }
            if (copy.has("entity_attributes") && copy.get("entity_attributes").isJsonArray()) {
                oldArray = copy.get("entity_attributes").getAsJsonArray();
                JsonArray newDefaults = ConfigMigration.migrateEntityAttributesAttributeIds(oldArray);
                copy.add("entity_attributes", (JsonElement)newDefaults);
            }
        }
        return copy;
    }

    private static JsonArray migrateModifierUUIDsToIdentifiers(JsonArray itemAttributes) {
        JsonArray result = new JsonArray();
        for (JsonElement entry : itemAttributes) {
            if (!entry.isJsonObject()) continue;
            JsonObject oldEntry = entry.getAsJsonObject();
            JsonObject newEntry = oldEntry.deepCopy();
            if (!oldEntry.has("modifiers") || !oldEntry.get("modifiers").isJsonArray()) continue;
            JsonArray oldModifiers = oldEntry.get("modifiers").getAsJsonArray();
            JsonArray newModifiers = new JsonArray();
            for (JsonElement modifier : oldModifiers) {
                if (!modifier.isJsonObject()) continue;
                JsonObject newModifier = ConfigMigration.migrateUUIDToIdentifier(modifier.getAsJsonObject());
                newModifiers.add((JsonElement)newModifier);
            }
            newEntry.add("modifiers", (JsonElement)newModifiers);
            result.add((JsonElement)newEntry);
        }
        return result;
    }

    private static JsonObject migrateUUIDToIdentifier(JsonObject modifier) {
        UUID uuid;
        if (!modifier.has("uuid") || !modifier.get("uuid").isJsonPrimitive()) {
            return modifier;
        }
        String uuidString = modifier.get("uuid").getAsString();
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return modifier;
        }
        JsonObject result = modifier.deepCopy();
        result.remove("uuid");
        result.addProperty("modifier_id", ConfigMigration.transformUUID(uuid).toString());
        return result;
    }

    private static class_2960 transformUUID(UUID uuid) {
        if (UUID.fromString("cb3f55d3-645c-4f38-a497-9c13a33db5cf").equals(uuid)) {
            return class_1792.field_8006;
        }
        if (UUID.fromString("fa233e1c-4180-4865-b01b-bcce9785aca3").equals(uuid)) {
            return class_1792.field_8001;
        }
        return class_2960.method_60655((String)"combatedit", (String)("generated/" + String.valueOf(uuid)));
    }

    private static JsonArray migrateItemAttributesAttributeIds(JsonArray itemAttributes) {
        return itemAttributes.asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(entry -> {
            if (!entry.getAsJsonObject().has("modifiers") || !entry.getAsJsonObject().get("modifiers").isJsonArray()) {
                return entry;
            }
            return ConfigMigration.migrateItemAttributeEntryAttributeIds(entry);
        }).collect(ConfigMigration.jsonArrayCollector());
    }

    private static JsonObject migrateItemAttributeEntryAttributeIds(JsonObject itemAttribute) {
        JsonObject result = itemAttribute.deepCopy();
        result.add("modifiers", (JsonElement)itemAttribute.get("modifiers").getAsJsonArray().asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).filter(modifier -> modifier.has("attribute") && modifier.get("attribute").isJsonPrimitive() && class_2960.method_29186((String)modifier.get("attribute").getAsString()).isSuccess()).map(modifier -> {
            JsonObject newModifier = modifier.getAsJsonObject().deepCopy();
            newModifier.addProperty("attribute", ConfigMigration.migrateAttributeId(class_2960.method_60654((String)modifier.get("attribute").getAsString())).toString());
            return newModifier;
        }).collect(ConfigMigration.jsonArrayCollector()));
        return result;
    }

    private static JsonArray migrateEntityAttributesAttributeIds(JsonArray entityAttributes) {
        return entityAttributes.asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(entry -> {
            if (!entry.getAsJsonObject().has("base_values") || !entry.getAsJsonObject().get("base_values").isJsonArray()) {
                return entry;
            }
            return ConfigMigration.migrateEntityAttributeEntryAttributeIds(entry);
        }).collect(ConfigMigration.jsonArrayCollector());
    }

    private static JsonObject migrateEntityAttributeEntryAttributeIds(JsonObject entityAttributeEntry) {
        JsonObject result = entityAttributeEntry.deepCopy();
        result.add("base_values", (JsonElement)entityAttributeEntry.get("base_values").getAsJsonArray().asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).filter(baseValue -> baseValue.has("attribute") && baseValue.get("attribute").isJsonPrimitive() && class_2960.method_29186((String)baseValue.get("attribute").getAsString()).isSuccess()).map(baseValue -> {
            JsonObject newBaseValue = baseValue.deepCopy();
            newBaseValue.addProperty("attribute", ConfigMigration.migrateAttributeId(class_2960.method_60654((String)baseValue.get("attribute").getAsString())).toString());
            return newBaseValue;
        }).collect(ConfigMigration.jsonArrayCollector()));
        return result;
    }

    private static class_2960 migrateAttributeId(class_2960 previous) {
        return class_2960.method_60655((String)previous.method_12836(), (String)previous.method_12832().replaceFirst("^generic\\.", "").replaceFirst("^player\\.", ""));
    }

    private static Collector<JsonElement, JsonArray, JsonArray> jsonArrayCollector() {
        return Collector.of(JsonArray::new, JsonArray::add, (array1, array2) -> {
            JsonArray result = new JsonArray();
            result.addAll(array1);
            result.addAll(array2);
            return result;
        }, new Collector.Characteristics[0]);
    }
}

