/*
 * Decompiled with CFR 0.152.
 */
package com.mars.expcounter.mixin;

import com.mars.expcounter.ExpCounterConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.gui.contextualbar.ExperienceBarRenderer;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExperienceBarRenderer.class})
public abstract class MixinMinecraft
implements ContextualBarRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"renderBackground"}, at={@At(value="RETURN")})
    public void renderExperienceBar(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        LocalPlayer localPlayer = this.minecraft.player;
        Font font = this.minecraft.font;
        if (ExpCounterConfig.show_next_level) {
            int currentExp = (int)((float)localPlayer.getXpNeededForNextLevel() * localPlayer.experienceProgress);
            String nextLvlString = currentExp + "/" + localPlayer.getXpNeededForNextLevel();
            int xNextLevel = (guiGraphics.guiWidth() - font.width(nextLvlString)) / 2 + ExpCounterConfig.position_off_centre_next_level;
            int yNextLevel = guiGraphics.guiHeight() - ExpCounterConfig.position_y_next_level;
            int colNextLevel = 0xFF000000 | ExpCounterConfig.color_next_level & 0xFFFFFF;
            guiGraphics.drawString(font, nextLvlString, xNextLevel, yNextLevel, colNextLevel, true);
        }
        if (ExpCounterConfig.show_total) {
            String totalExperience = String.valueOf(this.getRealTotalExperience(localPlayer.experienceLevel, (int)((float)localPlayer.getXpNeededForNextLevel() * localPlayer.experienceProgress)));
            int xTotal = (guiGraphics.guiWidth() - font.width(totalExperience)) / 2 + ExpCounterConfig.position_off_centre_total;
            int yTotal = guiGraphics.guiHeight() - ExpCounterConfig.position_y_total;
            int colTotal = 0xFF000000 | ExpCounterConfig.color_total & 0xFFFFFF;
            guiGraphics.drawString(font, totalExperience, xTotal, yTotal, colTotal, true);
        }
    }

    @Unique
    public int getRealTotalExperience(int level, int currentExp) {
        int total = level <= 16 ? (int)(Math.pow(level, 2.0) + (double)(6 * level)) : (level <= 31 ? (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0) : (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0));
        return total + currentExp;
    }
}

