/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.DefaultAdminCommand;
import world.bentobox.bentobox.api.commands.island.DefaultPlayerCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.stranger.Settings;
import world.bentobox.stranger.border.BorderShower;
import world.bentobox.stranger.border.BorderType;
import world.bentobox.stranger.border.PerPlayerBorderProxy;
import world.bentobox.stranger.border.ShowBarrier;
import world.bentobox.stranger.border.ShowWorldBorder;
import world.bentobox.stranger.commands.admin.WorldBorderCommand;
import world.bentobox.stranger.commands.player.ClaimCommand;
import world.bentobox.stranger.commands.player.SpawnCommand;
import world.bentobox.stranger.commands.player.UnclaimCommand;
import world.bentobox.stranger.generator.NetherBiomeProvider;
import world.bentobox.stranger.generator.NetherChunkMaker;
import world.bentobox.stranger.generator.NetherChunks;
import world.bentobox.stranger.listeners.NetherRedstoneListener;
import world.bentobox.stranger.listeners.PlayerListener;
import world.bentobox.stranger.listeners.TeamListener;

public class StrangerRealms
extends GameModeAddon {
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";
    public static final Material WARPED_COMPASS_MATERIAL = Material.COMPASS;
    private Settings settings;
    private final Config<Settings> configObject = new Config((Addon)this, Settings.class);
    private BorderShower borderShower;
    private final Set<BorderType> availableBorderTypes = EnumSet.of(BorderType.VANILLA, BorderType.BARRIER);
    private int borderSize;
    private BukkitTask task;
    private PlayerListener playerListener;
    private NetherChunkMaker netherChunkMaker;

    public boolean isFixIslandCenter() {
        return false;
    }

    public boolean isEnforceEqualRanges() {
        return false;
    }

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadSettings();
        this.netherChunkMaker = new NetherChunkMaker(this);
        this.playerCommand = new DefaultPlayerCommand(this, this){

            public void setup() {
                super.setup();
                new ClaimCommand((CompositeCommand)this);
                new UnclaimCommand((CompositeCommand)this);
                new SpawnCommand((CompositeCommand)this);
            }
        };
        this.adminCommand = new DefaultAdminCommand(this, this){

            public void setup() {
                super.setup();
                new WorldBorderCommand((CompositeCommand)this);
            }
        };
    }

    private boolean loadSettings() {
        this.settings = (Settings)this.configObject.loadConfigObject();
        if (this.settings == null) {
            this.logError("Settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return false;
        }
        return true;
    }

    public void onEnable() {
        if (this.getPlugin().getAddonsManager().getAddonByName("Border").isPresent()) {
            this.logWarning("StrangerRealms has its own Border, so do not use Border in the Crowdbound world.");
        }
        if (this.getPlugin().getAddonsManager().getAddonByName("InvSwitcher").isEmpty()) {
            this.logWarning("StrangerRealms recommends the InvSwitcher addon.");
        }
        this.borderShower = this.createBorder();
        this.playerListener = new PlayerListener(this);
        this.registerListener(this.playerListener);
        this.registerListener(this.netherChunkMaker);
        this.registerListener(new TeamListener(this));
        this.registerListener(new NetherRedstoneListener(this));
        this.registerWarpedCompassRecipe();
        if (this.getPlugin().getIslands().getSpawn(this.getOverWorld()).isEmpty()) {
            Island spawn = this.getPlugin().getIslands().createIsland(this.getOverWorld().getSpawnLocation());
            if (spawn != null) {
                spawn.setSpawn(true);
                spawn.setSpawnPoint(Map.of(World.Environment.NORMAL, this.getOverWorld().getSpawnLocation()));
                IslandsManager.saveIsland((Island)spawn);
            } else {
                this.logError("Could not make a spawn claim. You will have to set one manually in the world.");
            }
        }
    }

    public void onDisable() {
    }

    public void onReload() {
        if (this.loadSettings()) {
            this.log("Reloaded settings");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void createWorlds() {
        String worldName = this.settings.getWorldName().toLowerCase();
        this.islandWorld = this.getWorld(worldName, World.Environment.NORMAL);
        if (this.settings.isNetherGenerate()) {
            if (Bukkit.getWorld((String)(worldName + NETHER)) == null) {
                this.netherChunkMaker.clearDatabase();
            }
            this.netherWorld = this.getWorld(worldName, World.Environment.NETHER);
        }
        if (this.settings.isEndGenerate()) {
            this.endWorld = this.getWorld(worldName, World.Environment.THE_END);
        }
    }

    private World getWorld(String worldName2, World.Environment env) {
        worldName2 = env == World.Environment.NETHER ? (String)worldName2 + NETHER : worldName2;
        worldName2 = env == World.Environment.THE_END ? (String)worldName2 + THE_END : worldName2;
        World w = WorldCreator.name((String)worldName2).environment(env).generator((ChunkGenerator)(env == World.Environment.NETHER ? new NetherChunks() : null)).biomeProvider((BiomeProvider)(env == World.Environment.NETHER ? new NetherBiomeProvider() : null)).seed(this.getSettings().getSeed()).createWorld();
        if (w != null) {
            this.setSpawnRates(w);
        }
        return w;
    }

    private void setSpawnRates(World w) {
        if (this.getSettings().getSpawnLimitMonsters() > 0) {
            w.setSpawnLimit(SpawnCategory.MONSTER, this.getSettings().getSpawnLimitMonsters());
        }
        if (this.getSettings().getSpawnLimitAmbient() > 0) {
            w.setSpawnLimit(SpawnCategory.AMBIENT, this.getSettings().getSpawnLimitAmbient());
        }
        if (this.getSettings().getSpawnLimitAnimals() > 0) {
            w.setSpawnLimit(SpawnCategory.ANIMAL, this.getSettings().getSpawnLimitAnimals());
        }
        if (this.getSettings().getSpawnLimitWaterAnimals() > 0) {
            w.setSpawnLimit(SpawnCategory.WATER_ANIMAL, this.getSettings().getSpawnLimitWaterAnimals());
        }
        if (this.getSettings().getTicksPerAnimalSpawns() > 0) {
            w.setTicksPerSpawns(SpawnCategory.ANIMAL, this.getSettings().getTicksPerAnimalSpawns());
        }
        if (this.getSettings().getTicksPerMonsterSpawns() > 0) {
            w.setTicksPerSpawns(SpawnCategory.MONSTER, this.getSettings().getTicksPerMonsterSpawns());
        }
    }

    public WorldSettings getWorldSettings() {
        return this.getSettings();
    }

    public @Nullable ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return Bukkit.getWorld((String)worldName).getGenerator();
    }

    public void saveWorldSettings() {
        if (this.settings != null) {
            this.configObject.saveConfigObject((Object)this.settings);
        }
    }

    public void allLoaded() {
        this.saveWorldSettings();
    }

    public boolean isUsesNewChunkGeneration() {
        return true;
    }

    public Set<BorderType> getAvailableBorderTypesView() {
        return Collections.unmodifiableSet(this.availableBorderTypes);
    }

    private BorderShower createBorder() {
        ShowBarrier customBorder = new ShowBarrier(this);
        ShowWorldBorder wbapiBorder = new ShowWorldBorder(this);
        return new PerPlayerBorderProxy(this, customBorder, wbapiBorder);
    }

    public BorderShower getBorderShower() {
        return this.borderShower;
    }

    public double getBorderSize() {
        int newBorderSize;
        int n = newBorderSize = this.getSettings().isManualBorderSize() ? this.borderSize : Math.max(this.getSettings().getBarrierIncreaseBlocks(), this.getSettings().getBarrierIncreaseBlocks() * Bukkit.getServer().getOnlinePlayers().size());
        if (newBorderSize < this.borderSize) {
            this.task.cancel();
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.getPlugin(), () -> {
                if (this.borderSize > newBorderSize) {
                    --this.borderSize;
                    Bukkit.getOnlinePlayers().stream().filter(p -> this.inWorld(p.getWorld())).forEach(this.borderShower::showBorder);
                } else {
                    this.task.cancel();
                }
            }, (long)this.getSettings().getBarrierReductionSpeed() * 20L, (long)this.getSettings().getBarrierReductionSpeed() * 20L);
        } else {
            this.borderSize = newBorderSize;
        }
        return this.borderSize;
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    public void cancelBorderTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public static ItemStack createWarpedCompassItem() {
        ItemStack warpedCompass = new ItemStack(WARPED_COMPASS_MATERIAL);
        ItemMeta meta = warpedCompass.getItemMeta();
        Component displayName = Component.text((String)"Warped Compass", (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.BOLD);
        meta.displayName(displayName);
        List<Component> lore = Arrays.asList(Component.text((String)"Hold fast to the needle when the realm is stale.", (TextColor)NamedTextColor.GRAY), Component.text((String)"A single spark is all it takes to refresh the flame.", (TextColor)NamedTextColor.GRAY), Component.empty(), Component.text((String)"Consumed upon entry to re-thread the Nether.", (TextColor)NamedTextColor.RED));
        meta.lore(lore);
        warpedCompass.setItemMeta(meta);
        return warpedCompass;
    }

    public static boolean isWarpedCompass(ItemStack item) {
        if (item == null || item.getType() != WARPED_COMPASS_MATERIAL) {
            return false;
        }
        ItemMeta referenceMeta = StrangerRealms.createWarpedCompassItem().getItemMeta();
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta.equals((Object)referenceMeta);
    }

    private void registerWarpedCompassRecipe() {
        ItemStack warpedCompass = StrangerRealms.createWarpedCompassItem();
        NamespacedKey key = new NamespacedKey((Plugin)this.getPlugin(), "warped_compass");
        ShapedRecipe recipe = new ShapedRecipe(key, warpedCompass);
        recipe.shape(new String[]{"COC", "FRF", "COC"});
        recipe.setIngredient('O', Material.OBSIDIAN);
        recipe.setIngredient('C', Material.CRYING_OBSIDIAN);
        recipe.setIngredient('F', Material.WARPED_FUNGUS);
        recipe.setIngredient('R', Material.RECOVERY_COMPASS);
        this.getServer().addRecipe((Recipe)recipe);
    }

    public PlayerListener getPlayerListener() {
        return this.playerListener;
    }
}

