/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.commands.player;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.IslandDeletion;
import world.bentobox.stranger.StrangerRealms;

public class UnclaimCommand
extends ConfirmableCommand {
    private StrangerRealms addon;

    public UnclaimCommand(CompositeCommand playerCommand) {
        super(playerCommand, "unclaim", new String[0]);
    }

    public void setup() {
        this.setPermission("unclaim");
        this.setOnlyPlayer(true);
        this.setDescription("commands.unclaim.description");
        this.addon = (StrangerRealms)this.getAddon();
    }

    public boolean execute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp((CompositeCommand)this, user);
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), user)) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Optional<Island> opClaim = this.getIslands().getIslandAt(user.getLocation()).filter(is -> ((StrangerRealms)this.getAddon()).inWorld(is.getWorld())).filter(is -> is.getOwner() != null && is.getOwner().equals(user.getUniqueId()));
        if (opClaim.isEmpty()) {
            user.sendMessage("strangerrealms.errors.must-be-in", new String[0]);
            return false;
        }
        this.askConfirmation(user, () -> this.deleteClaim(user, (Island)opClaim.get()));
        return true;
    }

    public boolean deleteClaim(User user, Island claim) {
        UUID uuid = user.getUniqueId();
        IslandEvent.builder().involvedPlayer(uuid).reason(IslandEvent.Reason.PRECLEAR).island(claim).oldIsland(claim).location(claim.getCenter()).build();
        IslandBaseEvent event = IslandEvent.builder().island(claim).involvedPlayer(uuid).reason(IslandEvent.Reason.DELETE).build();
        if (event.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(event.isCancelled()).booleanValue()) {
            return false;
        }
        List players = claim.getPlayersOnIsland();
        claim.setOwner(null);
        this.getIslands().removePlayersFromIsland(claim);
        claim.setDeletable(true);
        this.getIslands().getIslandCache().deleteIslandFromCache(claim);
        this.getIslands().deleteIslandId(claim.getUniqueId());
        IslandEvent.builder().deletedIslandInfo(new IslandDeletion(claim)).reason(IslandEvent.Reason.DELETED).build();
        user.sendMessage("strangerrealms.commands.unclaim.success", new String[0]);
        players.forEach(p -> this.addon.getBorderShower().showBorder((Player)p));
        return true;
    }
}

