/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.generator;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import world.bentobox.stranger.generator.CustomCaveGenerator;

public class NetherChunks
extends ChunkGenerator {
    private CustomCaveGenerator caveGenerator;
    private static final double CAVE_THRESHOLD = 0.4;

    public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.caveGenerator == null) {
            this.caveGenerator = new CustomCaveGenerator(worldInfo.getSeed());
        }
        int minCaveY = worldInfo.getMinHeight() + 5;
        int maxCaveY = minCaveY + 20;
        double caveRange = maxCaveY - minCaveY;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = chunkX * 16 + x;
                int worldZ = chunkZ * 16 + z;
                int top = maxCaveY - random.nextInt(5);
                for (int y = minCaveY; y < top; ++y) {
                    double yProgress;
                    double swellFactor;
                    double yDependentThreshold;
                    int worldY = y;
                    double noise = this.caveGenerator.noise(worldX, worldY, worldZ);
                    if (noise < (yDependentThreshold = 0.4 * (swellFactor = Math.sin((yProgress = (double)(y - minCaveY) / caveRange) * Math.PI))) + 0.1) {
                        chunkData.setBlock(x, y, z, Material.SCULK);
                    }
                    if (!(noise < yDependentThreshold)) continue;
                    chunkData.setBlock(x, y, z, Material.AIR);
                }
            }
        }
    }

    public boolean shouldGenerateNoise() {
        return true;
    }

    public boolean shouldGenerateSurface() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return true;
    }

    public boolean shouldGenerateDecorations() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        int minY = worldInfo.getMinHeight() + 5;
        int maxY = minY + 20;
        for (int y = minY; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockData block = chunkData.getBlockData(x, y, z);
                    BlockData upBlock = chunkData.getBlockData(x, y + 1, z);
                    if (upBlock.getMaterial() != Material.AIR && block.getMaterial() == Material.AIR) {
                        if (!(random.nextDouble() < 0.1)) continue;
                        chunkData.setBlock(x, y, z, Material.SCULK_VEIN);
                        continue;
                    }
                    if (block.getMaterial() == Material.AIR || upBlock.getMaterial() != Material.AIR) continue;
                    if (random.nextDouble() < 0.1) {
                        chunkData.setBlock(x, y, z, Material.SCULK_SENSOR);
                        continue;
                    }
                    if (!(random.nextDouble() < 0.2)) continue;
                    chunkData.setBlock(x, y, z, Material.SCULK_VEIN);
                }
            }
        }
    }
}

