/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.border;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.bentobox.util.teleport.SafeSpotTeleport;
import world.bentobox.stranger.StrangerRealms;
import world.bentobox.stranger.listeners.BorderShower;

public class ShowWorldBorder
implements BorderShower {
    private final StrangerRealms addon;

    public ShowWorldBorder(StrangerRealms addon) {
        this.addon = addon;
    }

    @Override
    public void showBorder(Player player) {
        if (this.addon.getSettings().isDisableWorldBorder() || !Objects.requireNonNull(User.getInstance((Player)player)).getMetaData("Stranger_border_state").map(MetaDataValue::asBoolean).orElse(true).booleanValue()) {
            return;
        }
        this.addon.getIslands().getIslandAt(player.getLocation()).ifPresentOrElse(island -> {
            Location l = island.getProtectionCenter().toVector().toLocation(player.getWorld());
            Location center = Objects.requireNonNullElse(this.addon.getIslands().getSpawnPoint(player.getWorld()), player.getWorld().getSpawnLocation());
            double dist = this.addon.getBorderSize() / 2.0;
            BoundingBox worldBB = BoundingBox.of((Vector)center.toVector(), (double)dist, (double)dist, (double)dist);
            if (worldBB.contains(island.getBoundingBox())) {
                this.showWorldBarrier(player);
                return;
            }
            WorldBorder wb = Bukkit.createWorldBorder();
            wb.setCenter(l);
            double size = Math.min((double)island.getRange() * 2.0, (double)island.getProtectionRange() * 2.0);
            wb.setSize(size);
            wb.setWarningDistance(0);
            player.setWorldBorder(wb);
        }, () -> this.showWorldBarrier(player));
    }

    private void showWorldBarrier(Player player) {
        if (!this.addon.inWorld(player.getWorld())) {
            return;
        }
        Location center = Objects.requireNonNullElse(this.addon.getIslands().getSpawnPoint(player.getWorld()), player.getWorld().getSpawnLocation());
        WorldBorder wb = Bukkit.createWorldBorder();
        wb.setCenter(center);
        double size = this.addon.getBorderSize();
        wb.setSize(size);
        wb.setWarningDistance(5);
        if (!wb.isInside(player.getLocation())) {
            User.getInstance((Player)player).sendMessage("strangerrealms.teleporting-to-spawn", new String[0]);
            new SafeSpotTeleport.Builder(this.addon.getPlugin()).entity((Entity)player).location(center).build();
        }
        player.setWorldBorder(wb);
    }

    @Override
    public void hideBorder(User user) {
        user.getPlayer().setWorldBorder(null);
    }

    @Override
    public void teleportPlayer(Player p) {
        this.addon.getIslands().getIslandAt(p.getLocation()).ifPresent(i -> {
            Vector unitVector = i.getCenter().toVector().subtract(p.getLocation().toVector()).normalize().multiply(new Vector(1, 0, 1));
            Location to = p.getLocation().toVector().add(unitVector).toLocation(p.getWorld());
            to.setPitch(p.getLocation().getPitch());
            to.setYaw(p.getLocation().getYaw());
            Util.teleportAsync((Entity)p, (Location)to, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.PLUGIN);
        });
    }
}

