/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.events.island.IslandProtectionRangeChangeEvent;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.stranger.StrangerRealms;
import world.bentobox.stranger.listeners.BorderShower;

public class PlayerListener
implements Listener {
    private static final Vector XZ = new Vector(1, 0, 1);
    private final StrangerRealms addon;
    private final Set<UUID> inTeleport;
    private final BorderShower show;
    private final Map<Player, BukkitTask> mountedPlayers = new HashMap<Player, BukkitTask>();

    public PlayerListener(StrangerRealms addon) {
        this.addon = addon;
        this.inTeleport = new HashSet<UUID>();
        this.show = addon.getBorderShower();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (!this.addon.inWorld(player.getWorld())) {
            return;
        }
        if (this.isOn(player)) {
            Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.processEvent(e));
        }
        Bukkit.getOnlinePlayers().stream().filter(p -> this.addon.inWorld(p.getWorld())).forEach(this.show::showBorder);
    }

    protected void processEvent(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (!this.isOn(player) || !this.addon.inWorld(player.getWorld())) {
            return;
        }
        User user = User.getInstance((Player)e.getPlayer());
        this.show.hideBorder(user);
        user.getPlayer().setWorldBorder(null);
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.show.showBorder(e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.show.clearUser(User.getInstance((Player)e.getPlayer()));
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), this.addon::getBorderSize);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        if (this.isOn(player)) {
            this.show.clearUser(User.getInstance((Player)e.getPlayer()));
            Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.show.showBorder(e.getPlayer()));
        }
    }

    private boolean isOn(Player player) {
        User user = User.getInstance((Player)player);
        return user.getMetaData("Stranger_border_state").map(MetaDataValue::asBoolean).orElse(true);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        Player player = e.getPlayer();
        if (!this.isOn(player)) {
            return;
        }
        Location to = e.getTo();
        this.show.clearUser(User.getInstance((Player)player));
        if (to == null || !this.addon.inWorld(to.getWorld())) {
            return;
        }
        PlayerTeleportEvent.TeleportCause cause = e.getCause();
        boolean isBlacklistedCause = cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || cause == PlayerTeleportEvent.TeleportCause.CONSUMABLE_EFFECT;
        Bukkit.getScheduler().runTask((Plugin)this.addon.getPlugin(), () -> this.addon.getIslands().getIslandAt(to).ifPresentOrElse(i -> {
            Optional boxedEnderPearlFlag = i.getPlugin().getFlagsManager().getFlag("ALLOW_MOVE_BOX");
            if (!(!isBlacklistedCause || i.getProtectionBoundingBox().contains(to.toVector()) && i.onIsland(player.getLocation()))) {
                e.setCancelled(true);
            }
            if (boxedEnderPearlFlag.isPresent() && ((Flag)boxedEnderPearlFlag.get()).isSetForWorld(to.getWorld()) && cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                e.setCancelled(false);
            }
            this.show.showBorder(player);
        }, () -> {
            if (isBlacklistedCause) {
                e.setCancelled(true);
                return;
            }
            this.show.hideBorder(User.getInstance((Player)player));
            this.show.showBorder(player);
        }));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerLeaveIsland(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (!this.isOn(p)) {
            return;
        }
        Location from = e.getFrom();
        if (!this.outsideCheck(e.getPlayer(), from, e.getTo())) {
            return;
        }
        if (this.addon.getIslands().getProtectedIslandAt(from).isPresent()) {
            e.setCancelled(true);
            this.inTeleport.add(p.getUniqueId());
            Util.teleportAsync((Entity)p, (Location)from).thenRun(() -> this.inTeleport.remove(p.getUniqueId()));
            return;
        }
        this.addon.getIslands().getIslandAt(p.getLocation()).ifPresent(i -> {
            Vector unitVector = i.getProtectionCenter().toVector().subtract(p.getLocation().toVector()).normalize().multiply(new Vector(1, 0, 1));
            if (unitVector.lengthSquared() <= 0.0) {
                return;
            }
            RayTraceResult r = i.getProtectionBoundingBox().rayTrace(p.getLocation().toVector(), unitVector, (double)i.getRange());
            if (r != null && this.checkFinite(r.getHitPosition())) {
                this.inTeleport.add(p.getUniqueId());
                Location targetPos = r.getHitPosition().toLocation(p.getWorld(), p.getLocation().getYaw(), p.getLocation().getPitch());
                if (!e.getPlayer().isFlying() && !this.addon.getIslands().isSafeLocation(targetPos)) {
                    switch (targetPos.getWorld().getEnvironment()) {
                        case NETHER: {
                            targetPos.getBlock().getRelative(BlockFace.DOWN).setType(Material.NETHERRACK);
                            break;
                        }
                        case THE_END: {
                            targetPos.getBlock().getRelative(BlockFace.DOWN).setType(Material.END_STONE);
                            break;
                        }
                        default: {
                            targetPos.getBlock().getRelative(BlockFace.DOWN).setType(Material.STONE);
                        }
                    }
                }
                Util.teleportAsync((Entity)p, (Location)targetPos).thenRun(() -> this.inTeleport.remove(p.getUniqueId()));
            }
        });
    }

    public boolean checkFinite(Vector toCheck) {
        return NumberConversions.isFinite((double)toCheck.getX()) && NumberConversions.isFinite((double)toCheck.getY()) && NumberConversions.isFinite((double)toCheck.getZ());
    }

    private boolean outsideCheck(Player player, Location from, Location to) {
        User user = Objects.requireNonNull(User.getInstance((Player)player));
        if (from.getWorld() != null && from.getWorld().equals((Object)to.getWorld()) && from.toVector().multiply(XZ).equals((Object)to.toVector().multiply(XZ)) || !this.addon.inWorld(player.getWorld()) || user.getPlayer().getGameMode() == GameMode.SPECTATOR || !user.getMetaData("Stranger_border_state").map(MetaDataValue::asBoolean).orElse(true).booleanValue()) {
            return false;
        }
        return this.addon.getIslands().getIslandAt(to).filter(i -> !i.onIsland(to)).isPresent();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityMount(EntityMountEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || !this.isOn(player = (Player)entity)) {
            return;
        }
        this.mountedPlayers.put(player, Bukkit.getScheduler().runTaskTimer((Plugin)this.addon.getPlugin(), () -> {
            Location loc = player.getLocation();
            if (!this.addon.inWorld(loc.getWorld())) {
                return;
            }
            if (player.getWorldBorder() != null && !player.getWorldBorder().isInside(loc) && !event.getMount().eject()) {
                EntityDismountEvent dismountEvent = new EntityDismountEvent((Entity)player, event.getMount());
                Bukkit.getPluginManager().callEvent((Event)dismountEvent);
            }
        }, 1L, 20L));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityDismount(EntityDismountEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isOn(player)) {
            BukkitTask task = this.mountedPlayers.get(player);
            if (task == null) {
                return;
            }
            task.cancel();
            this.mountedPlayers.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        if (this.isOn(player) && !e.getFrom().toVector().equals((Object)e.getTo().toVector())) {
            this.show.refreshView(User.getInstance((Player)e.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onVehicleMove(VehicleMoveEvent e) {
        if (!e.getFrom().toVector().equals((Object)e.getTo().toVector())) {
            e.getVehicle().getPassengers().stream().filter(Player.class::isInstance).map(Player.class::cast).filter(this::isOn).forEach(p -> this.show.refreshView(User.getInstance((Player)p)));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onProtectionRangeChange(IslandProtectionRangeChangeEvent e) {
        e.getIsland().getPlayersOnIsland().forEach(player -> {
            if (this.isOn((Player)player)) {
                this.show.hideBorder(User.getInstance((Player)player));
                this.show.showBorder((Player)player);
            }
        });
    }
}

