/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.database.objects.adapters.Adapter;
import world.bentobox.bentobox.database.objects.adapters.FlagSerializer;
import world.bentobox.bentobox.database.objects.adapters.FlagSerializer2;
import world.bentobox.stranger.border.BorderType;

@StoreAt(filename="config.yml", path="addons/StrangerRealms")
@ConfigComment(value="StrangerRealms Configuration [version]")
public class Settings
implements WorldSettings {
    @ConfigComment.Line(value={@ConfigComment(value="Player Command. What command users will run to access their claim."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="strangerrealms.command.player")
    private String playerCommandAliases = "st strange";
    @ConfigComment.Line(value={@ConfigComment(value="The admin command."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="strangerrealms.command.admin")
    private String adminCommandAliases = "stranger";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for new player command call."), @ConfigComment(value="Sub-command of main player command that will be run on first player command call."), @ConfigComment(value="By default it is sub-command 'create'.")})
    @ConfigEntry(path="strangerrealms.command.new-player-action")
    private String defaultNewPlayerAction = "spawn";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for player command."), @ConfigComment(value="Sub-command of main player command that will be run on each player command call."), @ConfigComment(value="By default it is sub-command 'go'.")})
    @ConfigEntry(path="strangerrealms.command.default-action")
    private String defaultPlayerAction = "go";
    @ConfigComment(value="Friendly name for this world. Used in admin commands. Must be a single word")
    @ConfigEntry(path="world.friendly-name")
    private String friendlyName = "StrangerRealms";
    @ConfigComment.Line(value={@ConfigComment(value="Name of the world - if it does not exist then it will be generated."), @ConfigComment(value="It acts like a prefix for nether and end (e.g. stranger-world, stranger-world_nether, stranger-world_end)")})
    @ConfigEntry(path="world.world-name")
    private String worldName = "stranger-world";
    @ConfigComment(value="World seed.")
    @ConfigEntry(path="world.generator.seed", needsReset=true)
    private long seed = 602103456450L;
    @ConfigComment.Line(value={@ConfigComment(value="World difficulty setting - PEACEFUL, EASY, NORMAL, HARD"), @ConfigComment(value="Other plugins may override this setting")})
    @ConfigEntry(path="world.difficulty")
    private Difficulty difficulty = Difficulty.NORMAL;
    @ConfigComment.Line(value={@ConfigComment(value="Disable world border"), @ConfigComment(value="Set to true to disable the worldborder feature.")})
    @ConfigEntry(path="world.disable-worldborder")
    private boolean disableWorldBorder = false;
    @ConfigComment.Line(value={@ConfigComment(value="Use manual world border sizing"), @ConfigComment(value="Set to true to overide the automatic world border sizing based on the number of online players.")})
    @ConfigEntry(path="world.manual-border-size")
    private boolean manualBorderSize = false;
    @ConfigComment(value="Global border size increase per online player in blocks. Radius size.")
    @ConfigEntry(path="world.barrier-increase-blocks")
    private int barrierIncreaseBlocks = 320;
    @ConfigComment.Line(value={@ConfigComment(value="Global border reduction speed. How fast the global border will shrink if it needs to do so."), @ConfigComment(value="Per block reduction time in seconds.")})
    @ConfigEntry(path="world.barrier-reduction-speed")
    private int barrierReductionSpeed = 10;
    @ConfigComment(value="Allow structures to generate")
    @ConfigEntry(path="world.allow-structures")
    private boolean allowStructures = true;
    @ConfigComment(value="Maximum number of claims in the world. Set to -1 or 0 for unlimited.")
    @ConfigEntry(path="world.max-claims")
    private int maxIslands = -1;
    @ConfigComment.Line(value={@ConfigComment(value="The number of concurrent claims a player can have"), @ConfigComment(value="A value of 0 will use the BentoBox config.yml default")})
    @ConfigEntry(path="world.concurrent-claims")
    private int concurrentIslands = 3;
    @ConfigComment(value="Disallow team members from having their own claim.")
    @ConfigEntry(path="world.disallow-team-member-claims")
    private boolean disallowTeamMemberIslands = true;
    @ConfigComment.Line(value={@ConfigComment(value="Spawn limits. These override the limits set in bukkit.yml"), @ConfigComment(value="If set to a negative number, the server defaults will be used")})
    @ConfigEntry(path="world.spawn-limits.monsters")
    private int spawnLimitMonsters = -1;
    @ConfigEntry(path="world.spawn-limits.animals")
    private int spawnLimitAnimals = -1;
    @ConfigEntry(path="world.spawn-limits.water-animals")
    private int spawnLimitWaterAnimals = -1;
    @ConfigEntry(path="world.spawn-limits.ambient")
    private int spawnLimitAmbient = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Setting to 0 will disable animal spawns, but this is not recommended. Minecraft default is 400."), @ConfigComment(value="A negative value uses the server default")})
    @ConfigEntry(path="world.spawn-limits.ticks-per-animal-spawns")
    private int ticksPerAnimalSpawns = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Setting to 0 will disable monster spawns, but this is not recommended. Minecraft default is 400."), @ConfigComment(value="A negative value uses the server default")})
    @ConfigEntry(path="world.spawn-limits.ticks-per-monster-spawns")
    private int ticksPerMonsterSpawns = -1;
    @ConfigComment.Line(value={@ConfigComment(value="The maximum number of players a player can ban at any one time in this game mode."), @ConfigComment(value="The permission stranger.ban.maxlimit.X where X is a number can also be used per player"), @ConfigComment(value="-1 = unlimited")})
    @ConfigEntry(path="world.ban-limit")
    private int banLimit = -1;
    @ConfigComment(value="Generate Nether - if this is false, the nether world will not be made.")
    @ConfigEntry(path="world.nether.generate")
    private boolean netherGenerate = true;
    @ConfigComment(value="Make the UpsideDown nether - this is a nether that mirrors the overworld")
    @ConfigEntry(path="world.nether.upsidedown.generate")
    private boolean useUpsideDown = true;
    @ConfigComment.Line(value={@ConfigComment(value="Level of destruction of UpsideDown nether in %. Default is 5%."), @ConfigComment(value="The UpsideDown is not pretty like the overworld...")})
    @ConfigEntry(path="world.nether.upsidedown.attrition")
    private int attrition = 5;
    @ConfigComment.Line(value={@ConfigComment(value="Chance that redstone events in the UpsideDown will trigger in the OverWorld."), @ConfigComment(value="The redstone item or block must exist in the same location in both worlds to be triggered.")})
    @ConfigEntry(path="world.nether.upsidedown.redstone-chance")
    private int redstoneChance = 100;
    @ConfigComment.Line(value={@ConfigComment(value="Maximum number of chests to fill in a chunk. Default is 3, unlimited is -1."), @ConfigComment(value="Chests get filled with random loot.")})
    @ConfigEntry(path="world.nether.upsidedown.chest-fills")
    private int chestFills = 3;
    @ConfigComment.Line(value={@ConfigComment(value="End World - if this is false, the end world will not be made and access to"), @ConfigComment(value="the end will not occur. Other plugins may still enable portal usage.")})
    @ConfigEntry(path="world.end.generate")
    private boolean endGenerate = true;
    @ConfigComment(value="Mob white list - these mobs will NOT be removed when player's log in or go to their claim")
    @ConfigEntry(path="world.remove-mobs-whitelist")
    private Set<EntityType> removeMobsWhitelist = new HashSet<EntityType>();
    @ConfigComment(value="World flags. These are boolean settings for various flags for this world")
    @ConfigEntry(path="world.flags")
    private Map<String, Boolean> worldFlags = new HashMap<String, Boolean>();
    @ConfigComment.Line(value={@ConfigComment(value="These are the default protection settings for new claim."), @ConfigComment(value="The value is the minimum claim rank required allowed to do the action"), @ConfigComment(value="Ranks are the following:"), @ConfigComment(value="  VISITOR   = 0"), @ConfigComment(value="  COOP      = 200"), @ConfigComment(value="  TRUSTED   = 400"), @ConfigComment(value="  MEMBER    = 500"), @ConfigComment(value="  SUB-OWNER = 900"), @ConfigComment(value="  OWNER     = 1000")})
    @ConfigEntry(path="world.default-claim-flags")
    @Adapter(value=FlagSerializer.class)
    private Map<Flag, Integer> defaultIslandFlags = new HashMap<Flag, Integer>();
    @ConfigComment(value="These are the default settings for new claims")
    @ConfigEntry(path="world.default-claim-settings")
    @Adapter(value=FlagSerializer2.class)
    private Map<Flag, Integer> defaultIslandSettings = new HashMap<Flag, Integer>();
    @ConfigComment.Line(value={@ConfigComment(value="These settings/flags are hidden from users"), @ConfigComment(value="Ops can toggle hiding in-game using SHIFT-LEFT-CLICK on flags in settings")})
    @ConfigEntry(path="world.hidden-flags")
    private List<String> hiddenFlags = new ArrayList<String>();
    @ConfigComment(value="Visitor banned commands - Visitors to claims cannot use these commands in this world")
    @ConfigEntry(path="world.visitor-banned-commands")
    private List<String> visitorBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Size of a single player claim."), @ConfigComment(value="A claim exists every dimension : Overworld, Nether and End.")})
    @ConfigEntry(path="claim.size")
    private int islandDistance = 32;
    @ConfigComment.Line(value={@ConfigComment(value="Default max team size"), @ConfigComment(value="Team members can increase the size of the claim."), @ConfigComment(value="Permission size cannot be less than the default below. ")})
    @ConfigEntry(path="claim.max-team-size")
    private int maxTeamSize = 4;
    @ConfigComment(value="Claim size bonus in bocks for each team member")
    @ConfigEntry(path="claim.member-bonus")
    private int memberBonus = 32;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of coop rank members per claim."), @ConfigComment(value="Coop members loose status when they logoff or their inviter logs off."), @ConfigComment(value="Coop members do not increase the size of the claim."), @ConfigComment(value="Players can have the stranger.coop.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="claim.max-coop-size")
    private int maxCoopSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of trusted rank members per claim."), @ConfigComment(value="Trusted members retain the status continuously."), @ConfigComment(value="Trusted members do not increase the size of the claim."), @ConfigComment(value="Players can have the stranger.trust.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="claim.max-trusted-size")
    private int maxTrustSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of home teleports a player can have. Min = 1"), @ConfigComment(value="Accessed via /is sethome <number> or /is go <number>")})
    @ConfigEntry(path="claim.max-homes")
    private int maxHomes = 5;
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player joins an claim or creates one."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * \"[SUDO] bbox version\""), @ConfigComment(value="   * \"give [player] stick 1\"")})
    @ConfigEntry(path="claim.commands.on-join")
    private List<String> onJoinCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player leaves a claim or gets kicked from it."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'give [player] stick 1'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="claim.commands.on-leave")
    private List<String> onLeaveCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands that should be executed when the player respawns after death if Flags.ISLAND_RESPAWN is true."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'give [player] stick 1'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="claim.commands.on-respawn")
    private List<String> onRespawnCommands = new ArrayList<String>();
    @ConfigComment(value="Allow setting home in the nether.")
    @ConfigEntry(path="claim.sethome.nether.allow")
    private boolean allowSetHomeInNether = true;
    @ConfigEntry(path="claim.sethome.nether.require-confirmation")
    private boolean requireConfirmationToSetHomeInNether = true;
    @ConfigComment(value="Allow setting home in the end.")
    @ConfigEntry(path="claim.sethome.the-end.allow")
    private boolean allowSetHomeInTheEnd = true;
    @ConfigEntry(path="claim.sethome.the-end.require-confirmation")
    private boolean requireConfirmationToSetHomeInTheEnd = true;
    @ConfigComment.Line(value={@ConfigComment(value="Blocked mobs."), @ConfigComment(value="List of mobs that should not spawn.")})
    @ConfigEntry(path="protection.block-mobs")
    private List<String> mobLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Invincible visitors. List of damages that will not affect visitors."), @ConfigComment(value="Make list blank if visitors should receive all damages")})
    @ConfigEntry(path="protection.invincible-visitors")
    private List<String> ivSettings = new ArrayList<String>();
    @ConfigComment(value="These settings should not be edited")
    @ConfigEntry(path="do-not-edit-these-settings.reset-epoch")
    private long resetEpoch = 0L;

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public int getIslandDistance() {
        return this.islandDistance;
    }

    public int getIslandProtectionRange() {
        return this.islandDistance;
    }

    public int getIslandStartX() {
        return 0;
    }

    public int getIslandStartZ() {
        return 0;
    }

    public int getIslandXOffset() {
        return 0;
    }

    public int getIslandZOffset() {
        return 0;
    }

    public int getIslandHeight() {
        return -64;
    }

    public boolean isUseOwnGenerator() {
        return false;
    }

    public int getSeaHeight() {
        return 0;
    }

    public int getMaxIslands() {
        return this.maxIslands;
    }

    public GameMode getDefaultGameMode() {
        return GameMode.SURVIVAL;
    }

    public boolean isNetherGenerate() {
        return this.netherGenerate;
    }

    public boolean isNetherIslands() {
        return true;
    }

    public int getNetherSpawnRadius() {
        return 32;
    }

    public boolean isEndGenerate() {
        return this.endGenerate;
    }

    public boolean isEndIslands() {
        return false;
    }

    public boolean isDragonSpawn() {
        return false;
    }

    public Set<EntityType> getRemoveMobsWhitelist() {
        return this.removeMobsWhitelist;
    }

    public Map<String, Boolean> getWorldFlags() {
        return this.worldFlags;
    }

    public Map<Flag, Integer> getDefaultIslandFlags() {
        return this.defaultIslandFlags;
    }

    public Map<Flag, Integer> getDefaultIslandSettings() {
        return this.defaultIslandSettings;
    }

    public List<String> getHiddenFlags() {
        return this.hiddenFlags;
    }

    public List<String> getVisitorBannedCommands() {
        return this.visitorBannedCommands;
    }

    public List<String> getFallingBannedCommands() {
        return Collections.emptyList();
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public int getMaxHomes() {
        return this.maxHomes;
    }

    public int getResetLimit() {
        return -1;
    }

    public boolean isLeaversLoseReset() {
        return false;
    }

    public boolean isKickedKeepInventory() {
        return true;
    }

    public boolean isCreateIslandOnFirstLoginEnabled() {
        return false;
    }

    public int getCreateIslandOnFirstLoginDelay() {
        return 0;
    }

    public boolean isCreateIslandOnFirstLoginAbortOnLogout() {
        return true;
    }

    public boolean isOnJoinResetMoney() {
        return false;
    }

    public boolean isOnJoinResetInventory() {
        return false;
    }

    public boolean isOnJoinResetEnderChest() {
        return false;
    }

    public boolean isOnLeaveResetMoney() {
        return false;
    }

    public boolean isOnLeaveResetInventory() {
        return false;
    }

    public boolean isOnLeaveResetEnderChest() {
        return false;
    }

    public boolean isDeathsCounted() {
        return false;
    }

    public boolean isAllowSetHomeInNether() {
        return this.allowSetHomeInNether;
    }

    public boolean isAllowSetHomeInTheEnd() {
        return this.allowSetHomeInTheEnd;
    }

    public boolean isRequireConfirmationToSetHomeInNether() {
        return this.requireConfirmationToSetHomeInNether;
    }

    public boolean isRequireConfirmationToSetHomeInTheEnd() {
        return this.requireConfirmationToSetHomeInTheEnd;
    }

    public int getDeathsMax() {
        return 0;
    }

    public boolean isTeamJoinDeathReset() {
        return false;
    }

    public List<String> getGeoLimitSettings() {
        return Collections.emptyList();
    }

    public List<String> getIvSettings() {
        return this.ivSettings;
    }

    public long getResetEpoch() {
        return this.resetEpoch;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public void setIslandDistance(int islandDistance) {
        this.islandDistance = islandDistance;
    }

    public void setIslandProtectionRange(int islandProtectionRange) {
        this.islandDistance = islandProtectionRange;
    }

    public void setMaxIslands(int maxIslands) {
        this.maxIslands = maxIslands;
    }

    public void setNetherGenerate(boolean netherGenerate) {
        this.netherGenerate = netherGenerate;
    }

    public void setEndGenerate(boolean endGenerate) {
        this.endGenerate = endGenerate;
    }

    public void setRemoveMobsWhitelist(Set<EntityType> removeMobsWhitelist) {
        this.removeMobsWhitelist = removeMobsWhitelist;
    }

    public void setWorldFlags(Map<String, Boolean> worldFlags) {
        this.worldFlags = worldFlags;
    }

    public void setDefaultIslandFlags(Map<Flag, Integer> defaultIslandFlags) {
        this.defaultIslandFlags = defaultIslandFlags;
    }

    public void setDefaultIslandSettings(Map<Flag, Integer> defaultIslandSettings) {
        this.defaultIslandSettings = defaultIslandSettings;
    }

    public void setHiddenFlags(List<String> hiddenFlags) {
        this.hiddenFlags = hiddenFlags;
    }

    public void setVisitorBannedCommands(List<String> visitorBannedCommands) {
        this.visitorBannedCommands = visitorBannedCommands;
    }

    public void setMaxTeamSize(int maxTeamSize) {
        this.maxTeamSize = maxTeamSize;
    }

    public void setMaxHomes(int maxHomes) {
        this.maxHomes = maxHomes;
    }

    public void setIvSettings(List<String> ivSettings) {
        this.ivSettings = ivSettings;
    }

    public void setAllowSetHomeInNether(boolean allowSetHomeInNether) {
        this.allowSetHomeInNether = allowSetHomeInNether;
    }

    public void setAllowSetHomeInTheEnd(boolean allowSetHomeInTheEnd) {
        this.allowSetHomeInTheEnd = allowSetHomeInTheEnd;
    }

    public void setRequireConfirmationToSetHomeInNether(boolean requireConfirmationToSetHomeInNether) {
        this.requireConfirmationToSetHomeInNether = requireConfirmationToSetHomeInNether;
    }

    public void setRequireConfirmationToSetHomeInTheEnd(boolean requireConfirmationToSetHomeInTheEnd) {
        this.requireConfirmationToSetHomeInTheEnd = requireConfirmationToSetHomeInTheEnd;
    }

    public void setResetEpoch(long resetEpoch) {
        this.resetEpoch = resetEpoch;
    }

    public String getPermissionPrefix() {
        return "stranger";
    }

    public boolean isWaterUnsafe() {
        return false;
    }

    public int getBanLimit() {
        return this.banLimit;
    }

    public void setBanLimit(int banLimit) {
        this.banLimit = banLimit;
    }

    public String getPlayerCommandAliases() {
        return this.playerCommandAliases;
    }

    public void setPlayerCommandAliases(String playerCommandAliases) {
        this.playerCommandAliases = playerCommandAliases;
    }

    public String getAdminCommandAliases() {
        return this.adminCommandAliases;
    }

    public void setAdminCommandAliases(String adminCommandAliases) {
        this.adminCommandAliases = adminCommandAliases;
    }

    public boolean isDeathsResetOnNewIsland() {
        return false;
    }

    @NotNull
    public List<String> getOnJoinCommands() {
        return this.onJoinCommands;
    }

    public void setOnJoinCommands(List<String> onJoinCommands) {
        this.onJoinCommands = onJoinCommands;
    }

    @NotNull
    public List<String> getOnLeaveCommands() {
        return this.onLeaveCommands;
    }

    public void setOnLeaveCommands(List<String> onLeaveCommands) {
        this.onLeaveCommands = onLeaveCommands;
    }

    @NotNull
    public List<String> getOnRespawnCommands() {
        return this.onRespawnCommands;
    }

    public void setOnRespawnCommands(List<String> onRespawnCommands) {
        this.onRespawnCommands = onRespawnCommands;
    }

    public boolean isOnJoinResetHealth() {
        return false;
    }

    public boolean isOnJoinResetHunger() {
        return false;
    }

    public boolean isOnJoinResetXP() {
        return false;
    }

    public boolean isOnLeaveResetHealth() {
        return false;
    }

    public boolean isOnLeaveResetHunger() {
        return false;
    }

    public boolean isOnLeaveResetXP() {
        return false;
    }

    public boolean isPasteMissingIslands() {
        return false;
    }

    public boolean isTeleportPlayerToIslandUponIslandCreation() {
        return true;
    }

    public int getSpawnLimitMonsters() {
        return this.spawnLimitMonsters;
    }

    public void setSpawnLimitMonsters(int spawnLimitMonsters) {
        this.spawnLimitMonsters = spawnLimitMonsters;
    }

    public int getSpawnLimitAnimals() {
        return this.spawnLimitAnimals;
    }

    public void setSpawnLimitAnimals(int spawnLimitAnimals) {
        this.spawnLimitAnimals = spawnLimitAnimals;
    }

    public int getSpawnLimitWaterAnimals() {
        return this.spawnLimitWaterAnimals;
    }

    public void setSpawnLimitWaterAnimals(int spawnLimitWaterAnimals) {
        this.spawnLimitWaterAnimals = spawnLimitWaterAnimals;
    }

    public int getSpawnLimitAmbient() {
        return this.spawnLimitAmbient;
    }

    public void setSpawnLimitAmbient(int spawnLimitAmbient) {
        this.spawnLimitAmbient = spawnLimitAmbient;
    }

    public int getTicksPerAnimalSpawns() {
        return this.ticksPerAnimalSpawns;
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    public int getTicksPerMonsterSpawns() {
        return this.ticksPerMonsterSpawns;
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    public int getMaxCoopSize() {
        return this.maxCoopSize;
    }

    public void setMaxCoopSize(int maxCoopSize) {
        this.maxCoopSize = maxCoopSize;
    }

    public int getMaxTrustSize() {
        return this.maxTrustSize;
    }

    public void setMaxTrustSize(int maxTrustSize) {
        this.maxTrustSize = maxTrustSize;
    }

    public String getDefaultNewPlayerAction() {
        return this.defaultNewPlayerAction;
    }

    public void setDefaultNewPlayerAction(String defaultNewPlayerAction) {
        this.defaultNewPlayerAction = defaultNewPlayerAction;
    }

    public String getDefaultPlayerAction() {
        return this.defaultPlayerAction;
    }

    public void setDefaultPlayerAction(String defaultPlayerAction) {
        this.defaultPlayerAction = defaultPlayerAction;
    }

    public List<String> getMobLimitSettings() {
        return this.mobLimitSettings;
    }

    public void setMobLimitSettings(List<String> mobLimitSettings) {
        this.mobLimitSettings = mobLimitSettings;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public boolean isCheckForBlocks() {
        return false;
    }

    public boolean isMakeNetherPortals() {
        return true;
    }

    public int getSeedX() {
        return 0;
    }

    public int getSeedZ() {
        return 0;
    }

    public int getNetherSeedX() {
        return 0;
    }

    public int getNetherSeedZ() {
        return 0;
    }

    public int getEndSeedX() {
        return 0;
    }

    public int getEndSeedZ() {
        return 0;
    }

    public int getConcurrentIslands() {
        if (this.concurrentIslands <= 0) {
            return BentoBox.getInstance().getSettings().getIslandNumber();
        }
        return this.concurrentIslands;
    }

    public void setConcurrentIslands(int concurrentIslands) {
        this.concurrentIslands = concurrentIslands;
    }

    public boolean isDisallowTeamMemberIslands() {
        return this.disallowTeamMemberIslands;
    }

    public void setDisallowTeamMemberIslands(boolean disallowTeamMemberIslands) {
        this.disallowTeamMemberIslands = disallowTeamMemberIslands;
    }

    public boolean isAllowStructures() {
        return this.allowStructures;
    }

    public void setAllowStructures(boolean allowStructures) {
        this.allowStructures = allowStructures;
    }

    public BorderType getType() {
        return BorderType.VANILLA;
    }

    public boolean isUseBarrierBlocks() {
        return false;
    }

    public boolean isShowParticles() {
        return true;
    }

    public int getBarrierReductionSpeed() {
        return this.barrierReductionSpeed;
    }

    public void setBarrierReductionSpeed(int barrierReductionSpeed) {
        this.barrierReductionSpeed = barrierReductionSpeed;
    }

    public int getBarrierIncreaseBlocks() {
        return this.barrierIncreaseBlocks;
    }

    public void setBarrierIncreaseBlocks(int barrierIncreaseBlocks) {
        this.barrierIncreaseBlocks = barrierIncreaseBlocks;
    }

    public int getMemberBonus() {
        return this.memberBonus;
    }

    public void setMemberBonus(int memberBonus) {
        this.memberBonus = memberBonus;
    }

    public boolean isManualBorderSize() {
        return this.manualBorderSize;
    }

    public void setManualBorderSize(boolean manualBorderSize) {
        this.manualBorderSize = manualBorderSize;
    }

    public boolean isDisableWorldBorder() {
        return this.disableWorldBorder;
    }

    public void setDisableWorldBorder(boolean disableWorldBorder) {
        this.disableWorldBorder = disableWorldBorder;
    }

    public boolean isUseUpsideDown() {
        return this.useUpsideDown;
    }

    public void setUseUpsideDown(boolean useUpsideDown) {
        this.useUpsideDown = useUpsideDown;
    }

    public int getAttrition() {
        return this.attrition;
    }

    public void setAttrition(int attrition) {
        this.attrition = attrition;
    }

    public int getChestFills() {
        return this.chestFills;
    }

    public void setChestFills(int chestFills) {
        this.chestFills = chestFills;
    }

    public int getRedstoneChance() {
        this.redstoneChance = Math.clamp((long)this.redstoneChance, 0, 100);
        return this.redstoneChance;
    }

    public void setRedstoneChance(int redstoneChance) {
        this.redstoneChance = redstoneChance = Math.clamp((long)redstoneChance, 0, 100);
    }
}

