/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.border;

import java.util.Optional;

public enum BorderType {
    BARRIER(1, "barrier"),
    VANILLA(2, "vanilla");

    private final byte id;
    private final String commandLabel;

    private BorderType(byte id, String commandLabel) {
        this.id = id;
        this.commandLabel = commandLabel;
    }

    public byte getId() {
        return this.id;
    }

    public String getCommandLabel() {
        return this.commandLabel;
    }

    public static Optional<BorderType> fromCommandLabel(String label) {
        for (BorderType bt : BorderType.values()) {
            if (!bt.commandLabel.equalsIgnoreCase(label)) continue;
            return Optional.of(bt);
        }
        return Optional.empty();
    }

    public static Optional<BorderType> fromId(byte id) {
        for (BorderType bt : BorderType.values()) {
            if (bt.getId() != id) continue;
            return Optional.of(bt);
        }
        return Optional.empty();
    }
}

