/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.border;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.stranger.StrangerRealms;
import world.bentobox.stranger.border.BorderShower;

public class ShowBarrier
implements BorderShower {
    private final StrangerRealms addon;
    private static final Particle PARTICLE = Particle.DUST;
    private static final Particle MAX_PARTICLE = Particle.FLAME;
    private static final Particle.DustOptions PARTICLE_DUST_RED = new Particle.DustOptions(Color.RED, 1.0f);
    private static final Particle.DustOptions PARTICLE_DUST_BLUE = new Particle.DustOptions(Color.BLUE, 1.0f);
    private static final int BARRIER_RADIUS = 5;
    private final Map<UUID, Set<BarrierBlock>> barrierBlocks = new HashMap<UUID, Set<BarrierBlock>>();

    public ShowBarrier(StrangerRealms addon) {
        this.addon = addon;
    }

    @Override
    public void showBorder(Player player) {
        if (!this.addon.inWorld(player.getWorld())) {
            return;
        }
        if (!Objects.requireNonNull(User.getInstance((Player)player)).getMetaData("Stranger_border_state").map(MetaDataValue::asBoolean).orElse(true).booleanValue()) {
            return;
        }
        this.addon.getIslands().getIslandAt(player.getLocation()).ifPresent(island -> {
            int offset = 0;
            Location loc = player.getLocation();
            this.showWalls(player, loc, Math.max(island.getMinX(), island.getMinProtectedX() - offset), Math.min(island.getMaxX(), island.getMaxProtectedX() + offset), Math.max(island.getMinZ(), island.getMinProtectedZ() - offset), Math.min(island.getMaxZ(), island.getMaxProtectedZ() + offset), false);
        });
    }

    private void showWalls(Player player, Location loc, int xMin, int xMax, int zMin, int zMax, boolean max) {
        int x;
        int y;
        int z;
        if (loc.getBlockX() - xMin < 5) {
            for (z = Math.max(loc.getBlockZ() - 5, zMin); z < loc.getBlockZ() + 5 && z < zMax; ++z) {
                for (y = -5; y < 5; ++y) {
                    this.showPlayer(player, xMin - 1, loc.getBlockY() + y, z, max);
                }
            }
        }
        if (loc.getBlockZ() - zMin < 5) {
            for (x = Math.max(loc.getBlockX() - 5, xMin); x < loc.getBlockX() + 5 && x < xMax; ++x) {
                for (y = -5; y < 5; ++y) {
                    this.showPlayer(player, x, loc.getBlockY() + y, zMin - 1, max);
                }
            }
        }
        if (xMax - loc.getBlockX() < 5) {
            for (z = Math.max(loc.getBlockZ() - 5, zMin); z < loc.getBlockZ() + 5 && z < zMax; ++z) {
                for (y = -5; y < 5; ++y) {
                    this.showPlayer(player, xMax, loc.getBlockY() + y, z, max);
                }
            }
        }
        if (zMax - loc.getBlockZ() < 5) {
            for (x = Math.max(loc.getBlockX() - 5, xMin); x < loc.getBlockX() + 5 && x < xMax; ++x) {
                for (y = -5; y < 5; ++y) {
                    this.showPlayer(player, x, loc.getBlockY() + y, zMax, max);
                }
            }
        }
    }

    private void showPlayer(Player player, int i, int j, int k, boolean max) {
        if (this.addon.getSettings().isUseBarrierBlocks() && player.getLocation().getBlockX() == i && player.getLocation().getBlockZ() == k) {
            this.teleportPlayer(player);
        }
        Location l = new Location(player.getWorld(), (double)i, (double)j, (double)k);
        Util.getChunkAtAsync((Location)l).thenAccept(c -> {
            if (this.addon.getSettings().isShowParticles()) {
                if (j < player.getWorld().getMinHeight() || j > player.getWorld().getMaxHeight()) {
                    User.getInstance((Player)player).spawnParticle(max ? MAX_PARTICLE : PARTICLE, PARTICLE_DUST_RED, (double)i + 0.5, (double)j + 0.0, (double)k + 0.5);
                } else {
                    User.getInstance((Player)player).spawnParticle(max ? MAX_PARTICLE : PARTICLE, PARTICLE_DUST_BLUE, (double)i + 0.5, (double)j + 0.0, (double)k + 0.5);
                }
            }
            if (this.addon.getSettings().isUseBarrierBlocks() && (l.getBlock().isEmpty() || l.getBlock().isLiquid())) {
                player.sendBlockChange(l, Material.BARRIER.createBlockData());
                this.barrierBlocks.computeIfAbsent(player.getUniqueId(), u -> new HashSet()).add(new BarrierBlock(l, l.getBlock().getBlockData()));
            }
        });
    }

    @Override
    public void teleportPlayer(Player p) {
        this.addon.getIslands().getIslandAt(p.getLocation()).ifPresent(i -> {
            Vector unitVector = i.getCenter().toVector().subtract(p.getLocation().toVector()).normalize().multiply(new Vector(1, 0, 1));
            Location to = p.getLocation().toVector().add(unitVector).toLocation(p.getWorld());
            to.setPitch(p.getLocation().getPitch());
            to.setYaw(p.getLocation().getYaw());
            Util.teleportAsync((Entity)p, (Location)to, (PlayerTeleportEvent.TeleportCause)PlayerTeleportEvent.TeleportCause.PLUGIN);
        });
    }

    @Override
    public void hideBorder(User user) {
        if (this.barrierBlocks.containsKey(user.getUniqueId())) {
            this.barrierBlocks.get(user.getUniqueId()).stream().filter(v -> v.l.getWorld().equals((Object)user.getWorld())).forEach(v -> user.getPlayer().sendBlockChange(v.l, v.oldBlockData));
            this.clearUser(user);
        }
    }

    @Override
    public void clearUser(User user) {
        this.barrierBlocks.remove(user.getUniqueId());
    }

    @Override
    public void refreshView(User user) {
        this.showBorder(user.getPlayer());
    }

    private static class BarrierBlock {
        Location l;
        BlockData oldBlockData;

        public BarrierBlock(Location l, BlockData oldBlockData) {
            this.l = l;
            this.oldBlockData = oldBlockData;
        }
    }
}

