/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.commands.admin;

import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.stranger.StrangerRealms;

public class WorldBorderCommand
extends CompositeCommand {
    private final StrangerRealms addon = (StrangerRealms)this.getAddon();

    public WorldBorderCommand(CompositeCommand islandCommand) {
        super(islandCommand, "worldborder", new String[]{"wb"});
    }

    public void setup() {
        this.setPermission("admin.worldborder");
        this.setOnlyPlayer(false);
        this.setDescription("commands.admin.worldborder.description");
        this.setParametersHelp("commands.admin.worldborder.parameters");
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        return true;
    }

    public boolean execute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            return false;
        }
        return switch (args.getFirst()) {
            case "off" -> this.turnOff(user);
            case "on" -> this.turnOn(user);
            case "info" -> this.showInfo(user);
            case "auto" -> this.setAuto(user);
            case "set" -> this.setSize(user, args);
            default -> {
                user.sendMessage("commands.admin.worldborder.unknown-command", new String[0]);
                yield false;
            }
        };
    }

    private boolean turnOn(User user) {
        this.addon.getSettings().setDisableWorldBorder(false);
        this.addon.saveWorldSettings();
        Bukkit.getServer().getOnlinePlayers().forEach(this.addon.getBorderShower()::showBorder);
        user.sendMessage("general.success", new String[0]);
        this.showInfo(user);
        return true;
    }

    private boolean turnOff(User user) {
        this.addon.getSettings().setDisableWorldBorder(true);
        this.addon.saveWorldSettings();
        this.addon.cancelBorderTask();
        Bukkit.getServer().getOnlinePlayers().stream().map(User::getInstance).forEach(this.addon.getBorderShower()::hideBorder);
        user.sendMessage("general.success", new String[0]);
        return true;
    }

    private boolean setAuto(User user) {
        this.addon.getSettings().setManualBorderSize(false);
        this.addon.saveWorldSettings();
        Bukkit.getServer().getOnlinePlayers().forEach(this.addon.getBorderShower()::showBorder);
        user.sendMessage("general.success", new String[0]);
        this.showInfo(user);
        return true;
    }

    private boolean setSize(User user, List<String> args) {
        if (args.size() != 2) {
            user.sendMessage("commands.admin.worldborder.set-size.needs-value", new String[0]);
            return false;
        }
        String argument = args.get(1);
        try {
            if (argument == null || argument.trim().isEmpty()) {
                user.sendMessage("commands.admin.worldborder.set-size.needs-value", new String[0]);
                return false;
            }
            this.addon.cancelBorderTask();
            int result = Integer.parseInt(argument.trim());
            this.addon.setBorderSize(result);
            this.addon.getSettings().setManualBorderSize(true);
            this.addon.saveWorldSettings();
            Bukkit.getServer().getOnlinePlayers().forEach(this.addon.getBorderShower()::showBorder);
            user.sendMessage("general.success", new String[0]);
            this.showInfo(user);
            return true;
        }
        catch (NumberFormatException e) {
            user.sendMessage("commands.admin.worldborder.set-size.needs-value", new String[0]);
            return false;
        }
    }

    private boolean showInfo(User user) {
        user.sendMessage("commands.admin.worldborder.info", new String[]{"[number]", String.valueOf((int)((StrangerRealms)this.getAddon()).getBorderSize())});
        return true;
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return Optional.of(List.of("on", "off", "set", "auto", "info"));
    }
}

