/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.stranger.commands.player;

import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.NewIsland;
import world.bentobox.bentobox.managers.island.NewIslandLocationStrategy;
import world.bentobox.bentobox.panels.customizable.IslandCreationPanel;
import world.bentobox.stranger.StrangerRealms;
import world.bentobox.stranger.commands.player.ClaimLocationStrategy;

public class ClaimCommand
extends CompositeCommand {
    private final NewIslandLocationStrategy strategy = new ClaimLocationStrategy((StrangerRealms)this.getAddon());

    public ClaimCommand(CompositeCommand playerCommand) {
        super(playerCommand, "claim", new String[0]);
    }

    public void setup() {
        this.setPermission("claim");
        this.setOnlyPlayer(true);
        this.setDescription("commands.claim.description");
    }

    public boolean canExecute(User user, String label, List<String> args) {
        int max;
        if (this.getIslands().getIslandAt(user.getLocation()).isPresent()) {
            user.sendMessage("strangerrealms.errors.already-claimed", new String[0]);
            return false;
        }
        @Nullable Island island = this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId());
        if (island != null && island.isReserved()) {
            return true;
        }
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && island != null && !user.getUniqueId().equals(island.getOwner())) {
            user.sendMessage("commands.island.create.you-cannot-make-team", new String[0]);
            return false;
        }
        int num = this.getIslands().getNumberOfConcurrentIslands(user.getUniqueId(), this.getWorld());
        if (num >= (max = user.getPermissionValue(this.getIWM().getAddon(this.getWorld()).map(Addon::getPermissionPrefix).orElse("") + "island.number", this.getIWM().getWorldSettings(this.getWorld()).getConcurrentIslands()))) {
            user.sendMessage("commands.island.create.you-cannot-make", new String[0]);
            return false;
        }
        if (this.getIWM().getMaxIslands(this.getWorld()) > 0 && this.getIslands().getIslandCount(this.getWorld()) >= (long)this.getIWM().getMaxIslands(this.getWorld())) {
            user.sendMessage("commands.island.create.too-many-islands", new String[0]);
            return false;
        }
        return true;
    }

    public boolean execute(User user, String label, List<String> args) {
        if (this.getPlugin().getBlueprintsManager().getBlueprintBundles((GameModeAddon)this.getAddon()).size() > 1) {
            IslandCreationPanel.openPanel((CompositeCommand)this, (User)user, (String)label, (boolean)false);
            return true;
        }
        return this.makeClaim(user, "default");
    }

    private boolean makeClaim(User user, String name) {
        user.sendMessage("commands.island.create.creating-island", new String[0]);
        try {
            NewIsland.builder().player(user).addon((GameModeAddon)this.getAddon()).reason(IslandEvent.Reason.CREATE).name(name).locationStrategy(this.strategy).noPaste().build();
        }
        catch (IOException e) {
            user.sendMessage(e.getMessage(), new String[0]);
            return false;
        }
        if (this.getSettings().isResetCooldownOnCreate()) {
            this.getParent().getSubCommand("reset").ifPresent(resetCommand -> resetCommand.setCooldown(user.getUniqueId(), this.getSettings().getResetCooldown()));
        }
        return true;
    }
}

